/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.util.List;
import java.util.Map;

public class OraclePatcher
implements IModelComparator {
    @Override
    public Node compare(Node source, Node target, DatabaseInfos sourceInfos, DatabaseInfos targetInfos) {
        return this.compare(source, target);
    }

    private Node compare(Node source, Node target) {
        if (source.getName() == target.getName()) {
            List<? extends Node> children;
            if (source.getName() == NodeFactory.TAG.column && target.getName() == NodeFactory.TAG.column) {
                String[] params = source.getParameterNames();
                for (String param : params) {
                    source.dropParameter(param);
                }
                for (Map.Entry entry : target.getAttributeMap().entrySet()) {
                    source.readParameter(entry.getKey().toString(), (String)entry.getValue());
                }
            }
            if ((children = source.getAllChildren()) != null) {
                for (Node node : children) {
                    Node tChild = target.findChildMatching(node.getKeyValueLowerCase(), node.getName());
                    if (tChild == null) continue;
                    this.compare(node, tChild);
                }
            }
        }
        return source;
    }
}

