/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner.jobs;

import com.inet.dbupdater.IEventDispatchable;
import com.inet.dbupdater.UpdaterEvent;
import com.inet.dbupdater.UpdaterEventDispatcher;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.IJob;
import com.inet.dbupdater.model.Diff;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.SuppressFBWarnings;

public class JobCopyData
implements IJob,
IComposedCommand,
IEventDispatchable {
    private static final Logger LOGGER = LogManager.getLogger((String)"DB Updater");
    private final DatabaseInfos copyFrom;
    private final DatabaseInfos copyTo;
    private Node fromModel;
    private Node toModel;
    private static final int DEFAULT_MAXFETCHSIZE = 500;
    private int maxFetchSize;
    private UpdaterEventDispatcher dispatcher;

    public JobCopyData(DatabaseInfos copyFrom, DatabaseInfos copyTo, Node fromModel, Node toModel) {
        this.copyFrom = copyFrom;
        this.copyTo = copyTo;
        this.fromModel = fromModel;
        this.toModel = toModel;
    }

    @Override
    public void setDispatcher(UpdaterEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    private Node findDatabase(DatabaseInfos dbInfos, Node model) throws SQLException {
        if (model == null) {
            return null;
        }
        if (model.getName() == NodeFactory.TAG.database) {
            return model;
        }
        if (model.getName() == NodeFactory.TAG.dbupdater) {
            if ((model = Diff.findDatabaseByType(model, dbInfos)) != null) {
                return model;
            }
            throw new SQLException("Invalid datamodel for a copy operation!");
        }
        throw new SQLException("Could not determine datamodel for a copy operation! Current model is '" + String.valueOf((Object)model.getName()) + ":" + model.getKeyValueOriginalCase() + "'");
    }

    @Override
    public JobStructure createCommands(DatabaseInfos targetCon, Node node) {
        JobStructure struct = new JobStructure();
        struct.add(this);
        return struct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() throws SQLException {
        this.checkConnection(this.copyFrom, this.fromModel);
        this.checkConnection(this.copyTo, this.toModel);
        PrintWriter logWriter = DriverManager.getLogWriter();
        DriverManager.setLogWriter(null);
        try {
            this.fromModel = this.findDatabase(this.copyFrom, this.fromModel);
            this.toModel = this.findDatabase(this.copyTo, this.toModel);
            boolean failed = false;
            List<? extends Node> children = this.toModel.getChildren(NodeFactory.TAG.table);
            if (children == null) {
                throw new SQLException("There was no table to copy");
            }
            if (this.dispatcher != null) {
                this.dispatcher.setJobCount(this.dispatcher.getJobCount() + children.size());
            }
            for (Node node : children) {
                String tableName = node.getKeyValueOriginalCase();
                Node fromTable = this.fromModel.findChildMatching(tableName, NodeFactory.TAG.table);
                if (fromTable == null) {
                    LOGGER.error((Object)("Table '" + tableName + "' not found in source database!"));
                    failed = true;
                }
                failed |= !this.copyTable(fromTable, node);
            }
            int n = failed ? -1 : 1;
            return n;
        }
        finally {
            if (logWriter != null) {
                DriverManager.setLogWriter(logWriter);
            }
        }
    }

    private String buildPreparedInsert(String table, List<String> colNames) {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("INSERT INTO ");
        b.append(table);
        b.append(" (");
        for (i = 0; i < colNames.size(); ++i) {
            b.append(this.copyTo.getQuote(colNames.get(i)));
            if (i >= colNames.size() - 1) continue;
            b.append(", ");
        }
        b.append(") VALUES (");
        for (i = 0; i < colNames.size(); ++i) {
            b.append("?");
            if (i >= colNames.size() - 1) continue;
            b.append(", ");
        }
        b.append(")");
        return b.toString();
    }

    private boolean copyTable(Node fromTable, Node toTable) throws SQLException {
        String nameFrom = ((ISchemaNode)((Object)fromTable)).getSourceName(this.copyFrom);
        if (this.dispatcher != null) {
            this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "copyingTable", nameFrom));
        }
        PreparedStatement stm = this.copyFrom.getDBConnection().prepareStatement("SELECT * FROM " + nameFrom);
        this.maxFetchSize = Math.min(500, stm.getMaxRows());
        if (this.maxFetchSize == 0) {
            this.maxFetchSize = 500;
        }
        LOGGER.debug((Object)("Setting fetchsize to: " + this.maxFetchSize));
        try {
            stm.setFetchSize(this.maxFetchSize);
        }
        catch (SQLException sqle) {
            LOGGER.debug((Object)("Source statement does not support fetchsize: " + sqle.getMessage()));
        }
        ResultSet source = stm.executeQuery();
        if (source == null) {
            LOGGER.error((Object)("Could not open source table '" + fromTable.getParameter("name") + "'"));
            return false;
        }
        boolean result = false;
        LOGGER.debug((Object)"Copy datasets by prepared insert");
        result = this.copyTableByPreparedInsert(fromTable, toTable, source);
        source.close();
        stm.close();
        return result;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="programatically created sql")
    private boolean copyTableByPreparedInsert(Node fromTable, Node toTable, ResultSet source) throws SQLException {
        ResultSetMetaData sourceMetaData = source.getMetaData();
        int columnCount = sourceMetaData.getColumnCount();
        String nameFrom = ((ISchemaNode)((Object)fromTable)).getSourceName(this.copyFrom);
        String nameTo = ((ISchemaNode)((Object)toTable)).getSourceName(this.copyTo);
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<Integer> colTypes = new ArrayList<Integer>();
        ArrayList<Boolean> colRequiresNullReplace = new ArrayList<Boolean>();
        for (Node node : toTable.getChildren(NodeFactory.TAG.column)) {
            colNames.add(node.getKeyValueOriginalCase());
            try {
                colTypes.add(Integer.valueOf(node.getParameter(IDatabaseInfos.COLUMN_PARAM.data_type.name())));
            }
            catch (Exception e) {
                colTypes.add(4);
            }
            colRequiresNullReplace.add(node.getParameter(IDatabaseInfos.COLUMN_PARAM.column_def.name()) == null && "true".equals(node.getParameter(IDatabaseInfos.COLUMN_PARAM.isnotnullable.name())));
        }
        String toQuery = "SELECT * FROM " + nameTo;
        ResultSet resultSet = this.copyTo.getDBConnection().executeQuery(toQuery + " WHERE 1=0");
        this.copyTo.prepareInsertInto(nameTo, resultSet.getMetaData());
        String query = this.buildPreparedInsert(nameTo, colNames);
        Connection connection = this.copyTo.getDBConnection().getConnection();
        connection.setAutoCommit(false);
        PreparedStatement target = connection.prepareStatement(query);
        try {
            target.setFetchSize(this.maxFetchSize);
        }
        catch (SQLException sqle) {
            LOGGER.debug((Object)("Target statement does not support fetchsize: " + sqle.getMessage()));
        }
        boolean success = true;
        long cnt = 0L;
        int batchCount = 0;
        try {
            while (source.next()) {
                boolean atLeastOneSet = false;
                if (++cnt % 500L == 0L) {
                    LOGGER.debug((Object)("datasets copied: " + cnt));
                }
                if (cnt % 10L == 0L && this.dispatcher != null) {
                    this.dispatcher.notifyListeners(new UpdaterEvent("copyingTableDetails", nameFrom, cnt));
                }
                for (int i = 1; i <= columnCount; ++i) {
                    try {
                        String colName = (String)colNames.get(i - 1);
                        Object data = source.getObject(colName);
                        boolean convertNull = (Boolean)colRequiresNullReplace.get(i - 1);
                        data = this.copyTo.convertData(data, (Integer)colTypes.get(i - 1), convertNull);
                        target.setObject(i, data);
                        atLeastOneSet = true;
                    }
                    catch (SQLException e) {
                        LOGGER.error((Object)("Could not read column " + i + " of table '" + nameFrom + "', reason was: " + e.getMessage()));
                        target.setObject(i, null);
                    }
                    if (atLeastOneSet) continue;
                    throw new SQLException("One dataset of table '" + nameFrom + "' could not be copied!");
                }
                ++batchCount;
                success &= target.executeUpdate() > 0;
                if (cnt % 500L != 0L) continue;
                connection.commit();
            }
            if (batchCount > 0) {
                connection.commit();
            }
            LOGGER.debug((Object)("datasets copied (sum): " + cnt));
        }
        catch (SQLException e) {
            LOGGER.error((Throwable)e);
            throw new SQLException(e.getMessage() + ", table " + nameTo);
        }
        ResultSet rs2 = this.copyTo.getDBConnection().executeQuery(toQuery + " WHERE 1=0");
        this.copyTo.finishInsertInto(nameTo, rs2.getMetaData());
        resultSet.close();
        rs2.close();
        target.close();
        connection.setAutoCommit(true);
        return success;
    }

    boolean hasPrimary(ResultSetMetaData meta) throws SQLException {
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.isAutoIncrement(i)) continue;
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="argument is quoted")
    boolean copyTableByInsertRow(String name, ResultSet source) throws SQLException {
        String toQuery = "SELECT * FROM " + this.copyTo.getQuote(name);
        DBConnection targetCon = this.copyTo.getDBConnection();
        ResultSet rs1 = targetCon.executeQuery(toQuery + " WHERE 1=0");
        this.copyTo.prepareInsertInto(name, rs1.getMetaData());
        Connection connection = targetCon.getConnection();
        connection.setAutoCommit(false);
        Statement insertStm = targetCon.createUpdatableStatement();
        if (insertStm == null) {
            LOGGER.error((Object)("Could not open target table '" + name + "'"));
            return false;
        }
        try {
            insertStm.setFetchSize(this.maxFetchSize);
        }
        catch (SQLException sqle) {
            LOGGER.debug((Object)("Insert statement does not support fetchsize: " + sqle.getMessage()));
        }
        ResultSet target = insertStm.executeQuery(toQuery);
        try {
            target.setFetchSize(this.maxFetchSize);
        }
        catch (SQLException sqle) {
            LOGGER.debug((Object)("Target resultset does not support fetchsize: " + sqle.getMessage()));
        }
        ResultSetMetaData sourceMetaData = source.getMetaData();
        int columns = sourceMetaData.getColumnCount();
        String[] colNames = new String[columns];
        for (int i = 1; i <= columns; ++i) {
            colNames[i - 1] = sourceMetaData.getColumnName(i);
        }
        long cnt = 0L;
        try {
            if (source.getStatement().getResultSetType() == 1003 && source.isBeforeFirst() && source.next() || source.first()) {
                do {
                    if (++cnt % 500L == 0L) {
                        LOGGER.debug((Object)("datasets copied: " + cnt));
                    }
                    if (cnt % 10L == 0L && this.dispatcher != null) {
                        this.dispatcher.notifyListeners(new UpdaterEvent("copyingTableDetails", name, cnt));
                    }
                    target.moveToInsertRow();
                    for (int i = 1; i <= columns; ++i) {
                        String colName = colNames[i - 1];
                        Object data = source.getObject(colName);
                        data = this.copyTo.convertData(data, target.getMetaData().getColumnType(i), false);
                        target.updateObject(colName, data);
                    }
                    target.insertRow();
                    if (cnt % 1000L != 0L) continue;
                    connection.commit();
                } while (source.next());
            }
        }
        catch (SQLException e) {
            LOGGER.error((Throwable)e);
            throw new SQLException(e.getMessage() + ", table " + name);
        }
        connection.commit();
        LOGGER.debug((Object)("datasets copied (sum): " + cnt));
        ResultSet rs2 = targetCon.executeQuery(toQuery + " WHERE 1=0");
        this.copyTo.finishInsertInto(name, rs2.getMetaData());
        rs1.close();
        rs2.close();
        target.close();
        targetCon.close(insertStm);
        connection.setAutoCommit(true);
        return true;
    }

    private void checkConnection(DatabaseInfos dbInfo, Node model) throws SQLException {
        if (dbInfo == null) {
            throw new SQLException("Database not set");
        }
        if (model == null) {
            throw new SQLException("Missing structure data");
        }
        if (dbInfo.getDBConnection() == null) {
            throw new SQLException("Database connection not set");
        }
        DBConnection connection = dbInfo.getDBConnection();
        Connection con = connection.getConnection();
        if (con == null) {
            con = connection.openConnection(dbInfo);
        }
        if (con == null) {
            throw new SQLException("No connection to database " + connection.getJdbcUrl());
        }
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.copydata;
    }

    @Override
    public String getSqlStatement() {
        return null;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        return null;
    }
}

