/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCreateIndexCommand;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;

public class OracleAddPrimaryCommand
extends DefaultCreateIndexCommand {
    private Node tableName;
    private DatabaseInfos dbInfo;

    public OracleAddPrimaryCommand(DatabaseInfos dbInfo, Node tableName) {
        super(dbInfo, tableName);
        this.tableName = tableName;
        this.dbInfo = dbInfo;
    }

    @Override
    public void printCreatePrefix(Node element, StringBuilder b) {
        b.append("ALTER TABLE ").append(((ISchemaNode)((Object)this.tableName)).getSourceName(this.dbInfo));
    }

    @Override
    public void printName(Node element, StringBuilder b) {
        b.append(" ADD ");
        String name = element.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
        if (name != null) {
            b.append("CONSTRAINT ");
            b.append(this.dbInfo.getQuote(this.dbInfo.checkIndexName(name)));
            b.append(" ");
        }
        b.append("PRIMARY KEY ");
    }

    @Override
    public void printTableTarget(Node element, StringBuilder b) {
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return element.getName() == NodeFactory.TAG.index && "PRIMARY".equalsIgnoreCase(element.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.index_name));
    }
}

