/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.IFunctionProcCommand;
import com.inet.dbupdater.model.Node;
import java.sql.SQLException;
import java.util.List;

public class MSSQLCreateProcedureCommand
implements IFunctionProcCommand {
    private final DatabaseInfos dbInfo;
    private Node element;

    public MSSQLCreateProcedureCommand(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.createroutines;
    }

    @Override
    public String getSqlStatement() {
        String content = this.element.getContent();
        if (content == null || content.length() == 0) {
            content = this.element.getDiffTarget().getContent();
        }
        if (content == null || content.length() == 0) {
            content = this.element.getDiffSource().getContent();
        }
        return content;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        this.element = element;
        return null;
    }
}

