/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultCreateIndexCommand
implements IComposedCommand {
    private DatabaseInfos dbInfo;
    private Node tableName;
    private String indexName = null;
    private List<Node> indexColumns = new ArrayList<Node>();
    private static final Comparator<Node> INDEXSORTER = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            int o1Pos = 0;
            int o2Pos = 0;
            if (o1 != null && o1.getAttributeMap().containsKey((Object)IDatabaseInfos.INDEX_PARAM.ordinal_position)) {
                o1Pos = Integer.parseInt(o1.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.ordinal_position));
            }
            if (o2 != null && o2.getAttributeMap().containsKey((Object)IDatabaseInfos.INDEX_PARAM.ordinal_position)) {
                o2Pos = Integer.parseInt(o2.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.ordinal_position));
            }
            return o1Pos - o2Pos;
        }
    };

    public DefaultCreateIndexCommand(DatabaseInfos dbInfo, Node tableNode) {
        this.dbInfo = dbInfo;
        this.tableName = tableNode;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        if (this.indexName == null) {
            this.indexName = element.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.index_name);
        }
        this.indexColumns.add(element);
        return null;
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    public void printCreatePrefix(Node element, StringBuilder b) {
        b.append("CREATE ");
        AttributeMap<String> attributes = element.getAttributeMap();
        if (!attributes.containsKey((Object)IDatabaseInfos.INDEX_PARAM.non_unique) || !"true".equals(attributes.get((Object)IDatabaseInfos.INDEX_PARAM.non_unique))) {
            b.append("UNIQUE ");
        }
        b.append("INDEX ");
    }

    public void printName(Node element, StringBuilder b) {
        try {
            String indexName = this.dbInfo.getQuoteIdentiferIfNeeded(element.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.index_name));
            indexName = this.dbInfo.checkIndexName(indexName);
            b.append(indexName).append(" ");
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void printTableTarget(Node element, StringBuilder b) {
        b.append("ON ").append(((ISchemaNode)((Object)this.tableName)).getName(this.dbInfo)).append("");
    }

    @Override
    public String getSqlStatement() {
        if (this.indexColumns.size() == 0) {
            return null;
        }
        Node element = this.indexColumns.get(0);
        AttributeMap<String> attributes = element.getAttributeMap();
        if (!attributes.containsKey((Object)IDatabaseInfos.INDEX_PARAM.index_name)) {
            throw new IllegalStateException("Cannot create an unnamed index in table '" + String.valueOf(this.tableName) + "'");
        }
        if (!attributes.containsKey((Object)IDatabaseInfos.INDEX_PARAM.column_name)) {
            throw new IllegalStateException("Cannot create a table index in table '" + String.valueOf(this.tableName) + "' without a column to index");
        }
        StringBuilder b = new StringBuilder();
        this.printCreatePrefix(element, b);
        this.printName(element, b);
        this.printTableTarget(element, b);
        Collections.sort(this.indexColumns, INDEXSORTER);
        b.append('(');
        for (Node column : this.indexColumns) {
            try {
                String columnName = this.dbInfo.getQuoteIdentiferIfNeeded(column.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.column_name));
                b.append(columnName).append(",");
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        b.deleteCharAt(b.length() - 1);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        if (element.getName() == NodeFactory.TAG.index) {
            String string = element.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.index_name);
            if (this.indexName == null || this.indexName.equals(string)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.addindices;
    }
}

