/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.IFunctionProcCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DefaultCreateFunctionCommand
implements IFunctionProcCommand {
    private final DatabaseInfos dbInfo;
    private Node element;
    private ArrayList<Column> cols;

    public DefaultCreateFunctionCommand(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.createroutines;
    }

    @Override
    public String getSqlStatement() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE FUNCTION ");
        buffer.append(this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.FUNCTION_HEAD_PARAM.name.name())));
        buffer.append(" (");
        String returntyp = "";
        int count = 0;
        for (Column col : this.cols) {
            if (col.getColNode().getState() == 2) continue;
            String syntax = col.getSQLSyntax();
            if (col.isReturnType()) {
                returntyp = syntax;
                continue;
            }
            if (count > 0) {
                buffer.append(", ");
            }
            buffer.append(syntax);
            ++count;
        }
        buffer.append(" ) RETURNS ");
        buffer.append(returntyp);
        buffer.append(" ");
        String content = this.element.getContent();
        if (content == null || content.length() == 0) {
            content = this.element.getDiffTarget().getContent();
        }
        if (content == null || content.length() == 0) {
            content = this.element.getDiffSource().getContent();
        }
        buffer.append(content);
        return buffer.toString();
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        this.element = element;
        this.cols = new ArrayList();
        for (Node node : element.getChildren(NodeFactory.TAG.column)) {
            this.cols.add(new Column(node));
        }
        return null;
    }

    private class Column {
        private final Node colnode;
        private boolean isReturnType = false;

        public Column(Node colnode) {
            this.colnode = colnode;
        }

        public Node getColNode() {
            return this.colnode;
        }

        private String getSQLSyntax() {
            StringBuffer b = new StringBuffer();
            try {
                AttributeMap<String> attributes = this.colnode.getAttributeMap();
                if (!attributes.containsKey((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.column_name)) {
                    throw new SQLException("Cannot create an empty column in function '" + DefaultCreateFunctionCommand.this.element.getRecentValue(IDatabaseInfos.FUNCTION_HEAD_PARAM.name.name()) + "'");
                }
                if (!attributes.containsKey((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.data_type)) {
                    throw new SQLException("Cannot create a function colum in function '" + DefaultCreateFunctionCommand.this.element.getRecentValue(IDatabaseInfos.FUNCTION_HEAD_PARAM.name.name()) + "' without a data type");
                }
                String funcname = attributes.get((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.column_name).toString();
                if (funcname.length() > 0) {
                    b.append(DefaultCreateFunctionCommand.this.dbInfo.getQuote(funcname)).append(" ");
                } else {
                    this.isReturnType = true;
                }
                int typeInt = Integer.parseInt(this.colnode.getRecentValue(IDatabaseInfos.FUNCTION_COLUMN_PARAM.data_type.name()).toString());
                int size = attributes.containsKey((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.precision) ? Integer.parseInt(this.colnode.getRecentValue(IDatabaseInfos.FUNCTION_COLUMN_PARAM.precision.name()).toString()) : 0;
                int scale = attributes.containsKey((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.scale) ? Integer.parseInt(this.colnode.getRecentValue(IDatabaseInfos.FUNCTION_COLUMN_PARAM.scale.name()).toString()) : 0;
                String originalName = this.colnode.getRecentValue(IDatabaseInfos.FUNCTION_COLUMN_PARAM.type_name.name());
                boolean identity = false;
                String destDataType = DefaultCreateFunctionCommand.this.dbInfo.getDestDataType(typeInt, size, scale, originalName, identity);
                b.append(destDataType);
            }
            catch (SQLException e) {
                LogManager.getLogger((String)"DB Updater").error((Throwable)e);
            }
            return b.toString();
        }

        public boolean isReturnType() {
            return this.isReturnType;
        }
    }
}

