/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases;

import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandFactory;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.modelpatch.IModelPatcher;
import com.inet.dbupdater.databases.modelpatch.ModelPatcherAdapter;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.NodeReference;
import com.inet.logging.LogLevel;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.SuppressFBWarnings;

public class DatabaseInfos
implements Cloneable,
IDatabaseInfos {
    public static final int SYSTEM = 0;
    public static final int TABLE = 1;
    public static final int VIEW = 2;
    static Logger logger = LogManager.getLogger((String)"DB Updater");
    private static final String[] SQL_KEYWORDS;
    private DBConnection dbcon;
    private ICommandFactory commandFactory;
    private IModelPatcher modelPatcher;
    private String quote;

    public DatabaseInfos(DBConnection dbcon) {
        this.dbcon = dbcon;
        this.commandFactory = this.createCommandFactory();
        this.modelPatcher = this.createModelPatcher();
    }

    protected IModelPatcher createModelPatcher() {
        return new ModelPatcherAdapter();
    }

    protected ICommandFactory createCommandFactory() {
        return new DefaultCommandFactory(this);
    }

    public DBConnection getDBConnection() {
        return this.dbcon;
    }

    public void setDBConnection(DBConnection dbcon) {
        this.dbcon = dbcon;
    }

    boolean isIdentiferQuoteRequired(String name) throws SQLException {
        char[] chars;
        for (char d : chars = name.toCharArray()) {
            char c = d;
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return true;
        }
        name = name.toUpperCase();
        String sqlKeywords = this.getSQLKeywords();
        String keywords = "," + (String)(sqlKeywords != null ? sqlKeywords.toUpperCase() + "," : "");
        int idx = keywords.indexOf("," + name + ",");
        if (idx >= 0) {
            return true;
        }
        for (String element : SQL_KEYWORDS) {
            if (!element.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        if (this.dbcon == null) {
            return null;
        }
        Connection connection = this.dbcon.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.getMetaData().getSQLKeywords();
    }

    @Override
    public String getQuoteIdentiferIfNeeded(String name) throws SQLException {
        if (!this.isIdentiferQuoteRequired(name)) {
            return name;
        }
        String quote = this.dbcon.getConnection().getMetaData().getIdentifierQuoteString();
        if (!quote.equals(" ") && name.contains(quote)) {
            name = name.replaceAll(Pattern.quote(quote), quote + quote);
        }
        return quote + name + quote;
    }

    @Override
    public String getQuotedValue(String value, int dataType) {
        if (!this.isQuoteableDataType(dataType)) {
            return value;
        }
        if (value == null) {
            return "''";
        }
        StringBuilder b = new StringBuilder(value.length() + 2);
        b.append('\'');
        b.append(value);
        b.append('\'');
        return b.toString();
    }

    @Override
    public String getQuote(String name) {
        if (name == null) {
            return null;
        }
        try {
            if (!this.isIdentiferQuoteRequired(name)) {
                return name;
            }
            if (this.quote == null) {
                this.quote = this.dbcon.getConnection().getMetaData().getIdentifierQuoteString();
            }
            return this.quote + name + this.quote;
        }
        catch (SQLException e) {
            logger.error((Throwable)e);
            return name;
        }
    }

    @Override
    public String getDestDataType(int datatype, int size, int scale, String originalName, boolean identity) throws SQLException {
        Object ident = "";
        if (identity) {
            ident = " " + this.getIdentityString();
        }
        switch (datatype) {
            case -7: {
                return "bit";
            }
            case 16: {
                return "boolean";
            }
            case -6: {
                return "tinyint" + (String)ident;
            }
            case 5: {
                return "smallint" + (String)ident;
            }
            case 4: {
                return "int" + (String)ident;
            }
            case -5: {
                return "bigint" + (String)ident;
            }
            case 7: {
                return "real";
            }
            case 6: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 2: {
                return this.getNumericDataType("numeric(" + size + "," + scale + ")", size, scale, originalName) + (String)ident;
            }
            case 3: {
                return this.getNumericDataType("decimal(" + size + "," + scale + ")", size, scale, originalName) + (String)ident;
            }
            case 93: {
                return "timestamp";
            }
            case 92: {
                return "time";
            }
            case 91: {
                return "date";
            }
            case 1: {
                return "char(" + size + ")";
            }
            case -2: {
                return "binary(" + size + ")";
            }
            case 12: {
                return "varchar(" + size + ")";
            }
            case -3: {
                return "varbinary(" + size + ")";
            }
            case -1: {
                return "longvarchar";
            }
            case -4: {
                return "longvarbinary";
            }
            case 2004: {
                return "blob";
            }
            case 2005: {
                return "clob";
            }
            case -8: {
                return "nchar(" + size + ")";
            }
            case -9: {
                return "nvarchar(" + size + ")";
            }
            case -10: {
                return "ntext";
            }
            case -11: {
                return "uniqueidentifer";
            }
            case -16: {
                return "ntext";
            }
            case -150: {
                return "sql_variant";
            }
            case 1111: {
                return originalName;
            }
        }
        throw new SQLException("Unknown data type:" + datatype);
    }

    public IModelComparator getModelPatchComparator() {
        return new IModelComparator(){

            @Override
            public Node compare(Node source, Node target, DatabaseInfos sourceInfos, DatabaseInfos targetInfos) {
                return source;
            }
        };
    }

    @Override
    public String getIdentityString() {
        return "identity";
    }

    protected String getNumericDataType(String defaultDataType, int size, int scale, String originalName) {
        return defaultDataType;
    }

    @Override
    public boolean isQuoteableDataType(int type) {
        switch (type) {
            case -16: 
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSupportedDataType(int sourceDataType) {
        switch (sourceDataType) {
            case -6: {
                return 5;
            }
            case -8: {
                return 1;
            }
            case -9: {
                return 12;
            }
            case -10: {
                return -1;
            }
            case -11: {
                return 12;
            }
            case -150: {
                return 2000;
            }
        }
        return sourceDataType;
    }

    @Override
    public boolean supportsDefaultInCreateTable() {
        return true;
    }

    @Override
    public String translateDefault(String def, int datatype) {
        return def;
    }

    public int getTableType(String name, String type) {
        if ("TABLE".equals(type)) {
            return 1;
        }
        if ("VIEW".equals(type)) {
            return 2;
        }
        return 0;
    }

    public void prepareInsertInto(String tableName, ResultSetMetaData rs) throws SQLException {
    }

    public void prepareAlter() throws SQLException {
    }

    public void finishInsertInto(String tableName, ResultSetMetaData rs) throws SQLException {
    }

    public String readView(String cat, String schema, String name) throws SQLException {
        throw new SQLException("Views is not implemented for this database source.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readProcedure(String cat, String schema, String name) throws SQLException {
        PreparedStatement pr = null;
        if (schema == null) {
            pr = this.dbcon.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.ROUTINES Where ROUTINE_TYPE='PROCEDURE' AND ROUTINE_NAME = ?");
            pr.setString(1, name);
        } else {
            pr = this.dbcon.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.ROUTINES Where ROUTINE_TYPE='PROCEDURE' AND ROUTINE_SCHEMA = ? and ROUTINE_NAME = ?");
            pr.setString(1, schema);
            pr.setString(2, name);
        }
        try {
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                String string = rs.getString("ROUTINE_DEFINITION");
                return string;
            }
        }
        finally {
            this.dbcon.close(pr);
        }
        throw new SQLException("Routine Definition (PROCEDURE) not found for " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFunction(String cat, String schema, String name) throws SQLException {
        PreparedStatement pr = null;
        if (schema == null) {
            pr = this.dbcon.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.ROUTINES Where ROUTINE_TYPE='FUNCTION' AND ROUTINE_NAME = ?");
            pr.setString(1, name);
        } else {
            pr = this.dbcon.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.ROUTINES Where ROUTINE_TYPE='FUNCTION' AND ROUTINE_SCHEMA = ? and ROUTINE_NAME = ?");
            pr.setString(1, schema);
            pr.setString(2, name);
        }
        try {
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                String string = rs.getString("ROUTINE_DEFINITION");
                return string;
            }
        }
        finally {
            this.dbcon.close(pr);
        }
        throw new SQLException("Routine Definition (FUNCTION) not found for " + name);
    }

    public boolean isNotNullable(int dbMetaNullabale, int rsMetaNullable, int datatype) {
        return dbMetaNullabale == 0 && rsMetaNullable == 0;
    }

    @Override
    public boolean isPrimaryKey(String cat, String schema, String name, String keyName) throws SQLException {
        if (keyName == null) {
            return false;
        }
        DatabaseMetaData metaData = this.dbcon.getConnection().getMetaData();
        ResultSet primaryKeyRs = metaData.getPrimaryKeys(cat, schema, name);
        while (primaryKeyRs.next()) {
            if (!keyName.equals(primaryKeyRs.getString("PK_NAME"))) continue;
            primaryKeyRs.close();
            return true;
        }
        primaryKeyRs.close();
        return false;
    }

    @Override
    public ResultSet getForeignKeys(String catalog, String schema, String table) throws SQLException {
        return this.dbcon.getConnection().getMetaData().getImportedKeys(catalog, schema, table);
    }

    public String checkIndexName(String indexName) {
        return indexName;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="tableName is analysed first")
    public void dropTable(String tableName) throws SQLException {
        try {
            String fkOnTable = null;
            ResultSet rs = this.dbcon.getConnection().getMetaData().getExportedKeys(null, null, tableName);
            while (rs.next()) {
                try {
                    String fkTableName = rs.getString("FKTABLE_NAME");
                    String fkName = rs.getString("FK_NAME");
                    String name = fkName + "_" + fkTableName;
                    if (!name.equals(fkOnTable)) {
                        String dropSQL = this.dropForeignKeySql(fkTableName, fkName);
                        logger.error((Object)dropSQL);
                        this.dbcon.createStatement().execute(dropSQL);
                    }
                    fkOnTable = name;
                }
                catch (Throwable e) {
                    logger.error(e);
                }
            }
            try {
                this.dbcon.execute("Drop table " + this.getQuoteIdentiferIfNeeded(tableName));
            }
            catch (Throwable ex) {
                logger.error(ex);
            }
        }
        catch (Throwable ex) {
            logger.error(ex);
        }
    }

    protected String dropForeignKeySql(String tableName, String constraintName) throws SQLException {
        return "ALTER TABLE " + this.getQuoteIdentiferIfNeeded(tableName) + " DROP CONSTRAINT " + this.getQuoteIdentiferIfNeeded(constraintName);
    }

    public ResultSet getTriggers() throws SQLException {
        throw new SQLException("Trigger is not implemented for this database source.");
    }

    @Override
    public String getSimpleName(String name) {
        return name;
    }

    @Override
    public boolean isProcedure(int type, String name) throws SQLException {
        return type == 0;
    }

    @Override
    public boolean isUserEntry(String name) throws SQLException {
        return true;
    }

    public ICommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public String getDefaultSchema() {
        return null;
    }

    public String getCurrentSchema() throws SQLException {
        return this.getDBConnection().getConnection().getCatalog();
    }

    public ResultSet getSequences() throws SQLException {
        throw new SQLException("Sequences is not implemented for this database source.");
    }

    public Set<String> getInnoDBTables() {
        return new HashSet<String>();
    }

    @SuppressFBWarnings(value={"EXTERNAL_CONFIG_CONTROL", "SQL_INJECTION_JDBC"}, justification="Database to use is client controlled")
    public void activateDatabase(DBConnection wrappedConnection, Connection connection, String databaseName) throws SQLException {
        String statement = "USE " + this.getQuoteIdentiferIfNeeded(databaseName);
        if (wrappedConnection != null) {
            wrappedConnection.execute(statement);
        } else {
            try (Statement stm = connection.createStatement();){
                stm.execute(statement);
            }
        }
        if (!databaseName.equals(connection.getCatalog())) {
            connection.setCatalog(databaseName);
        }
    }

    public IModelPatcher getModelPatcher() {
        return this.modelPatcher;
    }

    protected String removeStartingAndEndingCharacter(char chstart, char chend, String val) {
        while (val.length() > 1 && val.charAt(0) == chstart && val.charAt(val.length() - 1) == chend) {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public Object clone() throws CloneNotSupportedException {
        DatabaseInfos dbclone = (DatabaseInfos)super.clone();
        dbclone.setDBConnection((DBConnection)this.getDBConnection().clone());
        return dbclone;
    }

    public String modifyContent(NodeFactory.TAG tag, String content) {
        return content;
    }

    @Override
    public String getDBMSTypeName() {
        return "GENERAL";
    }

    public Object convertData(Object data, int type, boolean convertNullToDefault) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (data != null) break;
                return new byte[0];
            }
        }
        if (data == null && convertNullToDefault) {
            switch (type) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return 0;
                }
                case 6: 
                case 7: 
                case 8: {
                    return 0.0;
                }
                case 16: {
                    return false;
                }
                case 91: 
                case 92: 
                case 93: {
                    return new Date(0L);
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return new byte[0];
                }
                case -16: 
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return "";
                }
            }
            return null;
        }
        return data;
    }

    public String getDefaultStringByType(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "0";
            }
            case 16: {
                return "FALSE";
            }
            case -16: 
            case -10: 
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: 
            case 2005: {
                return "";
            }
            case 1111: {
                return "";
            }
        }
        return "";
    }

    private String getSchema(Node element) {
        String schema;
        if (element.getDiffSource() != null && (schema = element.getDiffSource().getParameter("schema")) != null) {
            return this.getQuote(schema);
        }
        schema = element.getParameter("schema");
        if (schema != null && schema != "#removed#") {
            return this.getQuote(schema);
        }
        return null;
    }

    @Override
    public void appendSchema(StringBuilder b, Node element) {
        if (element == null) {
            return;
        }
        String schema = this.getSchema(element);
        if (schema != null) {
            b.append(schema).append('.');
        }
    }

    @Override
    public String getSchemaPrefix(Node element) {
        if (element == null) {
            return null;
        }
        String schema = this.getSchema(element);
        return schema != null ? schema + "." : "";
    }

    public String getTableName(String tableName, Node tableNode) {
        Object resultingname = tableName;
        String schema = tableNode.getRecentValue("schema");
        if (schema != null) {
            if (((String)resultingname).startsWith(schema + ".")) {
                return resultingname;
            }
            resultingname = schema + "." + (String)resultingname;
        }
        return resultingname;
    }

    @Override
    public int getTypeID() {
        return 0;
    }

    public String getOnChangeDirective(IDatabaseInfos.REFERENCE_PARAM type, NodeReference.onChange action) {
        if (type == null || action == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        if (type == IDatabaseInfos.REFERENCE_PARAM.ondelete) {
            b.append(" ON DELETE ");
        } else {
            b.append(" ON UPDATE ");
        }
        b.append(action.toString());
        return b.toString();
    }

    public String getDefaultForOnChange(IDatabaseInfos.REFERENCE_PARAM type) {
        switch (type) {
            case ondelete: {
                return NodeReference.onChange.noaction.name();
            }
            case onupdate: {
                return NodeReference.onChange.noaction.name();
            }
        }
        return null;
    }

    static {
        logger.setLogLevel(LogLevel.DEBUG.getValue());
        SQL_KEYWORDS = new String[]{"SELECT", "FROM", "WHERE", "GROUP", "HAVING", "ORDER", "VALUES", "VALUE", "PRIMARY", "KEY", "CONSTRAINT", "TRIGGER", "UNIQUE", "FUNCTION", "PROCEDURE", "SEQUENCE", "RELEASE"};
    }
}

