/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.data;

import com.inet.dbupdater.DBScanner;
import com.inet.dbupdater.UpdaterEventDispatcher;
import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.ModelMerger;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.Parser;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;
import org.xml.sax.SAXException;

public class StateDescription {
    private Node model;
    private DBConnection connection;
    private DatabaseInfos connectionInfo;
    private SupplierWithIOException<InputStream> sourceSupplier;
    private List<SupplierWithIOException<InputStream>> mergeSourceSuppliers = new ArrayList<SupplierWithIOException<InputStream>>();
    private String tableList;
    private boolean initialized;
    private String targetDBMS;
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");
    private UpdaterEventDispatcher dispatcher;

    public StateDescription(File sourceFile, String targetDBMS) {
        this(new StreamProvider(sourceFile), targetDBMS);
    }

    public StateDescription(SupplierWithIOException<InputStream> sourceSupplier, String targetDBMS) {
        this.sourceSupplier = sourceSupplier;
        this.targetDBMS = targetDBMS;
    }

    public StateDescription(String databaseName, String driver, String user, String password, String connectionURL) {
        this.createConnection(databaseName, driver, user, password, connectionURL, null, null);
    }

    public StateDescription(DatabaseInfos dbInfo) {
        this.connectionInfo = dbInfo;
        this.connection = dbInfo.getDBConnection();
    }

    public StateDescription(DatabaseInfos dbInfo, File modelFile) {
        this(dbInfo, new StreamProvider(modelFile));
    }

    public StateDescription(DatabaseInfos dbInfo, SupplierWithIOException<InputStream> modelSupplier) {
        this.connectionInfo = dbInfo;
        this.connection = dbInfo.getDBConnection();
        this.sourceSupplier = modelSupplier;
    }

    public StateDescription(String databaseName, String driver, String jdbcUser, String jdbcPassword, String connectionURL, SupplierWithIOException<InputStream> sourceSupplier, String targetDBMS, String accountUser, String accountPassword) {
        this.createConnection(databaseName, driver, jdbcUser, jdbcPassword, connectionURL, accountUser, accountPassword);
        this.sourceSupplier = sourceSupplier;
        this.targetDBMS = targetDBMS;
    }

    private void createConnection(String databaseName, String driver, String jdbcUser, String jdbcPassword, String connectionURL, String accountUser, String accountPassword) {
        if (connectionURL != null) {
            this.connection = new DBConnection();
            this.connection.setJdbcDriverClass(driver);
            this.connection.setJdbcUrl(connectionURL);
            this.connection.setJdbcUser(jdbcUser);
            this.connection.setJdbcPassword(jdbcPassword);
            this.connection.setDatabaseName(databaseName);
            this.connection.setAccountUser(accountUser);
            this.connection.setAccountPassword(accountPassword);
        }
    }

    public void initialize() throws SAXException, IOException, SQLException {
        this.model = null;
        if (this.connection != null || this.connectionInfo != null) {
            if (this.connection.getConnection() == null) {
                this.connection.openConnection(this.connectionInfo);
            }
            try {
                this.connectionInfo = DatabaseInfoFactory.getDatabaseInfos(DatabaseInfoFactory.getDatabaseType(this.connection.getConnection()), this.connection);
            }
            catch (SQLException e) {
                logger.error((Throwable)e);
                this.connectionInfo = new DatabaseInfos(this.connection);
            }
        }
        if (this.sourceSupplier != null) {
            this.model = this.parse(this.sourceSupplier);
        } else {
            DBScanner scanner = new DBScanner(this.dispatcher);
            this.model = scanner.scanStructur(this.connection);
            if (this.tableList != null) {
                for (String tbl : this.tableList.split(",\\s*")) {
                    Node data = scanner.scanDatasets(this.connection, tbl);
                    this.model.addChild(data);
                }
            }
        }
        this.initialized = true;
    }

    public void mergeForMigration(Node reference) throws IOException, SAXException {
        if (this.mergeSourceSuppliers.size() > 0) {
            ArrayList<Node> mergeModels = new ArrayList<Node>();
            Set tables = null;
            int refType = -1;
            if (reference != null) {
                if (this.targetDBMS == null) {
                    Connection con;
                    if (reference.getName() == NodeFactory.TAG.database) {
                        this.targetDBMS = reference.getKeyValueOriginalCase();
                    } else if (this.connectionInfo != null) {
                        this.targetDBMS = this.connectionInfo.getDBMSTypeName();
                    } else if (this.connection != null && (con = this.connection.getConnection()) != null) {
                        try {
                            con.getMetaData().getDatabaseProductName();
                        }
                        catch (SQLException e) {
                            logger.error((Throwable)e);
                        }
                    }
                    if (this.targetDBMS == null) {
                        throw new IOException("Cannot merge additional database structures since the target database type is unknown");
                    }
                }
                refType = DatabaseInfoFactory.getDatabaseType(this.targetDBMS);
                if (reference.getName() == NodeFactory.TAG.dbupdater) {
                    int refTypeFinal = refType;
                    Optional<Node> databaseNode = reference.getChildren(NodeFactory.TAG.database).stream().filter(n -> DatabaseInfoFactory.getDatabaseType(n.getKeyValueOriginalCase()) == refTypeFinal).findFirst();
                    if (databaseNode.isEmpty()) {
                        logger.error((Object)"Merge-filter failed since the reference model has no data for the target database.");
                        return;
                    }
                    reference = databaseNode.get();
                }
                tables = reference.getChildren(NodeFactory.TAG.table).stream().map(t -> t.getKeyValueLowerCase()).collect(Collectors.toSet());
            }
            block2: for (SupplierWithIOException<InputStream> supplier : this.mergeSourceSuppliers) {
                Node mergeModel = this.parse(supplier);
                if (tables != null) {
                    if (mergeModel.getName() == NodeFactory.TAG.dbupdater) {
                        int refTypeFinal = refType;
                        Optional<Node> optional = mergeModel.getChildren(NodeFactory.TAG.database).stream().filter(n -> DatabaseInfoFactory.getDatabaseType(n.getKeyValueOriginalCase()) == refTypeFinal).findFirst();
                        if (optional.isEmpty()) {
                            logger.error((Object)"Merge-filter failed since the reference model has no data for the target database.");
                            return;
                        }
                        mergeModel = optional.get();
                    }
                    for (Node node : mergeModel.getChildren(NodeFactory.TAG.table)) {
                        if (tables.contains(node.getKeyValueLowerCase())) continue;
                        String skipped = mergeModel.getChildren(NodeFactory.TAG.table).stream().map(t -> t.getKeyValueLowerCase()).collect(Collectors.joining(","));
                        logger.error((Object)("Skipped merging of tables '" + skipped + "' since they are not present in the reference data."));
                        continue block2;
                    }
                }
                mergeModels.add(mergeModel);
            }
            logger.info((Object)("Merging " + this.mergeSourceSuppliers.size() + " additional structures before updating the database."));
            ModelMerger merger = new ModelMerger(false);
            this.model = merger.merge(this.model, mergeModels.toArray(new Node[0]));
        }
    }

    private Node parse(SupplierWithIOException<InputStream> supplier) throws IOException, SAXException {
        Parser parser = new Parser(this.targetDBMS);
        try (InputStream in = (InputStream)supplier.get();){
            Node node = parser.parse(in);
            return node;
        }
    }

    public Node getModel() {
        if (!this.initialized) {
            throw new IllegalStateException("The model has to be initialized before retrieving it!");
        }
        return this.model;
    }

    public void setModel(Node model) {
        this.initialized = true;
        this.model = model;
    }

    public DBConnection getConnection() {
        return this.connection;
    }

    public DatabaseInfos getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean hasSourceXMLResource() {
        return this.sourceSupplier != null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void logSettings(Logger logger) {
        if (this.connection != null) {
            logger.debug((Object)("DB URL   : " + this.connection.getJdbcUrl()));
            if (this.connection.getJdbcUser() != null) {
                logger.debug((Object)("DB User  : " + this.connection.getJdbcUser()));
            }
            if (this.connection.getJdbcDriverClass() != null) {
                logger.debug((Object)("DB Driver: " + this.connection.getJdbcDriverClass()));
            }
        }
        if (this.sourceSupplier != null) {
            logger.debug((Object)("SRC XML  : " + String.valueOf(this.sourceSupplier)));
        }
    }

    public String getTargetDBMS() {
        return this.targetDBMS;
    }

    public void setTableList(String tableList) {
        this.tableList = tableList;
    }

    public void setEventDispatcher(UpdaterEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public SupplierWithIOException<InputStream> getSourceSupplier() {
        return this.sourceSupplier;
    }

    public List<SupplierWithIOException<InputStream>> getPluginSourceSuppliers() {
        return new ArrayList<SupplierWithIOException<InputStream>>(this.mergeSourceSuppliers);
    }

    public void addSourceSupplier(SupplierWithIOException<InputStream> sourceToMerge) {
        if (this.sourceSupplier == null) {
            throw new IllegalStateException("Cannot add a merge state if there is no primary state set");
        }
        this.mergeSourceSuppliers.add(sourceToMerge);
    }

    private static class StreamProvider
    implements SupplierWithIOException<InputStream> {
        private File fileToOpen;

        public StreamProvider(File fileToOpen) {
            this.fileToOpen = fileToOpen;
        }

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user specified xml files are expected")
        public InputStream get() throws IOException {
            return new FileInputStream(this.fileToOpen);
        }

        public String toString() {
            return "File: " + String.valueOf(this.fileToOpen);
        }
    }
}

