/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater;

import com.inet.dbupdater.UpdaterCore;
import com.inet.dbupdater.data.StateDescription;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.logging.LogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import javax.annotation.SuppressFBWarnings;

public class DBUpdater {
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user specified xml files are expected")
    public static void main(String[] args) {
        UpdaterCore core;
        String srcDB = DBUpdater.scanArgs("-srcdbname", args);
        String srcURL = DBUpdater.scanArgs("-srcurl", args);
        String srcUser = DBUpdater.scanArgs("-srcuser", args);
        String srcPassword = DBUpdater.scanArgs("-srcpassword", args);
        String srcfile = DBUpdater.scanArgs("-srcfile", args);
        String srcTables = DBUpdater.scanArgs("-srctables", args);
        String srcdriver = DBUpdater.scanArgs("-srcdrv", args);
        String destDB = DBUpdater.scanArgs("-destdbname", args);
        String destURL = DBUpdater.scanArgs("-desturl", args);
        String destUser = DBUpdater.scanArgs("-destuser", args);
        String destPassword = DBUpdater.scanArgs("-destpassword", args);
        String destAccountUser = DBUpdater.scanArgs("-destaccountuser", args);
        String destAccountPassword = DBUpdater.scanArgs("-destaccountpassword", args);
        String destfile = DBUpdater.scanArgs("-destfile", args);
        String destdriver = DBUpdater.scanArgs("-destdrv", args);
        String outputfile = DBUpdater.scanArgs("-outputfile", args);
        boolean dryrun = DBUpdater.scanArgs("-dryrun", args) != null;
        try {
            if (srcdriver != null) {
                Class.forName(srcdriver);
            }
            if (destdriver != null) {
                Class.forName(destdriver);
            }
        }
        catch (Throwable th) {
            LogManager.getLogger((String)"DB Updater").error(th);
        }
        new DatabaseInfos(null);
        if (Arrays.asList(args).contains("-jdbclog")) {
            DriverManager.setLogWriter(new PrintWriter(System.err, true){
                private StringBuffer cache = new StringBuffer();

                @Override
                public void println(String x) {
                    if (this.cache.length() > 0) {
                        this.cache.append(x);
                        x = this.cache.toString();
                        this.cache.setLength(0);
                    }
                    LogManager.getLogger((String)"DB Updater").debug((Object)x);
                }

                @Override
                public void println(Object x) {
                    if (this.cache.length() > 0) {
                        this.cache.append(x);
                        x = this.cache.toString();
                        this.cache.setLength(0);
                    }
                    LogManager.getLogger((String)"DB Updater").debug(x);
                }

                @Override
                public void println(char c) {
                    if (this.cache.length() > 0) {
                        this.cache.append(c);
                        LogManager.getLogger((String)"DB Updater").debug((Object)this.cache.toString());
                        this.cache.setLength(0);
                    } else {
                        LogManager.getLogger((String)"DB Updater").debug((Object)("" + c));
                    }
                }

                @Override
                public void print(String x) {
                    this.cache.append(x);
                }

                @Override
                public void print(Object x) {
                    this.cache.append(x);
                }

                @Override
                public void print(char c) {
                    this.cache.append(c);
                }

                @Override
                public void print(int i) {
                    this.cache.append(i);
                }
            });
        }
        StateDescription source = null;
        if (srcURL != null || srcfile != null) {
            source = new StateDescription(srcDB, srcdriver, srcUser, srcPassword, srcURL, srcfile != null ? new StreamProvider(srcfile) : null, null, null, null);
        }
        StateDescription target = null;
        if (destURL != null || destfile != null) {
            target = new StateDescription(destDB, destdriver, destUser, destPassword, destURL, destfile != null ? new StreamProvider(destfile) : null, null, destAccountUser, destAccountPassword);
        }
        if ((source == null || outputfile == null) && target == null) {
            DBUpdater.usage();
            return;
        }
        if (srcTables != null) {
            source.setTableList(srcTables);
        }
        if (outputfile != null) {
            if (target != null) {
                LogManager.getLogger((String)"DB Updater").error((Object)"The destination database parameters will be ignored since an output file is set. The output file always causes a scan and dump of the source database.");
            }
            core = new UpdaterCore(source, new File(outputfile));
        } else {
            core = new UpdaterCore(source, target);
        }
        core.setDryRun(dryrun);
        try {
            core.prepare();
        }
        catch (SQLException e) {
            LogManager.getLogger((String)"DB Updater").error((Object)("Initialization failed due to an error: " + e.getMessage()));
            LogManager.getLogger((String)"DB Updater").error((Throwable)e);
        }
        core.execute();
    }

    private static String scanArgs(String key, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!key.equalsIgnoreCase(args[i]) || i >= args.length - 1) continue;
            return args[i + 1];
        }
        return null;
    }

    private static void usage() {
        System.out.println("DBUpdater - scan, update an migrate databases!\nUSAGE: java -cp driverclasspath DBUpdater [-options]\nMODES: The following modes of operations are possible:\n  Database Scan           \tReads the structure of a database and prints it\n                          \tto a XML file. This mode requires a complete source\n                          \tbatabase and an the outputfile. The dump of table contents\n                          \tusing -srctables is optional.\n  Database Update         \tUpdates a database using a target state described by a\n                          \tXML file. This mode Requires a source database connection and\n                          \ta target XML file.\n  Update and Migration    \tUpdates a database and migrates it to another DBMS - in that order!\n                          \tWARNING: This will modify you current database!\n                          \tRequires: source database and source-Update file, target database and\n                          \ttarget update file.\n  Migration an Update     \tThis is an experimental migration, which does NOT modify the source\n                          \tdatabase. Since it tries to copy the structure directly from one DBMS\n                          \tto another, it may fail due to incompatible types.\n                          \tRequires: source database, target database and target update file.\n                          \tNo source file is allowed here!\nOPTIONS:\n  -srcdbname <string>     \tThe name of the source database.\n  -srcurl <url>           \tThe JDBC URL of the source database.\n  -srcuser <user>         \tThe user name of the source database.\n  -srcpassword <password> \tThe password of the source database.\n  -srcdrv <class name>    \tThe classname of a driver.\n  -srcfile <path>         \tA XML file, which contains the source Database. May be\n                          \tused in addition or instead of the database.\n  -srctables <names>      \tComma separated list of tables to read the content from\n                          \tThis option is relevant only for a DB to XML scan!\n  -destdbname <string>    \tThe name of the target database.\n  -desturl <url>          \tThe JDBC URL of the target database.\n  -destuser <user>        \tThe user name TO LOGIN AT the target database.\n  -destpassword <password>\tThe password TO LOGIN AT the target database.\n  -destaccountuser <user> \tThe user name TO CREATE THE CATALOG on the target database.\n  -destaccountpassword <p>\tThe password TO CREATE THE CATALOG on the target database.\n  -destdrv <class name>   \tThe classname of a driver.\n  -destfile <path>        \tA XML file, which contains the target Database. May be\n                          \tused in addition or instead of the database.\n  -outputfile <path>      \tThe file to print the scanned Database to\n  -jdbclog                \tEnable the JDBC logging.\n");
    }

    private static class StreamProvider
    implements SupplierWithIOException<InputStream> {
        private String fileToOpen;

        public StreamProvider(String fileToOpen) {
            this.fileToOpen = fileToOpen;
        }

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user specified xml files are expected")
        public InputStream get() throws IOException {
            return new FileInputStream(this.fileToOpen);
        }

        public String toString() {
            return "File: " + this.fileToOpen;
        }
    }
}

