/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups;

import com.inet.helpdesk.core.data.ActionCreationNotificator;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchDataCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HelpDeskUserGroupSearchDataCache
extends UserGroupSearchDataCache {
    public HelpDeskUserGroupSearchDataCache(Map<GUID, UserGroupInfo> groupInfoCache, List<UserGroupField<Object>> userGroupFields) {
        super(groupInfoCache, userGroupFields);
        ActionCreationNotificator acn = (ActionCreationNotificator)ServerPluginManager.getInstance().getSingleInstance(ActionCreationNotificator.class);
        acn.registerListener(actionID -> {
            SearchDataCacheChangeListener[] listeners;
            HashMap oldData = new HashMap();
            HashMap<String, Set<Integer>> newData = new HashMap<String, Set<Integer>>();
            newData.put(HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS.getKey(), Collections.singleton(actionID));
            for (SearchDataCacheChangeListener listener : listeners = this.getListeners()) {
                listener.entryChanged((Object)UsersAndGroups.GROUPID_ADMIN, oldData, newData);
            }
        });
    }

    protected Map<String, Object> toMap(UserGroupInfo groupInfo) {
        Map map = super.toMap(groupInfo);
        if (UsersAndGroups.GROUPID_ADMIN.equals((Object)groupInfo.getID())) {
            map.put(HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS.getKey(), ActionManager.getInstance().getAllValidIds());
        }
        return map;
    }
}

