/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtension;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.extension.UpdateTicketDataExtension;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import java.util.Date;
import srv.controller.ticket.timeline.ResourceTimelineManager;

public class DeadlineUpdateExtensionFactory
implements UpdateTicketDataExtension,
CreateTicketExtensionFactory {
    @Override
    public CreateTicketExtension createIfApplicable(OperationChangedTicket ticket, ExtensionArguments arguments, MutableTicketData ticketFields) {
        return new DeadlineUpdateExtension();
    }

    @Override
    public void beforeWriteTicketData(OperationChangedTicket ticket, TicketSubOperations operations, MutableTicketData ticketData) {
        GUID resourceId;
        MutableTicketData fields = ticket.getNewTicketData();
        if (!fields.containsKey(Tickets.FIELD_DEADLINE) && fields.get(Tickets.FIELD_PRIORITY_ID) != null && ServerOptions.isOptionSet(256) && !ticket.isNew() && (resourceId = fields.hasValue(Tickets.FIELD_RESOURCE_GUID) ? fields.get(Tickets.FIELD_RESOURCE_GUID) : ticket.getOldTicket().get().getResourceID()) != null) {
            if (ticket.getOldTicket().get().getDispatchingReaStepID() == null) {
                return;
            }
            long calculationStartDate = TicketManager.getReaderForSystem().getReaStep(ticket.getOldTicket().get().getDispatchingReaStepID()).getStartDate();
            this.setDeadlineInMutableTicketData(fields, fields.get(Tickets.FIELD_PRIORITY_ID), resourceId, new Date(calculationStartDate));
        }
    }

    private void setDeadlineInMutableTicketData(MutableTicketData data, Integer prio, GUID resourceId, Date fromStartTime) {
        Date deadline = ResourceTimelineManager.getInstance().calcTargetTime(HDUsersAndGroups.getResourceId(resourceId), prio, fromStartTime);
        data.put(Tickets.FIELD_DEADLINE, deadline != null ? Long.valueOf(deadline.getTime()) : null);
    }

    @Override
    public int getExecutionPriority() {
        return CreateTicketExtensionFactory.super.getExecutionPriority();
    }

    private class DeadlineUpdateExtension
    implements CreateTicketExtension {
        private DeadlineUpdateExtension() {
        }

        @Override
        public void beforeCreate(OperationChangedTicket newTicket, OperationNewReaStep anfrageStep, TicketSubOperations operations) {
            MutableTicketData data = newTicket.getNewTicketData();
            if (!data.containsKey(Tickets.FIELD_DEADLINE) && data.hasValue(Tickets.FIELD_RESOURCE_GUID)) {
                Integer prio = data.get(Tickets.FIELD_PRIORITY_ID);
                DeadlineUpdateExtensionFactory.this.setDeadlineInMutableTicketData(data, prio, data.get(Tickets.FIELD_RESOURCE_GUID), new Date());
            }
        }
    }
}

