/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.classloader.translations.LanguageUtils;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.mailtemplates.data.LoadMailTemplatesEditorRequest;
import com.inet.helpdesk.config.mailtemplates.data.LoadMailTemplatesEditorResponse;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplateDescription;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplatesHelper;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.mailtemplates.MailTemplate;
import com.inet.helpdesk.core.mailtemplates.MailTemplateData;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class LoadMailTemplatesEditor
extends ServiceMethod<LoadMailTemplatesEditorRequest, LoadMailTemplatesEditorResponse> {
    public String getMethodName() {
        return "mailtemplates.loadmailtemplateseditor";
    }

    public short getMethodType() {
        return 1;
    }

    public LoadMailTemplatesEditorResponse invoke(HttpServletRequest req, HttpServletResponse resp, LoadMailTemplatesEditorRequest payload) throws IOException {
        MailTemplateData template = MailTemplatesManager.getTemplate(payload.getName(), payload.getSet(), payload.getLang());
        MailTemplateDescription description = new MailTemplateDescription(payload.getName());
        MailTemplate defaultTemplate = null;
        try {
            defaultTemplate = (MailTemplate)ServerPluginManager.getInstance().getSingleInstanceByName(MailTemplate.class, payload.getName(), false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (defaultTemplate != null) {
            description.setSubTemplate(defaultTemplate.isSubTemplate());
            description.setDescription(defaultTemplate.getDescription());
        } else {
            description.setCustom(true);
        }
        description.setSet(payload.getTargetSet());
        if (payload.getTargetSet().equals("default")) {
            description.setSetDisplayName(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.default", new Object[0]));
        } else {
            description.setSetDisplayName(payload.getTargetSet());
        }
        description.setLang(payload.getTargetLang());
        if (payload.getTargetLang().equals("default")) {
            description.setLangDisplayName(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.default", new Object[0]));
        } else {
            List additionalLanguages = LanguageUtils.getAdditionalLanguages(Set.of());
            Optional<LocalizedKey> findFirst = additionalLanguages.stream().filter(a -> a.getKey().equals(payload.getTargetLang())).findFirst();
            if (findFirst.isPresent()) {
                description.setLangDisplayName(findFirst.get().getDisplayName());
            } else {
                description.setLangDisplayName(payload.getTargetLang());
            }
        }
        description.setHtml(template.getHtmlData() != null);
        description.setPlaintext(template.getTextData() != null);
        LoadMailTemplatesEditorResponse mailTemplatesResponse = new LoadMailTemplatesEditorResponse(description);
        mailTemplatesResponse.setTextSubject("");
        mailTemplatesResponse.setHtmlSubject("");
        String textData = template.getTextData();
        if (description.isSubTemplate()) {
            mailTemplatesResponse.setHtmlData(template.getHtmlData());
            if (textData != null) {
                splitText = MailTemplatesHelper.splitText(textData);
                if (splitText.length == 2) {
                    String plainText = StringFunctions.isEmpty((String)splitText[0]) ? splitText[1] : textData;
                    mailTemplatesResponse.setTextData(MailTemplatesManager.getLightHtmlFromPlainText(plainText));
                } else {
                    mailTemplatesResponse.setTextData(MailTemplatesManager.getLightHtmlFromPlainText(String.join((CharSequence)"", splitText)));
                }
            }
        } else {
            if (textData != null) {
                splitText = MailTemplatesHelper.splitText(textData);
                if (!StringFunctions.isEmpty((String)splitText[0]) && splitText.length == 2) {
                    mailTemplatesResponse.setTextSubject((String)splitText[0]);
                    mailTemplatesResponse.setTextData(MailTemplatesManager.getLightHtmlFromPlainText((String)splitText[1]));
                } else {
                    mailTemplatesResponse.setTextData(MailTemplatesManager.getLightHtmlFromPlainText(String.join((CharSequence)"", splitText)));
                }
            }
            if (template.getHtmlData() != null) {
                mailTemplatesResponse.setHtmlData(MailTemplatesManager.getInlinedHtml(template.getHtmlData()));
                String lowerCase = template.getHtmlData().toLowerCase();
                int start = lowerCase.indexOf("<title>");
                int end = lowerCase.indexOf("</title>");
                if (start > 0 && end > 0 && end > start) {
                    mailTemplatesResponse.setHtmlSubject(StringFunctions.decodeHTML((String)template.getHtmlData().substring(start + 7, end)));
                }
            }
        }
        mailTemplatesResponse.setIsGenerated(template.isTextGenerated());
        Font defaultFont = TicketTextFunctions.getDefaultFont();
        mailTemplatesResponse.setDefaultFontName(defaultFont.getFamily());
        mailTemplatesResponse.setDefaultFontSize(defaultFont.getSize() + "pt");
        return mailTemplatesResponse;
    }

    private String cleanAndTrim(String str) {
        CharSequence[] split = str.split("\n");
        for (int i = 0; i < split.length; ++i) {
            split[i] = ((String)split[i]).trim();
        }
        return String.join((CharSequence)"\n", split);
    }
}

