/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.handler;

import com.inet.helpdesk.config.autotext.data.AutoTextDescription;
import com.inet.helpdesk.config.autotext.data.AutoTextGroupsDescription;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholder;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderProvider;
import com.inet.helpdesk.config.autotext.data.CreateOrEditAutoTextRequest;
import com.inet.helpdesk.config.autotext.data.CreateOrEditAutoTextResponse;
import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextMember;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.ui.TargetChild;
import com.inet.usersandgroups.api.ui.TargetEntry;
import com.inet.usersandgroups.api.ui.TargetParent;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CreateOrEditAutoText
extends ServiceMethod<CreateOrEditAutoTextRequest, CreateOrEditAutoTextResponse> {
    public String getMethodName() {
        return "autotext.createoreditautotext";
    }

    public short getMethodType() {
        return 1;
    }

    public CreateOrEditAutoTextResponse invoke(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, CreateOrEditAutoTextRequest payload) throws IOException {
        AutoTextManager man = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        HashMap<String, FieldEditDescription> fieldDescriptions = new HashMap<String, FieldEditDescription>();
        CreateOrEditAutoTextResponse createOrEditAutoTextResponse = new CreateOrEditAutoTextResponse();
        List<String> groups = man.getAutoTextGroups();
        UserAccount currentUserAccount = UserManager.getRecoveryEnabledInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            throw new AccessDeniedException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.accessdenied", new Object[0]));
        }
        int hdUserID = HDUsersAndGroups.getUserID(currentUserAccount);
        if (hdUserID == -1) {
            throw new AccessDeniedException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.accessdenied", new Object[0]));
        }
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(currentUserAccount.getID());
        boolean isAdminGroup = groupsForUser.contains(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN));
        boolean isSupporterGroup = HDUsersAndGroups.isSupporter(currentUserAccount);
        boolean userIsAdmin = currentUserAccount.getAccountType().equals((Object)UserAccountType.Administrator);
        boolean userHasPermission = SystemPermissionChecker.hasAnyPermission((GUID)currentUserAccount.getID(), (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION});
        List<AutoTextVO> allAutoTexts = userIsAdmin || isAdminGroup ? man.getConfigurableAutoTextsForUser(currentUserAccount.getID(), AutoTextManager.VisibilityFilter.IS_ADMIN) : (userHasPermission || isSupporterGroup ? man.getConfigurableAutoTextsForUser(currentUserAccount.getID(), AutoTextManager.VisibilityFilter.HAS_PERMISSION) : man.getConfigurableAutoTextsForUser(currentUserAccount.getID(), AutoTextManager.VisibilityFilter.IS_OWNER));
        if (payload.getId() != null) {
            boolean cont = false;
            for (int i = 0; i < allAutoTexts.size(); ++i) {
                if (allAutoTexts.get(i).getId() != payload.getId().intValue()) continue;
                cont = true;
                break;
            }
            if (!cont && allAutoTexts.size() > 0) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.noaccess", new Object[0]));
            }
        }
        HashSet<String> usergroups = new HashSet<String>();
        for (AutoTextVO autoTextVO : allAutoTexts) {
            usergroups.add(autoTextVO.getGroupLabel());
        }
        groups.retainAll(usergroups);
        createOrEditAutoTextResponse.setGroups(groups);
        if (payload.getId() != null && ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            List<SavedAttachmentData> existingAttachments = AutoTextAttachmentHelper.getAutoTextAttachments(payload.getId());
            createOrEditAutoTextResponse.setExistingAttachments(existingAttachments);
        }
        fieldValues.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(true));
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            fieldValues.put(TicketFieldRendererId.attachments.name(), String.valueOf(0));
            fieldDescriptions.put(TicketFieldRendererId.attachments.name(), new FieldEditDescription(TicketFieldRendererId.attachments.name(), "attachmentsadd", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.field.attachments", new Object[0]), null, Collections.emptyMap()));
        }
        fieldDescriptions.put(TicketFieldRendererId.htmleditor.name(), new FieldEditDescription(TicketFieldRendererId.htmleditor.name(), "htmltext", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.field.htmleditor", new Object[0]), null, Collections.emptyMap()));
        Font defaultFont = TicketTextFunctions.getDefaultFont();
        fieldValues.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
        fieldValues.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
        createOrEditAutoTextResponse.setFieldDescriptions(fieldDescriptions);
        createOrEditAutoTextResponse.setFieldValues(fieldValues);
        createOrEditAutoTextResponse.setAutoTextPlaceholder(CreateOrEditAutoText.getPlaceholderList(man));
        AutoTextDescription autoTextDescription = null;
        if (payload.getId() != null) {
            UserAccount userAccount;
            AutoTextVO autoTextVO = (AutoTextVO)man.get(payload.getId());
            autoTextDescription = new AutoTextDescription(payload.getId());
            autoTextDescription.setLabel(payload.getDuplicateAutotextId() == null ? autoTextVO.getLabel() : this.getUniqueLabel(autoTextVO.getLabel(), man, hdUserID));
            autoTextDescription.setGroup(autoTextVO.getGroupLabel());
            autoTextDescription.setFlags(autoTextVO.getTyp());
            autoTextDescription.setShortcut(autoTextVO.getShortcut());
            autoTextDescription.setOwnerId(autoTextVO.getUserId());
            String userDisplayName = "";
            if (autoTextVO.getUserId() != null && (userAccount = HDUsersAndGroups.getUserAccount(autoTextVO.getUserId())) != null) {
                userDisplayName = userAccount.getDisplayName();
            }
            autoTextDescription.setOwnerDisplayName(userDisplayName);
            autoTextDescription.setUserId(hdUserID);
            autoTextDescription.setAutoTextGroups(this.getGroups(autoTextVO.getMemberships()));
            String contentText = autoTextVO.getContentText();
            if (!StringFunctions.isEmpty((String)contentText)) {
                contentText = TicketTextFunctions.getInlinedHtml(contentText, false);
            }
            autoTextDescription.setHtmlContent(contentText);
            if (Integer.valueOf(hdUserID).equals(autoTextVO.getUserId()) || userIsAdmin || isAdminGroup || userHasPermission) {
                createOrEditAutoTextResponse.setIsReadOnly(false);
            }
        }
        if (payload.getId() == null || payload.getId().equals(-1)) {
            createOrEditAutoTextResponse.setIsReadOnly(false);
        }
        createOrEditAutoTextResponse.setCanShare(SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER));
        if (autoTextDescription == null) {
            autoTextDescription = new AutoTextDescription(null);
        }
        createOrEditAutoTextResponse.setAutoTextDescription(autoTextDescription);
        return createOrEditAutoTextResponse;
    }

    private String getUniqueLabel(String label, AutoTextManager man, int userId) {
        String testLabel;
        HashMap<String, Boolean> allAutoTextNames = man.getAllAutoTextNames(userId);
        if (allAutoTextNames.get(testLabel = label + " (" + HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.copyof", new Object[0]) + ")") == null) {
            return testLabel;
        }
        if (!allAutoTextNames.get(testLabel).booleanValue()) {
            return testLabel;
        }
        for (int counter = 1; counter < 1000; ++counter) {
            testLabel = label + " (" + HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.copyof", new Object[0]) + " " + counter + ")";
            if (allAutoTextNames.get(testLabel) == null) {
                return testLabel;
            }
            if (allAutoTextNames.get(testLabel).booleanValue()) continue;
            return testLabel;
        }
        return label;
    }

    private AutoTextGroupsDescription getGroups(List<AutoTextMember> memberlist) {
        if (memberlist == null || memberlist.isEmpty()) {
            return null;
        }
        UserGroupManager gman = UserGroupManager.getInstance();
        UserManager uman = UserManager.getRecoveryEnabledInstance();
        ArrayList<TargetEntry> entryList = new ArrayList<TargetEntry>();
        Set allGroups = gman.getAllGroups();
        for (AutoTextMember autoTextMember : memberlist) {
            UserAccount userAccount;
            GUID guid = autoTextMember.getId();
            if (autoTextMember.getType().equals((Object)Type.group)) {
                UserGroupInfo group = gman.getGroup(guid);
                if (group == null || !group.isActive()) continue;
                TargetEntry entry = new TargetEntry(guid, Type.group, group.getType().getName(), group.getDisplayName());
                UserGroupTreeUtils.DescendantGroups descendantGroups = UserGroupTreeUtils.findDescendantGroups((UserGroupInfo)group, (Set)allGroups);
                ArrayList<TargetChild> children = new ArrayList<TargetChild>();
                for (UserGroupInfo descendantGroupInfo : descendantGroups.getDescendantGroups()) {
                    children.add(new TargetChild(descendantGroupInfo.getID(), descendantGroupInfo.getDisplayName()));
                }
                entry.setChildren(children);
                ArrayList<TargetParent> parents = new ArrayList<TargetParent>();
                UserGroupInfo parentGroup = group;
                while (parentGroup.hasParent()) {
                    parentGroup = gman.getGroup(parentGroup.getParentID());
                    parents.add(new TargetParent(parentGroup.getID(), parentGroup.getDisplayName()));
                }
                entry.setParents(parents);
                entryList.add(entry);
                continue;
            }
            if (!autoTextMember.getType().equals((Object)Type.user) || (userAccount = uman.getUserAccount(guid)) == null) continue;
            entryList.add(new TargetEntry(guid, Type.user, userAccount.getAccountType().name(), userAccount.getDisplayName()));
        }
        AutoTextGroupsDescription autoTextGroupsDescription = new AutoTextGroupsDescription();
        autoTextGroupsDescription.setValue(new Json().toJson(entryList));
        autoTextGroupsDescription.setEnabled(true);
        return autoTextGroupsDescription;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static List<AutoTextPlaceholder> getPlaceholderList(AutoTextManager man) {
        Map<String, String> allPossiblePlaceholders = man.getAllPossiblePlaceholders();
        ArrayList<AutoTextPlaceholder> list = new ArrayList<AutoTextPlaceholder>();
        AutoTextPlaceholder autoTextPlaceholderTicket = new AutoTextPlaceholder(TicketFieldDefinition.FIELD_GROUPING.TICKET.getDisplayName());
        AutoTextPlaceholder autoTextPlaceholderOwner = new AutoTextPlaceholder(TicketFieldDefinition.FIELD_GROUPING.TICKET_OWNER.getDisplayName());
        AutoTextPlaceholder autoTextPlaceholderUser = new AutoTextPlaceholder(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.placeholder.user", new Object[0]));
        AutoTextPlaceholder autoTextPlaceholderDateTime = new AutoTextPlaceholder(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.placeholder.datetime", new Object[0]));
        HashSet seenKeys = new HashSet();
        ArrayList providerPlaceholders = new ArrayList();
        @Nonnull List autoTextPlaceholderProviders = DynamicExtensionManager.getInstance().get(AutoTextPlaceholderProvider.class);
        autoTextPlaceholderProviders.stream().map(AutoTextPlaceholderProvider::provideAdditionalAutoTextPlaceholders).filter(p -> p != null && !p.isEmpty()).flatMap(p -> p.stream()).forEach(placeholder -> {
            providerPlaceholders.add(placeholder);
            seenKeys.addAll(placeholder.getEntries().stream().map(e -> e.getKey()).collect(Collectors.toList()));
        });
        for (String phKey : allPossiblePlaceholders.keySet()) {
            if (seenKeys.contains(phKey)) continue;
            if (phKey.startsWith("ticketowner.")) {
                autoTextPlaceholderOwner.addEntry(phKey, allPossiblePlaceholders.get(phKey));
                continue;
            }
            if (phKey.startsWith("currentuser.")) {
                autoTextPlaceholderUser.addEntry(phKey, allPossiblePlaceholders.get(phKey));
                continue;
            }
            if (phKey.startsWith("datetime.")) {
                autoTextPlaceholderDateTime.addEntry(phKey, allPossiblePlaceholders.get(phKey));
                continue;
            }
            autoTextPlaceholderTicket.addEntry(phKey, allPossiblePlaceholders.get(phKey));
        }
        autoTextPlaceholderTicket.sort();
        list.add(autoTextPlaceholderTicket);
        autoTextPlaceholderOwner.sort();
        list.add(autoTextPlaceholderOwner);
        autoTextPlaceholderUser.sort();
        list.add(autoTextPlaceholderUser);
        autoTextPlaceholderDateTime.sort();
        list.add(autoTextPlaceholderDateTime);
        list.addAll(providerPlaceholders);
        return list;
    }
}

