/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandFactory;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.OracleAddColumnCommand;
import com.inet.dbupdater.databases.commands.OracleAddPrimaryCommand;
import com.inet.dbupdater.databases.commands.OracleAlterColumnCommand;
import com.inet.dbupdater.databases.commands.OracleAlterDropCommand;
import com.inet.dbupdater.databases.commands.OracleCommandSyntax;
import com.inet.dbupdater.databases.commands.OracleCreateDatabaseCommand;
import com.inet.dbupdater.databases.commands.OracleCreateFunctionCommand;
import com.inet.dbupdater.databases.commands.OracleCreateIndexCommand;
import com.inet.dbupdater.databases.commands.OracleCreateTriggerCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;

public class OracleCommandFactory
extends DefaultCommandFactory {
    private DatabaseInfos dbInfo;

    public OracleCommandFactory(DatabaseInfos dbInfo) {
        super(dbInfo);
        this.dbInfo = dbInfo;
        this.setSyntax(new OracleCommandSyntax(dbInfo));
    }

    @Override
    public IComposedCommand getCommand(ICommandFactory.COMMAND_TYPE action, NodeFactory.TAG type, IDatabaseCommand.TIME purpose, Node containerNode, String name) {
        if (action == ICommandFactory.COMMAND_TYPE.create) {
            if (type == NodeFactory.TAG.database) {
                return new OracleCreateDatabaseCommand(this.dbInfo, containerNode);
            }
            if (type == NodeFactory.TAG.function) {
                return new OracleCreateFunctionCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.trigger) {
                return new OracleCreateTriggerCommand(this.dbInfo);
            }
            if (!(type != NodeFactory.TAG.index || name != null && name.equals("PRIMARY"))) {
                return new OracleCreateIndexCommand(this.dbInfo, containerNode);
            }
        }
        if (action == ICommandFactory.COMMAND_TYPE.alter) {
            if (type == NodeFactory.TAG.column) {
                if (purpose == IDatabaseCommand.TIME.addstructure) {
                    return new OracleAddColumnCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.alterstructure) {
                    return new OracleAlterColumnCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
            }
            if (type == NodeFactory.TAG.index) {
                if (purpose == IDatabaseCommand.TIME.addstructure || purpose == IDatabaseCommand.TIME.addreferences) {
                    if (name != null && name.equals("PRIMARY")) {
                        return new OracleAddPrimaryCommand(this.dbInfo, containerNode);
                    }
                    return new OracleCreateIndexCommand(this.dbInfo, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.dropreferences || purpose == IDatabaseCommand.TIME.dropstructure) {
                    return new OracleAlterDropCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
            }
        }
        return super.getCommand(action, type, purpose, containerNode, name);
    }
}

