/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater;

import com.inet.dbupdater.DBScanner;
import com.inet.dbupdater.UpdaterEvent;
import com.inet.dbupdater.UpdaterEventDispatcher;
import com.inet.dbupdater.UpdaterListener;
import com.inet.dbupdater.data.StateDescription;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.dbconnection.DryRunConnection;
import com.inet.dbupdater.jobrunner.JobFactory;
import com.inet.dbupdater.jobrunner.JobRunner;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.model.Diff;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.ModelWriterXML;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.modules.ModuleFactory;
import com.inet.dbupdater.modules.ModulesRunner;
import com.inet.dbupdater.modules.MySQLAdaptionModule;
import com.inet.dbupdater.modules.ScriptSchemaPatcher;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class UpdaterCore {
    private StateDescription source;
    private StateDescription target;
    private boolean canRun = false;
    private USECASE mode = USECASE.scan;
    private static Logger logger = LogManager.getLogger((String)"DB Updater");
    private boolean dryRun = false;
    private UpdaterEventDispatcher dispatcher;
    private ModuleFactory modulFactory;
    private ModulesRunner moduleRunner;
    private List<Exception> catchedExceptions = new ArrayList<Exception>();
    private File outputFile;

    public UpdaterCore(StateDescription sourceState, StateDescription targetState) {
        this(sourceState, targetState, null);
    }

    public UpdaterCore(StateDescription sourceState, File outputFile) {
        this.outputFile = outputFile;
        this.setSourceState(sourceState);
        this.dispatcher = new UpdaterEventDispatcher();
        this.dispatcher.setJobCount(0);
        this.dispatcher.setCurrentJob(0);
    }

    private UpdaterCore(StateDescription sourceState, StateDescription targetState, File outputFile) {
        this.outputFile = outputFile;
        this.setSourceState(sourceState);
        this.setTargetState(targetState);
        this.dispatcher = new UpdaterEventDispatcher();
        this.dispatcher.setJobCount(0);
        this.dispatcher.setCurrentJob(0);
    }

    private void setSourceState(StateDescription state) {
        logger.debug((Object)"Register Source State:");
        if (state != null) {
            state.logSettings(logger);
        } else {
            logger.debug((Object)"none");
        }
        this.source = state;
    }

    private void setTargetState(StateDescription state) {
        logger.debug((Object)"Register Target State:");
        if (state != null) {
            state.logSettings(logger);
        } else {
            logger.debug((Object)"none");
        }
        this.target = state;
    }

    public void prepare() throws SQLException {
        if (this.source == null) {
            throw new IllegalStateException("The updater requires a source state!");
        }
        ModuleFactory moduleFactory = this.getModulFactory(true);
        try {
            boolean sourceHasDB;
            this.source.setEventDispatcher(this.dispatcher);
            this.source.initialize();
            boolean sourceHasFile = this.source.hasSourceXMLResource();
            boolean bl = sourceHasDB = this.source.getConnection() != null;
            if (!sourceHasDB) {
                throw new IllegalStateException("The updater requires a source database!");
            }
            moduleFactory.scanModel(this.source.getModel());
            boolean targetHasFile = false;
            boolean targetHasDB = false;
            if (this.target != null) {
                this.target.setEventDispatcher(this.dispatcher);
                this.target.initialize();
                moduleFactory.scanModel(this.target.getModel());
                targetHasFile = this.target.hasSourceXMLResource();
                boolean bl2 = targetHasDB = this.target.getConnection() != null;
                if (sourceHasFile && !targetHasFile && targetHasDB) {
                    logger.info((Object)"Using source XML file as target state");
                    DBConnection con = this.target.getConnection();
                    this.target = new StateDescription(con.getDatabaseName(), con.getJdbcDriverClass(), con.getJdbcUser(), con.getJdbcPassword(), con.getJdbcUrl(), this.source.getSourceSupplier(), null, con.getAccountUser(), con.getAccountPassword());
                    this.source.getPluginSourceSuppliers().forEach(supplier -> this.target.addSourceSupplier((SupplierWithIOException<InputStream>)supplier));
                    targetHasFile = true;
                }
                if (!targetHasFile) {
                    throw new IllegalStateException("A database copy/migration requires an XML file to establish and verify the final state on the target database.");
                }
                this.mode = targetHasDB ? USECASE.migrateUpdate : USECASE.update;
            }
            this.canRun = true;
        }
        catch (SAXException e) {
            logger.fatal((Object)"Could not parse the input file");
            logger.fatal((Object)e);
        }
        catch (IOException e) {
            logger.fatal((Object)"Failed to open the input file");
            logger.fatal((Object)e);
        }
    }

    public boolean execute() {
        if (!this.canRun) {
            throw new IllegalStateException("Please call the initialize step first.");
        }
        if (this.mode == USECASE.scan) {
            this.printModelToFile(this.outputFile, this.source.getModel());
            return true;
        }
        if (this.mode == USECASE.update) {
            if (this.dispatcher != null) {
                this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "updatingDatabase", new Object[0]));
            }
            boolean updateDatabase = this.updateDatabase(this.source.getModel(), this.target.getModel(), this.source.getConnectionInfo());
            return updateDatabase;
        }
        if (this.mode == USECASE.updateMigrate) {
            return this.updateMigrate(this.source, this.target);
        }
        if (this.mode == USECASE.migrateUpdate) {
            return this.migrateUpdate(this.source, this.target);
        }
        return false;
    }

    private JobFactory getJobFactory(DatabaseInfos dbToUpdate, DatabaseInfos dbToReadFrom, Node fromModel, Node toModel, boolean isUpdate) {
        return new JobFactory(dbToUpdate, dbToReadFrom, fromModel, toModel, isUpdate);
    }

    private JobRunner getJobRunner(DatabaseInfos dbToUpdate) {
        return new JobRunner(dbToUpdate);
    }

    public boolean updateDatabase(Node source, Node target, DatabaseInfos dbToUpdate) {
        return this.updateDatabase(source, target, dbToUpdate, null, null, null);
    }

    public boolean updateDatabase(Node source, Node target, DatabaseInfos dbToUpdate, DatabaseInfos dbToReadFrom, Node dbModelToReadFrom, IDatabaseCommand.TIME stopAt) {
        boolean isUpdate;
        if (this.isDryRun()) {
            dbToUpdate.setDBConnection(new DryRunConnection());
        }
        DBConnection connection = dbToUpdate.getDBConnection();
        try {
            if (connection.getConnection() == null || connection.getConnection().isClosed()) {
                connection.openConnection(dbToUpdate);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"Error checking the target database connection");
            logger.debug((Object)e);
        }
        logger.debug((Object)"Adapting model to target database");
        ModulesRunner moduleRunner = this.getModuleRunner();
        if (dbToReadFrom != null) {
            moduleRunner.run(source, dbToReadFrom);
        }
        moduleRunner.run(target, dbToUpdate);
        logger.debug((Object)"Starting structure diff");
        Diff diff = new Diff(source, target, dbToReadFrom, dbToUpdate, null);
        Node update = diff.run();
        logger.debug((Object)"Structure diff complete");
        if (update == null && dbModelToReadFrom == null) {
            logger.debug((Object)"Database is at requested version");
            return true;
        }
        if (update != null) {
            if (update.getState() == 0 && dbToReadFrom == null) {
                logger.debug((Object)"Setting run mode to: INSTALL");
                isUpdate = false;
            } else {
                logger.debug((Object)"Setting run mode to: UPDATE");
                isUpdate = true;
            }
        } else {
            logger.debug((Object)"Setting run mode to: COPY DATA");
            isUpdate = false;
        }
        JobFactory factory = this.getJobFactory(dbToUpdate, dbToReadFrom, dbModelToReadFrom, target, isUpdate);
        logger.debug((Object)"Creating update jobs");
        JobStructure jobs = factory.createJobList(update);
        logger.debug((Object)"Update jobs created");
        logger.info((Object)"Starting job execution");
        JobRunner runner = this.getJobRunner(dbToUpdate);
        if (!runner.runJobs(jobs, stopAt, this.dispatcher)) {
            this.catchedExceptions.addAll(runner.getCatchedExceptions());
            logger.error((Object)"Job execution incomplete");
            return false;
        }
        logger.info((Object)"All jobs done");
        return true;
    }

    private ModulesRunner getModuleRunner() {
        if (this.moduleRunner == null) {
            this.moduleRunner = new ModulesRunner(this.getModulFactory(false));
        }
        return this.moduleRunner;
    }

    public boolean updateMigrate(StateDescription source, StateDescription target) {
        Node currentNewState;
        Node currentOldState;
        this.dispatcher.setJobCount(this.dispatcher.getJobCount() + 4);
        logger.info((Object)"Starting update and migration");
        logger.info((Object)"Scanning current database");
        this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "scanningDatabase", new Object[0]));
        try {
            currentOldState = new DBScanner(this.dispatcher).scanStructur(source.getConnection());
        }
        catch (SQLException e) {
            logger.fatal((Object)("Update aborted. Could not scan the source database due to an error: " + e.getMessage()));
            logger.error((Throwable)e);
            return false;
        }
        logger.info((Object)"Scanning target database");
        this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "scanningDatabase", new Object[0]));
        try {
            currentNewState = new DBScanner(this.dispatcher).scanStructur(target.getConnection());
        }
        catch (SQLException e) {
            logger.fatal((Object)("Update aborted. Could not scan the source database due to an error: " + e.getMessage()));
            logger.error((Throwable)e);
            return false;
        }
        logger.info((Object)"Updating current database to conform the new structure");
        this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "updatingExistingDatabase", new Object[0]));
        if (!this.updateDatabase(currentOldState, source.getModel(), source.getConnectionInfo())) {
            logger.fatal((Object)"Could not set source database to required state, update aborted");
            return false;
        }
        logger.info((Object)"Installing to new database, copying data from the current one");
        this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "updatingTargetDatabase", new Object[0]));
        Node targetNewState = target.getModel();
        if (!this.updateDatabase(currentNewState, targetNewState, target.getConnectionInfo(), source.getConnectionInfo(), targetNewState, null)) {
            logger.fatal((Object)"Modification of target database incomplete");
            return false;
        }
        logger.info((Object)"update and migration done");
        return true;
    }

    public boolean migrateUpdate(StateDescription source, StateDescription target) {
        Node currentNewState;
        logger.info((Object)"update structure on target to old version");
        Node currentOldState = source.getModel();
        this.checkPrimaryNames(currentOldState);
        try {
            currentNewState = new DBScanner().scanStructur(target.getConnection());
        }
        catch (SQLException e) {
            logger.fatal((Object)("Update aborted. Could not scan the source database due to an error: " + e.getMessage()));
            logger.error((Throwable)e);
            return false;
        }
        if (currentNewState != null && (currentNewState.getName() != NodeFactory.TAG.database || currentNewState.getAllChildren().size() > 0)) {
            logger.error((Object)"Migration to an existing, not empty database is not supported!");
            logger.fatal((Object)"Migration with update FAILED");
            return false;
        }
        try {
            target.mergeForMigration(currentNewState);
        }
        catch (IOException | SAXException e) {
            logger.error((Object)"Unable to merge the plugin structures.");
            logger.error((Throwable)e);
            logger.fatal((Object)"Migration with update FAILED");
            return false;
        }
        IModelComparator patcher = target.getConnectionInfo().getModelPatchComparator();
        Diff identityPatcher = new Diff(currentOldState, target.getModel(), source.getConnectionInfo(), target.getConnectionInfo(), target.getConnectionInfo().getDBMSTypeName(), patcher);
        currentOldState = identityPatcher.run();
        if (!this.updateDatabase(currentNewState, currentOldState, target.getConnectionInfo(), null, null, IDatabaseCommand.TIME.copydata)) {
            logger.error((Object)"Unable to copy existing structure.");
            logger.fatal((Object)"Migration with update FAILED");
            return false;
        }
        logger.info((Object)"Copying datasets...");
        currentOldState = source.getModel();
        try {
            currentNewState = new DBScanner().scanStructur(target.getConnection());
        }
        catch (SQLException e) {
            logger.fatal((Object)("Update aborted. Could not scan the target database due to an error: " + e.getMessage()));
            logger.error((Throwable)e);
            return false;
        }
        if (!this.updateDatabase(currentNewState, currentNewState, target.getConnectionInfo(), source.getConnectionInfo(), currentOldState, IDatabaseCommand.TIME.createdata)) {
            logger.error((Object)"Unable to copy data.");
            logger.fatal((Object)"Migration with update FAILED");
            return false;
        }
        logger.info((Object)"full final update of target");
        try {
            currentNewState = new DBScanner().scanStructur(target.getConnection());
        }
        catch (SQLException e) {
            logger.fatal((Object)("Update aborted. Could not scan the target database due to an error: " + e.getMessage()));
            logger.error((Throwable)e);
            return false;
        }
        try {
            target.mergeForMigration(currentNewState);
        }
        catch (IOException | SAXException e) {
            logger.error((Object)"Unable to merge the plugin structures.");
            logger.error((Throwable)e);
            logger.fatal((Object)"Migration with update FAILED");
            return false;
        }
        this.getModuleRunner().clean();
        if (!this.updateDatabase(currentNewState, target.getModel(), target.getConnectionInfo())) {
            logger.error((Object)"Unable to update target database.");
            logger.fatal((Object)"Migration with update FAILED");
            return false;
        }
        return true;
    }

    private void checkPrimaryNames(Node model) {
        if (model != null) {
            List<? extends Node> children;
            Object name;
            if (model.getName() == NodeFactory.TAG.index && "true".equalsIgnoreCase(model.getParameter(IDatabaseInfos.INDEX_PARAM.isprimarykey.name())) && "PRIMARY".equalsIgnoreCase((String)(name = model.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name())))) {
                name = (String)name + model.getParent().getKeyValueLowerCase();
                model.readParameter(IDatabaseInfos.INDEX_PARAM.index_name.name(), (String)name);
            }
            if ((children = model.getAllChildren()) != null) {
                for (Node node : children) {
                    this.checkPrimaryNames(node);
                }
            }
        }
    }

    public void printModelToFile(File target, Node model) {
        logger.debug((Object)("Exporting structure to file '" + String.valueOf(target) + "'"));
        try {
            PrintWriter out = new PrintWriter(target);
            ModelWriterXML writer = new ModelWriterXML(out, model);
            writer.run();
            out.close();
            logger.debug((Object)"Exporting done");
        }
        catch (FileNotFoundException e) {
            logger.fatal((Object)"Export failed");
            logger.fatal((Object)e);
        }
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        if (dryRun) {
            logger.info((Object)"Updater set to 'dry run' mode");
        }
        this.dryRun = dryRun;
    }

    public void addUpdaterListener(UpdaterListener ulistener) {
        this.dispatcher.addUpdaterListener(ulistener);
    }

    public void removeUpdaterListener(UpdaterListener ulistener) {
        this.dispatcher.removeUpdaterListener(ulistener);
    }

    public ModuleFactory getModulFactory(boolean clear) {
        if (this.modulFactory == null || clear) {
            this.modulFactory = new ModuleFactory();
            this.loadDefaultModules(this.modulFactory);
        }
        return this.modulFactory;
    }

    private void loadDefaultModules(ModuleFactory modulFactory) {
        modulFactory.addModul("MySQL", new MySQLAdaptionModule());
        modulFactory.addModul(null, new ScriptSchemaPatcher());
    }

    public List<Exception> getCatchedExceptions() {
        return this.catchedExceptions;
    }

    public static enum USECASE {
        scan,
        update,
        migrateUpdate,
        updateMigrate;

    }
}

