/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountSaver;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.profiles.MailProfile;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.shared.utils.TrustAllSSLSocketFactory;
import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.util.Properties;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class MailConnectionCreator {
    public static Folder getConnectedFolder(EmailAccount emailAccount, @Nonnull SessionStoreStatus status, int connectiontimeout, int timeout) throws HelpDeskServerException {
        if (status == null) {
            throw new IllegalArgumentException("status must not be null");
        }
        String account = emailAccount.getAccount();
        if (StringFunctions.isEmpty((String)account)) {
            throw new HelpDeskServerException("Connect failed: User name is empty", (ErrorCode)HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
        }
        String provider = emailAccount.getProvider();
        String host = emailAccount.getHost();
        if (StringFunctions.isEmpty((String)provider) && StringFunctions.isEmpty((String)host)) {
            throw new HelpDeskServerException("Connect failed: host and provider is empty", (ErrorCode)HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
        }
        Logger logger = BaseEmail.LOGGER;
        Folder folder = null;
        Store store = null;
        try {
            store = MailConnectionCreator.generateConnectedStore(emailAccount, logger, connectiontimeout, timeout);
            status.setStore(store);
            folder = store.getFolder("INBOX");
            if (folder == null || !folder.exists()) {
                throw new HelpDeskServerException("Error from Mail server: Connect failed: 'INBOX' does not exist.", (ErrorCode)HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
            }
            folder.open(2);
            return folder;
        }
        catch (Exception ex) {
            StringBuilder buf = new StringBuilder("Konnte Konto ").append(account).append(" nicht \u00f6ffnen!").append('\n');
            buf.append("Error from Mail server: " + ex.getMessage() + (account.contains("@") ? " (Benutzernamen ohne Dom\u00e4ne probieren?)" : ""));
            HelpDeskServerException exception = new HelpDeskServerException(buf.toString(), (Throwable)ex, HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
            logger.error((Throwable)exception);
            try {
                if (folder != null && folder.isOpen()) {
                    folder.close(true);
                }
            }
            catch (MessagingException mex) {
                logger.error((Throwable)new HelpDeskServerException("Could not close folder " + account, (Throwable)mex, HelpDeskErrorCodes.MAIL_ACCOUNT_CLOSE_ERROR));
            }
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
            }
            catch (MessagingException mex2) {
                logger.error((Throwable)new HelpDeskServerException("Could not close store " + account, (Throwable)mex2, HelpDeskErrorCodes.MAIL_ACCOUNT_CLOSE_ERROR));
            }
            throw exception;
        }
    }

    private static Store generateConnectedStore(EmailAccount emailAccount, Logger logger, int connectiontimeout, int timeout) throws MessagingException {
        String password;
        String protocol;
        boolean isSSL;
        String port;
        String host;
        Properties props = new Properties();
        MailProfile sendProfile = MailProfile.getProfile((String)emailAccount.getProvider());
        if (sendProfile != null) {
            host = sendProfile.getImapHost();
            port = sendProfile.getImapPort();
            isSSL = true;
            protocol = "imaps";
            password = sendProfile.getAuthenticationMethod() == MailAuthenticationMethod.XOAUTH2 ? OauthAccessTokenManager.getAccessToken((String)sendProfile.getOauthProvider(), (String)emailAccount.getRefreshToken(), (Consumer)new EmailAccountSaver(emailAccount)) : OauthAccessTokenManager.getAccessToken((String)sendProfile.getOauthProvider(), (String)"client_credentials", null);
            props.put("mail.imaps.auth.mechanisms", "XOAUTH2");
        } else {
            host = emailAccount.getHost();
            isSSL = emailAccount.getSSL();
            int mailPort = emailAccount.getPort();
            switch (emailAccount.getProtocol()) {
                case POP3: {
                    if (mailPort == 0) {
                        mailPort = isSSL ? 995 : 110;
                    }
                    protocol = "pop3";
                    break;
                }
                default: {
                    if (mailPort == 0) {
                        mailPort = isSSL ? 993 : 143;
                    }
                    protocol = isSSL ? "imaps" : "imap";
                }
            }
            port = String.valueOf(mailPort);
            password = emailAccount.getPasswordDecoded();
        }
        props.setProperty("mail.store.protocol", protocol);
        String protokollString = "mail." + protocol + ".";
        props.setProperty(protokollString + "port", port);
        if (isSSL) {
            props.setProperty(protokollString + "socketFactory.fallback", "false");
            props.setProperty(protokollString + "socketFactory.port", port);
            props.setProperty(protokollString + "socketFactory.class", TrustAllSSLSocketFactory.class.getName());
        } else {
            props.setProperty(protokollString + "socketFactory.fallback", "");
            props.setProperty(protokollString + "socketFactory.port", "");
            props.setProperty(protokollString + "socketFactory.class", "");
        }
        props.setProperty(protokollString + "fetchsize", "524288");
        props.setProperty(protokollString + "auth.ntlm.disable", String.valueOf(emailAccount.getPreventNtlmAuth()));
        props.setProperty(protokollString + "auth.plain.disable", String.valueOf(emailAccount.getPreventPlainAuth()));
        props.setProperty(protokollString + "connectiontimeout", String.valueOf(connectiontimeout));
        props.setProperty(protokollString + "timeout", String.valueOf(timeout));
        props.setProperty("mail.debug", String.valueOf(logger.isDebug()));
        props.setProperty("mail.debug.auth", String.valueOf(logger.isDebug()));
        Thread.currentThread().setContextClassLoader(BaseEmail.class.getClassLoader());
        Session session = Session.getInstance((Properties)props, null);
        if (logger.isDebug()) {
            session.setDebugOut(LogManager.getLogStream());
            logger.debug((Object)("Session class loader: " + String.valueOf(session.getClass().getClassLoader())));
            logger.debug((Object)("Context class loader: " + String.valueOf(Thread.currentThread().getContextClassLoader())));
        }
        Store store = session.getStore();
        String account = emailAccount.getAccount();
        store.connect(host, account, password);
        return store;
    }

    public static class SessionStoreStatus {
        private Store store;
        private Session session;

        public Session getSession() {
            return this.session;
        }

        public Store getStore() {
            return this.store;
        }

        public void setStore(Store store) {
            this.store = store;
        }

        public void setSession(Session session) {
            this.session = session;
        }
    }
}

