/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDUserFieldDefinition;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.SelectFieldValue;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Map;
import java.util.stream.Collectors;

public class LocationUserFieldDefinition
extends SelectUserFieldDefinition<Integer>
implements HDUserFieldDefinition {
    public LocationUserFieldDefinition(int prio) {
        super("user.masterdata", (UserField)HDUsersAndGroups.FIELD_LOCATION_ID, prio);
    }

    public SelectOption getValue(UserAccount userAccount) {
        UserAccount currentUserAccount;
        Integer value = null;
        if (userAccount != null) {
            value = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        }
        if ((Integer)HDUsersAndGroups.CONFIG_MANDANTEN.get() == 1 && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, HdPermissions.DISPATCHER}) && (currentUserAccount = UserManager.getInstance().getCurrentUserAccount()) != null) {
            value = (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        }
        if (value == null) {
            value = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
        }
        if (value == null) {
            value = 0;
        }
        Map locations = HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getMapData();
        String suffix = ((LocationVO)LocationManager.getInstance().get(value)).isDeleted() ? " (" + Tickets.MSG.getMsg("value.deactivated", new Object[0]) + ")" : "";
        return new SelectOption(value.toString(), (String)locations.get(value) + suffix);
    }

    public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
        Map<Integer, String> locations = LocationManager.getInstance().getAll(true).stream().filter(vo -> vo.getDisplayValue() != null).collect(Collectors.toMap(c -> c.getId(), FieldVO::getDisplayValue));
        if ((Integer)HDUsersAndGroups.CONFIG_MANDANTEN.get() == 1 && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, HdPermissions.DISPATCHER})) {
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            if (currentUserAccount == null) {
                locations.clear();
            } else {
                Integer userLocation = (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                if (userLocation == null) {
                    userLocation = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
                }
                if (userLocation == null) {
                    userLocation = 0;
                }
                Integer fUserLocation = userLocation;
                locations.keySet().removeIf(key -> !fUserLocation.equals(key));
            }
        }
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, locations);
    }

    public Integer convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            try {
                return Integer.valueOf(option.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean isAvailable(UserAccount userAccount) {
        return super.isAvailable(userAccount);
    }

    public SelectFieldValue getFieldValue(UserAccount userAccount) {
        SelectFieldValue result = super.getFieldValue(userAccount);
        boolean enabled = this.isEnabled();
        if ((Integer)HDUsersAndGroups.CONFIG_MANDANTEN.get() == 1 && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, HdPermissions.DISPATCHER})) {
            enabled = false;
        }
        result.setEnabled(enabled);
        return result;
    }

    public boolean isBatchEditable() {
        return true;
    }

    public void setDefaultValue(String value) {
        super.setDefaultValue(value);
    }
}

