/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.helpdesk.ticketview.standardviews.SharedWithMeTicketViewDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceSubViewGrouping
extends SimpleSubViewGrouping {
    private static final String DELETED = "deleted";
    private static final String WRITE = "write";
    private static final String READ = "read";
    public static final ResourceSubViewGrouping INSTANCE = new ResourceSubViewGrouping();
    private final Function<GUID, UserGroupInfo> resourceManager;
    private int metaDataVersion;

    ResourceSubViewGrouping() {
        this((GUID resID) -> UserGroupManager.getInstance().getGroup(resID));
    }

    ResourceSubViewGrouping(Function<GUID, UserGroupInfo> resourceManager) {
        super("resourceid");
        this.resourceManager = resourceManager;
    }

    @Override
    public boolean supportsHideSubnodeTickets() {
        return true;
    }

    boolean getReadRight(UserAccount userAccount) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ});
    }

    @Override
    public List<SubView<?>> getSubViews(@Nonnull TicketViewFactory parentView, @Nonnull GUID accountID, Locale locale, @Nonnull Set<Integer> ticketIDs) {
        Iterator<ResourceX> it;
        if (parentView instanceof SubResources) {
            return ((SubResources)parentView).getSubResources();
        }
        IndexSearchEngine<Integer> engine = TicketManager.getReader().getSearchEngine();
        SearchTag tag = Tickets.FIELD_RESOURCE_GUID.getSearchTag();
        HashMap<GUID, SubResources> map = new HashMap<GUID, SubResources>();
        ArrayList views = new ArrayList();
        UserAccount userAccount = UserManager.getInstance().getUserAccount(accountID);
        boolean readRight = this.getReadRight(userAccount);
        boolean writeRight = SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE});
        if (readRight) {
            final Iterator valuesIterator = engine.createValuesIterator(tag, true);
            it = new Iterator<ResourceX>(){

                @Override
                public boolean hasNext() {
                    return valuesIterator.hasNext();
                }

                @Override
                public ResourceX next() {
                    String value = (String)valuesIterator.next();
                    return value == null ? null : new ResourceX(GUID.valueOf((String)value), true);
                }
            };
        } else {
            HashSet<GUID> resources = ResourceSubViewGrouping.getResourceIDs(accountID);
            Set set = resources.stream().filter(Objects::nonNull).map(guid -> new ResourceX((GUID)guid, true)).collect(Collectors.toSet());
            Set idsOfTicketsWithExtraGrantedAccess = engine.simpleSearch(new SearchCommand(new SearchExpression[]{this.expressionForTicketsWithAdditionalAccess(null, accountID)}));
            Iterator iterator = engine.createValuesIterator(tag, null, ticket -> idsOfTicketsWithExtraGrantedAccess.contains(ticket));
            iterator.forEachRemaining(guid -> {
                if (guid != null && !resources.contains(GUID.valueOf((String)guid))) {
                    set.add(new ResourceX(GUID.valueOf((String)guid), false));
                }
            });
            it = set.iterator();
        }
        while (it.hasNext()) {
            GUID gUID;
            UserGroupInfo res;
            ResourceX item = (ResourceX)it.next();
            if (item == null || (res = this.resourceManager.apply(gUID = item.id)) == null) continue;
            String string = ResourceSubViewGrouping.getIconKey(res, writeRight, accountID);
            String displayName = res.getDisplayName();
            if (displayName == null) continue;
            SubResources view = new SubResources(parentView, gUID, displayName, string, item.readAccess);
            map.put(gUID, view);
        }
        for (Map.Entry entry : new HashMap(map).entrySet()) {
            GUID resId = (GUID)entry.getKey();
            SubResources subResources = (SubResources)entry.getValue();
            UserGroupInfo res = this.resourceManager.apply(resId);
            GUID parentId = res != null ? res.getParentID() : null;
            if (parentId == null) {
                views.add(subResources);
                continue;
            }
            SubResources parent = (SubResources)map.get(parentId);
            if (parent == null) {
                String dispalyName;
                UserGroupInfo parentRes = this.resourceManager.apply(parentId);
                String string = dispalyName = parentRes == null ? null : parentRes.getDisplayName();
                if (dispalyName == null) {
                    views.add(subResources);
                    continue;
                }
                String iconKey = ResourceSubViewGrouping.getIconKey(parentRes, writeRight, accountID);
                parent = new SubResources(parentView, parentId, dispalyName, iconKey, false);
                if (!readRight) {
                    parent.allIds.clear();
                }
                map.put(parentId, parent);
                views.add(parent);
            }
            parent.addSubResource(resId, subResources, parentView.isHideSubnodeTickets());
        }
        Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
        Comparator comparator = (a, b) -> collator.compare(a.getDisplayName(), b.getDisplayName());
        views.sort(comparator);
        for (TicketViewFactory ticketViewFactory : views) {
            List<SubView<?>> subViews = ((SubResources)ticketViewFactory).getSubResources();
            if (subViews == null) continue;
            subViews.sort(comparator);
        }
        return views;
    }

    private SearchExpression expressionForResourceNode(boolean hasReadRight, Set<GUID> resourceWithAccess, Set<GUID> allResourcesOfThisNode, GUID accountID) {
        SearchCondition searchCondition = new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, allResourcesOfThisNode);
        if (hasReadRight) {
            return searchCondition;
        }
        allResourcesOfThisNode = new HashSet<GUID>(allResourcesOfThisNode);
        allResourcesOfThisNode.removeAll(resourceWithAccess);
        if (!allResourcesOfThisNode.isEmpty()) {
            OrSearchExpression orSearchExpression = new OrSearchExpression();
            orSearchExpression.add((Object)searchCondition);
            orSearchExpression.add((Object)this.expressionForTicketsWithAdditionalAccess(allResourcesOfThisNode, accountID));
            return orSearchExpression;
        }
        return searchCondition;
    }

    protected SearchExpression expressionForTicketsWithAdditionalAccess(@Nullable Set<GUID> resourcesOfCurrentView, GUID accountId) {
        if (accountId == null || !HDUsersAndGroups.isSupporter(UserManager.getInstance().getUserAccount(accountId))) {
            return new SearchCondition(Tickets.ATTRIBUTE_STATUS_ID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)Integer.MIN_VALUE);
        }
        AndSearchExpression accessGrantedToMe = SharedWithMeTicketViewDefinition.getSharedTickets(accountId, false);
        if (resourcesOfCurrentView == null) {
            return accessGrantedToMe;
        }
        AndSearchExpression expression = new AndSearchExpression();
        expression.add((SearchExpression)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resourcesOfCurrentView));
        expression.add((SearchExpression)accessGrantedToMe);
        return expression;
    }

    @Nonnull
    private static String getIconKey(UserGroupInfo res, boolean writeRight, @Nonnull GUID accountID) {
        if (res == null) {
            return DELETED;
        }
        if (!res.isActive()) {
            return DELETED;
        }
        if (writeRight) {
            return WRITE;
        }
        if (HDUsersAndGroups.hasWritePermissionInResource(accountID, res)) {
            return WRITE;
        }
        return READ;
    }

    @Override
    public void patchSearchCommand(Object id, @Nonnull SearchCommand command, @Nonnull GUID accountID) {
        SubResources node = (SubResources)id;
        AndSearchExpression expressions = command.getSearchExpression();
        if (node.allIds.equals(node.resourcesWithAccess)) {
            HashSet<GUID> allIds = node.allIds;
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                SearchCondition cond;
                SearchExpression expr = (SearchExpression)it.next();
                if (expr.getType() != SearchExpression.Type.Condition || !"resourceid".equals((cond = (SearchCondition)expr).getLeftOperand())) continue;
                switch (cond.getOperator()) {
                    case StartsWith: {
                        it.remove();
                        break;
                    }
                    case IN: {
                        allIds.retainAll((Collection)cond.getRightOperand());
                    }
                }
            }
            expressions.add((SearchExpression)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, allIds));
        } else {
            expressions.add(this.expressionForResourceNode(false, node.resourcesWithAccess, node.allIds, accountID));
        }
    }

    @Override
    @Nullable
    protected Supplier<SearchExpression> getConditionSupplier(@Nonnull String subID, boolean hideSubnodeTickets) {
        GUID resourceId = GUID.valueOf((String)subID);
        GUID accountID = UserManager.getInstance().getCurrentUserAccountID();
        return () -> {
            HashSet<GUID> resources = new HashSet<GUID>();
            resources.add(resourceId);
            UserGroupManager manager = UserGroupManager.getInstance();
            UserGroupInfo root = manager.getGroup(resourceId);
            if (root != null) {
                boolean isRootNode = root.getParentID() == null;
                UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                boolean readRight = this.getReadRight(userAccount);
                HashSet<GUID> allResourcesOfThisNode = new HashSet<GUID>(resources);
                if (isRootNode && !hideSubnodeTickets) {
                    for (UserGroupInfo group : manager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE)) {
                        if (!resourceId.equals((Object)group.getParentID())) continue;
                        allResourcesOfThisNode.add(group.getID());
                    }
                }
                resources.clear();
                for (UserGroupInfo group : manager.getGroupsForUserIncludingDeactivated(userAccount.getID())) {
                    if (group.getType() != HDUsersAndGroups.RESOURCE) continue;
                    if (resourceId.equals((Object)group.getID())) {
                        resources.add(resourceId);
                    }
                    if (!resourceId.equals((Object)group.getParentID())) continue;
                    resources.add(group.getID());
                }
                for (UserGroupInfo group : manager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE)) {
                    if (group.hasMembers() || !resourceId.equals((Object)group.getParentID())) continue;
                    resources.add(group.getID());
                }
                return this.expressionForResourceNode(readRight, resources, allResourcesOfThisNode, accountID);
            }
            return new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resources);
        };
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        if (iconKey == null) {
            return HelpDeskServer.class.getResource("images/resources_16.gif");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/" + (switch (iconKey) {
            case READ -> "resources_read";
            case WRITE -> "resources";
            default -> "delete";
        }) + "_16.gif");
    }

    @Nonnull
    public static HashSet<GUID> getResourceIDs(@Nonnull GUID accountID) {
        return ResourceSubViewGrouping.getResourceIDs(accountID, group -> true);
    }

    public static HashSet<GUID> getResourceIDs(@Nonnull GUID accountID, @Nonnull Predicate<UserGroupInfo> filter) {
        HashSet<GUID> resources = new HashSet<GUID>();
        UserGroupManager manager = UserGroupManager.getInstance();
        for (UserGroupInfo group : manager.getGroupsForUserIncludingDeactivated(accountID)) {
            if (group.getType() != HDUsersAndGroups.RESOURCE || !filter.test(group)) continue;
            resources.add(group.getID());
        }
        for (UserGroupInfo group : manager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE)) {
            if (group.hasMembers() || !resources.contains(group.getParentID()) || !filter.test(group)) continue;
            resources.add(group.getID());
        }
        return resources;
    }

    @Override
    public int getMetaDataVersion() {
        return this.metaDataVersion;
    }

    public void incMetaDataVersion() {
        ++this.metaDataVersion;
    }

    private static class SubResources
    extends SubView<GUID> {
        @Nonnull
        private final HashSet<GUID> allIds = new HashSet();
        private final HashSet<GUID> resourcesWithAccess = new HashSet();
        private List<SubView<?>> subViews;

        public SubResources(@Nonnull TicketViewFactory parent, @Nonnull GUID resId, String displayName, String iconKey, boolean readAccessToResource) {
            super(parent, INSTANCE, resId, displayName, null, iconKey);
            this.allIds.add(resId);
            if (readAccessToResource) {
                this.resourcesWithAccess.add(resId);
            }
        }

        @Override
        public SubViewGroupingDefinition getSubViewGrouping() {
            return INSTANCE;
        }

        @Override
        public Object getFilterID() {
            return this;
        }

        private void addSubResource(GUID resId, SubResources view, boolean isHideSubnodeTickets) {
            if (this.subViews == null) {
                this.subViews = new ArrayList();
            }
            this.subViews.add(view);
            if (!isHideSubnodeTickets) {
                this.allIds.add(resId);
                if (view.resourcesWithAccess.contains(resId)) {
                    this.resourcesWithAccess.add(resId);
                }
            }
        }

        @Nullable
        public List<SubView<?>> getSubResources() {
            return this.subViews;
        }
    }

    private static class ResourceX {
        private GUID id;
        private boolean readAccess;

        public ResourceX(@Nonnull GUID id, boolean readAccess) {
            this.id = id;
            this.readAccess = readAccess;
        }
    }
}

