/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JoinIndexIterator<TID>
implements Iterator<Integer> {
    private final Set<Integer> mainIds;
    private final IndexSearchEngine<Integer> mainEngine;
    private final String mainColumn;
    private final boolean forward;
    private final Iterator<Set<TID>> subIterator;
    private Iterator<Integer> nextIds;
    private Integer next;

    @Nonnull
    static JoinIndexIterator<GUID> create(@Nonnull Set<Integer> mainIds, @Nonnull IndexSearchEngine<Integer> mainEngine, @Nonnull String mainColumn, final @Nonnull IndexSearchEngine<GUID> subEngine, final @Nonnull String subColumn, final boolean forward) {
        final SearchTag tag = subEngine.getTag(subColumn);
        return new JoinIndexIterator<GUID>(mainIds, mainEngine, mainColumn, switch (tag.getDataType()) {
            case SearchDataType.IntegerMap, SearchDataType.StringMap -> {
                Map mapData = tag.getMapData();
                final ArrayList entries = new ArrayList(mapData.entrySet());
                Comparator<Map.Entry> comp = Comparator.comparing(Map.Entry::getValue, Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER));
                if (!forward) {
                    comp = Collections.reverseOrder(comp);
                }
                entries.sort(comp);
                yield new Iterator<Set<GUID>>(){
                    private Iterator<Map.Entry<Object, String>> it;
                    {
                        this.it = entries.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Set<GUID> next() {
                        Map.Entry<Object, String> entry = this.it.next();
                        return subEngine.simpleSearch(new SearchCommand(subColumn, SearchCondition.SearchTermOperator.Equals, entry.getKey()));
                    }
                };
            }
            default -> new Iterator<Set<GUID>>(){
                private Iterator<GUID> it;
                {
                    this.it = subEngine.createIdsIterator(tag, forward);
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Set<GUID> next() {
                    return Collections.singleton(this.it.next());
                }
            };
        }, forward);
    }

    public JoinIndexIterator(@Nonnull Set<Integer> mainIds, @Nonnull IndexSearchEngine<Integer> mainEngine, @Nonnull String mainColumn, @Nonnull Iterator<Set<TID>> subIterator, boolean forward) {
        this.mainIds = mainIds;
        this.mainEngine = mainEngine;
        this.mainColumn = mainColumn;
        this.forward = forward;
        this.subIterator = subIterator;
    }

    @Nullable
    private Iterator<Integer> getNextIds() {
        if (this.nextIds != null && this.nextIds.hasNext()) {
            return this.nextIds;
        }
        while (this.subIterator.hasNext()) {
            Set<TID> tid = this.subIterator.next();
            SearchCommand command = new SearchCommand(this.mainColumn, SearchCondition.SearchTermOperator.IN, tid);
            Set ids = this.mainEngine.simpleSearch(command);
            if (ids.size() == 0) continue;
            ArrayList list = new ArrayList(ids);
            list.sort(this.forward ? Comparator.naturalOrder() : Comparator.reverseOrder());
            this.nextIds = list.iterator();
            return this.nextIds;
        }
        this.nextIds = null;
        return null;
    }

    @Override
    public boolean hasNext() {
        Integer nextVal;
        if (this.next != null) {
            return true;
        }
        block0: while (true) {
            Iterator<Integer> ids;
            if ((ids = this.getNextIds()) == null) {
                return false;
            }
            do {
                if (!ids.hasNext()) continue block0;
            } while (!this.mainIds.contains(nextVal = ids.next()));
            break;
        }
        this.next = nextVal;
        return true;
    }

    @Override
    public Integer next() {
        if (this.hasNext()) {
            Integer val = this.next;
            this.next = null;
            return val;
        }
        throw new NoSuchElementException();
    }
}

