/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.datasource;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeGUID;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.reporting.HDReporting;
import com.inet.helpdesk.core.reporting.TicketDataSourceConfigurationExtension;
import com.inet.helpdesk.core.reporting.server.datasource.ITicketDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.datasource.TicketDataResultSet;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.search.SearchTagBundleSlave;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class TicketDataSourceConfiguration
extends BaseDataFactory
implements ITicketDataSourceConfiguration {
    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        List prompts = ts.getInputParameters();
        Set<Integer> searchResult = prompts.size() > 0 ? this.getTicketsByParameter(ts) : Collections.emptySet();
        TicketDataResultSet rs = new TicketDataResultSet(searchResult, this, ts.getDatabaseIdentifier(), this.getColumnPairs(ts.getDatabaseIdentifier()));
        return new TableData((ResultSet)((Object)rs));
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> result = new HashMap<String, TableSourceInfo>();
        result.put("TicketById", new TableSourceInfo(null, null, "TicketById", 20));
        result.put("TicketAdhoc", new TableSourceInfo(null, null, "TicketAdhoc", 20));
        return result;
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        String table;
        switch (table = ts.getDatabaseIdentifier()) {
            case "TicketById": 
            case "TicketAdhoc": {
                break;
            }
            default: {
                HDLogger.debug(new IllegalArgumentException("[TicketDataSourceConfiguration] Illegal attempt to getColumns for unknown table " + table));
                return List.of();
            }
        }
        List<ColumnInfo> collect = this.getColumnPairs(table).stream().map(p -> (DataSourceUtils.ColumnInfoWithLabel)p.getValue()).collect(Collectors.toList());
        this.addPromptParameter(collect, ts);
        return collect;
    }

    public List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> getColumnPairs(String table) {
        ArrayList<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols = new ArrayList<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>>();
        List list = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        Collections.sort(list, (d1, d2) -> d1.getPriority() - d2.getPriority());
        if (table.equals("TicketAdhoc")) {
            cols.add(Map.entry("ticketownerid", new DataSourceUtils.ColumnInfoWithLabel("ticketownerid", "ticketownerid", 11)));
            cols.add(Map.entry(Tickets.ATTRIBUTE_CLOSE_DATE.getKey(), new DataSourceUtils.ColumnInfoWithLabel(Tickets.ATTRIBUTE_CLOSE_DATE.getKey(), Tickets.ATTRIBUTE_CLOSE_DATE.getLabel(), 9)));
            cols.add(Map.entry("ticketText", new DataSourceUtils.ColumnInfoWithLabel("ticketText", MSG.getMsg("column_ticketText", new Object[0]), 11)));
            cols.add(Map.entry("ticketTextIsHtml", new DataSourceUtils.ColumnInfoWithLabel("ticketTextIsHtml", "ticketTextIsHtml", 8)));
            cols.add(Map.entry("priorityidValue", new DataSourceUtils.ColumnInfoWithLabel("priorityidValue", "priorityidValue", 11)));
        }
        for (TicketFieldDefinition fieldDef : list) {
            if (fieldDef.getDisplayType() == null || !fieldDef.isAvailable()) continue;
            Field<?> field = this.getFieldOrAttributeFromKey(fieldDef.getKey());
            if (table.equals("TicketAdhoc") && DataSourceUtils.showDisplayValueForField(field)) {
                cols.add(Map.entry(fieldDef.getKey(), new DataSourceUtils.ColumnInfoWithLabel(fieldDef.getKey(), fieldDef.getDisplayName(), 11)));
                continue;
            }
            int reportFieldType = field == null ? 11 : (field.getFieldType() instanceof FieldTypeDate ? (((FieldTypeDate)field.getFieldType()).isDateWithTime() ? 15 : 9) : (field.getFieldType() instanceof FieldTypeString ? 11 : (field.getFieldType() instanceof FieldTypeBoolean ? 8 : (field.getFieldType() instanceof FieldTypeInteger ? 6 : (field.getFieldType() instanceof FieldTypeSelect_Int ? 6 : (field.getFieldType() instanceof FieldTypeSelect_String ? 11 : (field.getFieldType() instanceof FieldTypeGUID ? 11 : (field.getFieldType() instanceof FieldTypeTime ? 10 : (field.getFieldType() instanceof FieldTypeCurrency ? 7 : (field.getFieldType() instanceof FieldTypeDouble ? 6 : (field.getFieldType() instanceof FieldTypeRating ? 6 : 11)))))))))));
            String columnName = table.equals("TicketById") ? fieldDef.getKey() : fieldDef.getLabel();
            cols.add(Map.entry(fieldDef.getKey(), new DataSourceUtils.ColumnInfoWithLabel(fieldDef.getKey(), columnName, reportFieldType)));
        }
        ServerPluginManager.getInstance().get(TicketDataSourceConfigurationExtension.class).forEach(ext -> ext.patchColumns(cols));
        return cols;
    }

    public Field<?> getFieldOrAttributeFromKey(@Nonnull String fieldKey) {
        TicketField field = Tickets.getFieldByKey(fieldKey);
        if (field == null && (field = Tickets.getAttributeByKey(fieldKey)) == null && fieldKey.equals("ticketid")) {
            field = Tickets.ATTRIBUTE_TICKET_ID;
        }
        return field;
    }

    private Set<Integer> getTicketsByParameter(TableSource ts) throws ReportException {
        String databaseIdentifier = ts.getDatabaseIdentifier();
        if (databaseIdentifier != null) {
            if ("TicketById".equals(databaseIdentifier)) {
                PromptField promptField = (PromptField)ts.getInputParameters().get(0);
                Object value = promptField.getValue();
                Integer ticketId = ((Number)value).intValue();
                if (ticketId != null && TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId)) {
                    return Set.of(ticketId);
                }
                return Set.of();
            }
            if ("TicketAdhoc".equals(databaseIdentifier)) {
                Optional<PromptField> promptField = ts.getInputParameters().stream().filter(f -> f.getName().equals("TicketSearchPhrase")).findFirst();
                if (promptField.isPresent()) {
                    Object value = promptField.get().getValue();
                    String json = (String)value;
                    DataViewConditions filter = (DataViewConditions)new Json().fromJson(json, DataViewConditions.class);
                    if (filter == null) {
                        return Set.of();
                    }
                    AndSearchExpression expression = ITicketDataSourceConfiguration.buildSearchPhraseForTicketTable(filter, "TicketAdhoc", HDReporting.joinTokenInfoForTicketTable());
                    SearchCommand comand2 = new SearchCommand(new SearchExpression[]{expression});
                    OrSearchExpression globalSearchExpressionForAllVisibleTickets = GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(UserManager.getInstance().getCurrentUserAccountID(), ClientLocale.getThreadLocale(), false);
                    if (globalSearchExpressionForAllVisibleTickets != null) {
                        comand2.getSearchExpression().add((SearchExpression)globalSearchExpressionForAllVisibleTickets);
                    }
                    comand2.getSearchExpression().add((SearchExpression)new SearchCondition("bundleslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagBundleSlave.FALSE));
                    ServerPluginManager.getInstance().get(TicketDataSourceConfigurationExtension.class).forEach(ext -> ext.patchSearchCommand(comand2));
                    Set resultFromPrompt = TicketManager.getReader().getSearchEngine().simpleSearch(comand2);
                    return resultFromPrompt;
                }
                return Set.of();
            }
        }
        throw ReportExceptionFactory.createReportException((ErrorCode)ReportErrorCode.TableNotFound, (Object[])new Object[]{ts.getDatabaseIdentifier()});
    }

    private void addPromptParameter(List<ColumnInfo> cols, TableSource ts) throws ReportException {
        if (ts.getDatabaseIdentifier().equals("TicketById")) {
            cols.add(new ColumnInfo("TicketId", 6, 1, 4, 0));
        } else if (ts.getDatabaseIdentifier().equals("TicketAdhoc")) {
            cols.add(new ColumnInfo("TicketSearchPhrase", 11, 1, 12, 0));
        }
    }
}

