/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner.jobs;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.MySQLSetInnoDBCommand;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.IJob;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JobPrepareTables
implements IJob {
    @Override
    public JobStructure createCommands(DatabaseInfos targetCon, Node model) {
        if (model.getName() != NodeFactory.TAG.database) {
            throw new IllegalArgumentException("The JobPrepareTables can be used only for databases!");
        }
        if (model.getDiffSource() == null || model.getDiffTarget() == null) {
            return null;
        }
        if (!"MySQL".equals(targetCon.getDBMSTypeName())) {
            return null;
        }
        HashMap sourceTable = new HashMap();
        model.getDiffSource().getChildren(NodeFactory.TAG.table).forEach(t -> sourceTable.put(t.getParameter("name").toLowerCase(), t));
        HashMap currentTable = new HashMap();
        model.getDiffTarget().getChildren(NodeFactory.TAG.table).forEach(t -> currentTable.put(t.getParameter("name").toLowerCase(), t));
        ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
        for (Map.Entry e : sourceTable.entrySet()) {
            if (!currentTable.containsKey(e.getKey()) || "innodb".equals(((Node)e.getValue()).getParameter("engine"))) continue;
            commands.add(new MySQLSetInnoDBCommand(targetCon, (Node)currentTable.get(e.getKey())));
        }
        if (commands.size() > 0) {
            JobStructure structure = new JobStructure();
            structure.addCommands(commands);
            return structure;
        }
        return null;
    }
}

