/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DBReader;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.BaseAlterColumnCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.Constructor;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.NodeTrigger;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MSSQLAlterColumnCommand
extends BaseAlterColumnCommand {
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");
    DatabaseInfos dbInfo;
    private final Node name;
    private final String prefix;
    private String statement;
    private String origDropDefault;
    private String altDropDefault;
    private Node element;
    private ICommandFactory.COMMAND_TYPE action;

    public MSSQLAlterColumnCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        super(dbInfo);
        this.name = tableName;
        this.dbInfo = dbInfo;
        this.prefix = "ALTER TABLE " + ((ISchemaNode)((Object)this.name)).getSourceName(dbInfo) + " ";
    }

    @Override
    public int execute() throws SQLException {
        String isautoincrement = this.element.getParameter(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name());
        if (this.action == ICommandFactory.COMMAND_TYPE.alter && isautoincrement != null && "false".equalsIgnoreCase(isautoincrement)) {
            this.removeIdentitiy();
            return 1;
        }
        String sqlStatement = this.getSqlStatement();
        try {
            int executeUpdate = this.dbInfo.getDBConnection().executeUpdate(sqlStatement);
            return executeUpdate;
        }
        catch (SQLException sqle) {
            if (this.origDropDefault != null && this.altDropDefault != null) {
                sqlStatement = sqlStatement.replace(this.origDropDefault, this.altDropDefault);
                return this.dbInfo.getDBConnection().executeUpdate(sqlStatement) > 0 ? 1 : -1;
            }
            throw sqle;
        }
    }

    private void removeIdentitiy() throws SQLException {
        Node sourceNode = this.element.getParent();
        NodeFactory root = new NodeFactory();
        Constructor constructor = new Constructor(root);
        DBReader reader = new DBReader(this.dbInfo, constructor);
        String tableName = sourceNode.getParameter(IDatabaseInfos.TABLE_PARAM.name.name());
        String tableSchema = sourceNode.getParameter(IDatabaseInfos.TABLE_PARAM.schema.name());
        reader.readTable(null, tableSchema, tableName, null);
        Node currentTable = constructor.getRoot();
        DBConnection connection = this.dbInfo.getDBConnection();
        String tableTemp = tableName + "TEMP";
        this.createTableCopy(currentTable, tableTemp, true);
        connection.executeUpdate("ALTER TABLE " + this.dbInfo.getQuoteIdentiferIfNeeded(tableName) + " SWITCH TO " + this.dbInfo.getQuoteIdentiferIfNeeded(tableTemp));
        connection.executeUpdate("DROP TABLE " + this.dbInfo.getQuoteIdentiferIfNeeded(tableName));
        this.createTableCopy(currentTable, tableName, false);
        connection.executeUpdate("ALTER TABLE " + this.dbInfo.getQuoteIdentiferIfNeeded(tableTemp) + " SWITCH TO " + this.dbInfo.getQuoteIdentiferIfNeeded(tableName));
        connection.executeUpdate("DROP TABLE " + this.dbInfo.getQuoteIdentiferIfNeeded(tableTemp));
    }

    private void createTableCopy(Node currentTable, String tableCopyName, boolean renameReferences) throws SQLException {
        Node tableCopy = currentTable.replicate(0);
        ICommandFactory factory = this.dbInfo.getCommandFactory();
        tableCopy.readParameter(IDatabaseInfos.TABLE_PARAM.name.name(), tableCopyName);
        Node columnToModify = tableCopy.findChildMatching(this.element.getKeyValueOriginalCase(), NodeFactory.TAG.column);
        columnToModify.readParameter(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name(), "false");
        ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
        IComposedCommand tableCommand = factory.getCommand(ICommandFactory.COMMAND_TYPE.create, NodeFactory.TAG.table, IDatabaseCommand.TIME.addstructure, tableCopy, tableCopyName);
        commands.add(tableCommand);
        for (NodeFactory.TAG tag : tableCopy.getAllowedChildren()) {
            List<? extends Node> children = tableCopy.getChildren(tag);
            if (children == null || children.size() <= 0) continue;
            for (Node node : children) {
                if (renameReferences) {
                    String currentName;
                    if (tag == NodeFactory.TAG.index && (currentName = node.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name())) != null) {
                        node.readParameter(IDatabaseInfos.INDEX_PARAM.index_name.name(), currentName + "COPY");
                    }
                    if (tag == NodeFactory.TAG.reference && (currentName = node.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name())) != null) {
                        node.readParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name(), currentName + "COPY");
                    }
                }
                IComposedCommand.addToList(commands, tableCommand.addDataset(node, ICommandFactory.COMMAND_TYPE.create));
            }
        }
        for (IComposedCommand command : commands) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSqlStatement() {
        AttributeMap<String> attributes = this.element.getAttributeMap();
        String sourceTable = ((ISchemaNode)((Object)this.name)).getSourceName(this.dbInfo);
        String origTableName = ((ISchemaNode)((Object)this.name)).getName(this.dbInfo);
        String name = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_name);
        if (name == null) {
            throw new IllegalStateException("Cannot alter an unnamed column in table '" + sourceTable + "'");
        }
        String data_type = this.element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.data_type.name());
        String decimal_digits = this.element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.decimal_digits.name());
        String column_size = this.element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.column_size.name());
        String type_name = this.element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.type_name.name());
        String column_def = this.element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.column_def.name());
        String isnotnullable = this.element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.isnotnullable.name());
        String colName = this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.column_name.name()));
        if (data_type != null) {
            try {
                int iData_Type = 0;
                int iSize = 0;
                int iScale = 0;
                try {
                    iData_Type = Integer.parseInt(data_type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    iSize = Integer.parseInt(column_size);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    iScale = Integer.parseInt(decimal_digits);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    iData_Type = Integer.parseInt(data_type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String dataType = this.dbInfo.getDestDataType(iData_Type, iSize, iScale, type_name, false);
                StringBuilder b = new StringBuilder();
                String tempPk = null;
                try (ResultSet result = null;){
                    result = this.dbInfo.getDBConnection().executeQuery("select pk.CONSTRAINT_NAME as constrName from INFORMATION_SCHEMA.TABLE_CONSTRAINTS pk , INFORMATION_SCHEMA.KEY_COLUMN_USAGE c where pk.TABLE_NAME = '" + origTableName + "' AND c.COLUMN_NAME = '" + colName + "' and CONSTRAINT_TYPE = 'PRIMARY KEY' and c.TABLE_NAME = pk.TABLE_NAME and c.CONSTRAINT_NAME = pk.CONSTRAINT_NAME;");
                    while (result != null && result.next()) {
                        tempPk = result.getString("constrName");
                    }
                }
                if (tempPk != null) {
                    b.append(this.prefix + "DROP CONSTRAINT " + this.dbInfo.getQuote(tempPk) + "; ");
                }
                Object tempDF = null;
                result = null;
                try {
                    try {
                        result = this.dbInfo.getDBConnection().executeQuery("select object_name(c.default_object_id) as bound_to_default from sys.columns as c join sys.tables as t on t.object_id = c.object_id join sys.schemas as s on s.schema_id = t.schema_id where c.default_object_id is not null and c.default_object_id is not null AND t.name='" + origTableName + "' AND c.name='" + colName + "';");
                    }
                    catch (SQLException sqle) {
                        result = this.dbInfo.getDBConnection().executeQuery("select o.name as bound_to_default from syscolumns c inner join sysobjects o on c.cdefault = o.id  where c.cdefault > 0 and object_name(c.id) = '" + origTableName + "' and c.name = '" + colName + "';");
                    }
                    while (result != null && result.next()) {
                        tempDF = result.getString("bound_to_default");
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Throwable)sqle);
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
                if (tempDF != null) {
                    this.origDropDefault = this.prefix + "DROP CONSTRAINT " + this.dbInfo.getQuote((String)tempDF) + "; ";
                    this.altDropDefault = "EXEC sp_unbindefault '" + sourceTable + "." + colName + "'; ";
                    b.append(this.origDropDefault);
                } else {
                    tempDF = "DF_" + origTableName + "_" + colName;
                }
                b.append(this.prefix);
                b.append(" ALTER COLUMN ");
                b.append(colName).append(" ");
                b.append(dataType).append(" ");
                b.append("true".equals(isnotnullable) ? "NOT NULL" : "NULL").append(" ");
                b.append(";");
                if (column_def != null && !"#removed#".equals(column_def)) {
                    b.append(this.prefix + "add Constraint " + (String)tempDF + " Default " + this.dbInfo.getQuotedValue(column_def, iData_Type) + " For " + this.dbInfo.getQuote(colName) + ";");
                }
                if (tempPk != null) {
                    b.append(this.prefix + "ADD CONSTRAINT " + this.dbInfo.getQuote(tempPk) + " PRIMARY KEY (" + this.dbInfo.getQuote(colName) + "); ");
                }
                this.statement = b.toString();
            }
            catch (SQLException e) {
                logger.error((Object)"Alter for MSSQL failed");
                logger.error((Throwable)e);
            }
        }
        return this.statement;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        if (this.element != null || this.action != null || this.statement != null) {
            return false;
        }
        if (action != ICommandFactory.COMMAND_TYPE.alter) {
            return false;
        }
        NodeFactory.TAG type = element.getName();
        return type == NodeFactory.TAG.column;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.alterstructure;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        List<IComposedCommand> commands;
        String type2;
        this.element = element;
        this.action = action;
        if (action != ICommandFactory.COMMAND_TYPE.alter) {
            return null;
        }
        String isautoincrement = element.getParameter(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name());
        String isNotNull = element.getParameter(IDatabaseInfos.COLUMN_PARAM.isnotnullable.name());
        String type1 = element.getDiffSource().getParameter(IDatabaseInfos.COLUMN_PARAM.data_type.name());
        if (!Objects.equals(type1, type2 = element.getDiffTarget().getParameter(IDatabaseInfos.COLUMN_PARAM.data_type.name())) && (commands = this.wrapInReferenceUnbind(element, true)) != null) {
            return commands;
        }
        if (isautoincrement != null && "false".equalsIgnoreCase(isautoincrement)) {
            List<IComposedCommand> commands2;
            Node table = element.getParent();
            Node database = table.getParent();
            List<? extends Node> triggers = database.getChildren(NodeFactory.TAG.trigger);
            if (triggers != null && triggers.size() > 0) {
                String tableName = table.getParameter(IDatabaseInfos.TABLE_PARAM.name.name());
                for (Node node : triggers) {
                    NodeTrigger tNode = (NodeTrigger)node;
                    String triggerContent = tNode.getContent();
                    if (triggerContent == null || !triggerContent.contains(tableName)) continue;
                    String triggerName = tNode.getParameter(IDatabaseInfos.TRIGGER_PARAM.name.name());
                    throw new SQLException("Cannot change the identity property on table '" + tableName + "' since there is a trigger reference by trigger '" + triggerName + "' to this table. Please remove the trigger manually and run the database setup again.");
                }
            }
            if ((commands2 = this.wrapInReferenceUnbind(element, false)) != null) {
                return commands2;
            }
        } else if (isNotNull != null && (commands = this.wrapInReferenceUnbind(element, true)) != null) {
            return commands;
        }
        return null;
    }
}

