/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionStatusId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager {
    public TicketFieldDefinitionStatusId(int prio) {
        super(Tickets.ATTRIBUTE_STATUS_ID, StatusManager.getInstance(), prio);
        this.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_status_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_status_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_status_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                throw new UnsupportedOperationException("cannot update the status directly!");
            }

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                return false;
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                int statusId = 0;
                statusId = ticket != null ? ticket.getStatusID() : 0;
                SelectOption option = new SelectOption(null, "");
                StatusVO statusVO = (StatusVO)StatusManager.getInstance().get(statusId);
                if (statusVO != null) {
                    option = new SelectOption(String.valueOf(statusId), statusVO.getDisplayValue(), String.valueOf(statusVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionStatusId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionStatusId.this.getDisplayName();
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator<StatusVO> comparator = new Comparator<StatusVO>(){

                    @Override
                    public int compare(StatusVO o1, StatusVO o2) {
                        return o1.getDisplayValue().compareTo(o2.getDisplayValue());
                    }
                };
                List prios = StatusManager.getInstance().getAll(true);
                prios.sort(comparator);
                for (StatusVO statusVO : prios) {
                    String displayValue = statusVO.getDisplayValue();
                    if (displayValue == null) {
                        displayValue = "";
                    }
                    if (searchTerm != null && !displayValue.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    list.add(new SelectOption(String.valueOf(statusVO.getId()), displayValue, String.valueOf(statusVO.getId())));
                }
                if (list.size() < currentSize) {
                    return new SelectOptionResult(0, new ArrayList());
                }
                List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptionResult(list.size(), subList);
            }
        };
    }
}

