/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.cache.MemoryStoreMap;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.command.ConditionTokenMatcher;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class TicketTagsMatcher
implements ConditionTokenMatcher<Integer> {
    private static final String KEY = "tickettags2";
    public static final String ONLY_READ = "onlyread";
    public static final String ONLY_WRITE = "onlywrite";
    public static final String UNREAD = "unread";
    public static final String READ = "read";
    private static final MemoryStoreMap<Locale, Map<String, LocalizedKey>> CACHE = new MemoryStoreMap(60, true);
    private final SearchTag ticketTags;
    private IndexSearchEngine<Integer> searchEngine;

    public TicketTagsMatcher(@Nonnull IndexSearchEngine<Integer> searchEngine) {
        this.searchEngine = searchEngine;
        this.ticketTags = searchEngine.getTag("tickettags");
    }

    public boolean isSuggestedTag() {
        return true;
    }

    @Nonnull
    public String getTag() {
        return KEY;
    }

    @Nonnull
    public SearchDataType getDataType() {
        return SearchDataType.IntegerMap;
    }

    private Map<String, LocalizedKey> getValueMap() {
        return (Map)CACHE.computeIfAbsent((Object)ClientLocale.getThreadLocale(), locale -> {
            HashMap<String, LocalizedKey> map = new HashMap<String, LocalizedKey>();
            TicketTagsMatcher.putTo(map, "myresourceid");
            TicketTagsMatcher.putTo(map, ONLY_READ);
            TicketTagsMatcher.putTo(map, ONLY_WRITE);
            TicketTagsMatcher.putTo(map, UNREAD);
            TicketTagsMatcher.putTo(map, READ);
            return map;
        });
    }

    private static void putTo(@Nonnull Map<String, LocalizedKey> map, @Nonnull String key) {
        String value = HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(key);
        map.put(value.toLowerCase(), new LocalizedKey(key, value));
    }

    @Nonnull
    public Iterator<String> createDisplayValuesIterator(String startsWith, Predicate filter) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<LocalizedKey> it = this.searchEngine.createDisplayValuesIterator(this.ticketTags, (Comparable)((Object)startsWith), filter);
        while (it.hasNext()) {
            list.add((String)it.next());
        }
        for (LocalizedKey value : this.getValueMap().values()) {
            list.add(value.getDisplayName());
        }
        String starts = startsWith.toLowerCase();
        list.removeIf(v -> !v.toLowerCase().startsWith(starts));
        list.sort(null);
        return list.iterator();
    }

    @Nonnull
    public String getDisplayName() {
        return HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName("tickettags");
    }

    @Nonnull
    public SearchExpression createSearchExpression(@Nonnull String value, @Nonnull SearchCondition.SearchTermOperator operator, boolean quote, boolean useGenericLocale) {
        String key;
        value = value.toLowerCase();
        if (useGenericLocale) {
            key = value;
        } else {
            LocalizedKey localizedKey = this.getValueMap().get(value);
            String string = key = localizedKey != null ? localizedKey.getKey() : null;
        }
        if (key != null) {
            GUID accountID = UserManager.getInstance().getCurrentUserAccountID();
            switch (key) {
                case "myresourceid": {
                    HashSet<GUID> resourceIDs = ResourceSubViewGrouping.getResourceIDs(accountID);
                    return new TicketTagsSearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resourceIDs, false, "myresourceid");
                }
                case "onlyread": {
                    return this.getReadWriteTickets(true, ONLY_READ);
                }
                case "onlywrite": {
                    return this.getReadWriteTickets(false, ONLY_WRITE);
                }
                case "unread": {
                    return GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(accountID, ClientLocale.getThreadLocale(), true);
                }
                case "read": {
                    return new SubtractSearchExpression((SearchExpression)GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(accountID, ClientLocale.getThreadLocale(), true));
                }
            }
        }
        return new TicketTagsSearchCondition("tickettags", SearchCondition.SearchTermOperator.Equals, value, true, value);
    }

    @Nonnull
    private SearchExpression getReadWriteTickets(boolean onlyRead, final String valueKey) {
        Predicate<UserGroupInfo> matcher;
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        GUID accountID = userAccount.getID();
        boolean writeRight = SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE});
        boolean readRight = SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ});
        OrSearchExpression or = new OrSearchExpression(){

            public void toPhrase(StringBuilder phraseBuilder, IndexSearchEngine<?> searchEngine, boolean toGenericLocale) throws UnsupportedOperationException {
                TicketTagsMatcher.toPhrase_(phraseBuilder, searchEngine, toGenericLocale, valueKey);
            }
        };
        if (writeRight) {
            matcher = null;
            if (!onlyRead) {
                or.add((Object)new SearchCondition("statusid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
            }
        } else if (readRight) {
            if (onlyRead) {
                matcher = null;
                or.add((Object)new SearchCondition("statusid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
            } else {
                matcher = group -> HDUsersAndGroups.hasWritePermissionInResource(accountID, group);
            }
        } else {
            Predicate<UserGroupInfo> predicate = matcher = onlyRead ? group -> HDUsersAndGroups.hasReadPermissionInResource(accountID, group) : group -> HDUsersAndGroups.hasWritePermissionInResource(accountID, group);
        }
        if (matcher != null) {
            HashSet<GUID> resourceIDs = ResourceSubViewGrouping.getResourceIDs(accountID, matcher);
            or.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resourceIDs));
        }
        return or;
    }

    private static void toPhrase_(StringBuilder phraseBuilder, IndexSearchEngine<?> searchEngine, boolean toGenericLocale, String valueKey) {
        String displayName = toGenericLocale ? KEY : HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName("tickettags");
        phraseBuilder.append(TextSearchCommandBuilder.normalizedTagDisplayName((String)displayName));
        phraseBuilder.append(":'");
        if (!toGenericLocale) {
            switch (valueKey) {
                case "myresourceid": 
                case "onlyread": 
                case "onlywrite": 
                case "unread": 
                case "read": {
                    valueKey = HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(valueKey);
                }
            }
        }
        phraseBuilder.append(valueKey);
        phraseBuilder.append('\'');
    }

    static class TicketTagsSearchCondition
    extends SearchCondition {
        private final String valueKey;

        public TicketTagsSearchCondition(String leftOperand, SearchCondition.SearchTermOperator searchTermOperator, Object rightOperand, boolean fromTextParser, String valueKey) {
            super(leftOperand, searchTermOperator, rightOperand, fromTextParser);
            this.valueKey = valueKey;
        }

        public void toPhrase(@Nonnull StringBuilder phraseBuilder, @Nonnull IndexSearchEngine<?> searchEngine, boolean toGenericLocale) {
            TicketTagsMatcher.toPhrase_(phraseBuilder, searchEngine, toGenericLocale, this.valueKey);
        }
    }
}

