/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.dupcontent;

import com.inet.editor.parser.DocumentParser;
import com.inet.editor.parser.ParserDelegator;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.ticketmanager.dupcontent.LineContent;
import com.inet.helpdesk.ticketmanager.dupcontent.TagPosition;
import com.inet.lib.json.FastStringReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

class DuplicateContentParserCallback
extends HTMLEditorKit.ParserCallback {
    @Nonnull
    private Function<String, String> imageNormalizer;
    @Nonnull
    private StringBuilder charBuffer = new StringBuilder();
    @Nonnull
    private final ArrayList<LineContent> lines = new ArrayList();
    private final ProxyDocumentParser parser = new ProxyDocumentParser();
    private TagPosition currentTag;
    private LineContent currentLine;
    private String html;
    private int length;
    private int preCount;
    private int ignoreTagCount;
    private int tableCount;
    private Map<String, String> altImageIds;

    DuplicateContentParserCallback() {
    }

    @Nonnull
    ArrayList<LineContent> parse(@Nonnull String html, @Nonnull Function<String, String> imageNormalizer, @Nonnull Map<String, String> altImageIds) {
        this.imageNormalizer = imageNormalizer;
        this.html = html;
        this.length = html.length();
        this.altImageIds = altImageIds;
        FastStringReader htmlReader = new FastStringReader(html);
        try {
            this.parser.parse((Reader)htmlReader, this, true);
        }
        catch (IOException ex) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
        }
        return this.lines;
    }

    @Override
    public void handleStartTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
        if (tag.breaksFlow()) {
            this.closeCurrentLine(pos);
        }
        this.currentTag = new TagPosition(this.currentTag, pos);
        if (tag == HTML.Tag.PRE) {
            ++this.preCount;
        } else if (tag == HTML.Tag.HEAD || tag == HTML.Tag.STYLE) {
            ++this.ignoreTagCount;
        } else if (tag == HTML.Tag.TABLE) {
            this.closeCurrentLine(pos);
            ++this.tableCount;
        } else if (this.tableCount > 0 && tag == HTML.Tag.TR) {
            this.createCurrentLine(pos);
            this.currentLine.addWordCount(25);
        }
    }

    @Override
    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attr, int pos) {
        Object src;
        if (tag.breaksFlow()) {
            this.createCurrentLine(pos);
            this.closeCurrentLine(pos);
            while (this.currentTag != null && this.currentTag.isBreak()) {
                this.currentTag.setTo(pos);
                this.currentTag = this.currentTag.getParent();
            }
            int to = this.parser.getCurrentPos();
            to = to >= this.length ? this.length : to - 1;
            this.currentTag = new TagPosition(this.currentTag, to, true);
        } else if (tag == HTML.Tag.IMG && (src = attr.getAttribute(HTML.Attribute.SRC)) != null) {
            this.createCurrentLine(pos);
            String normalizeSrc = this.imageNormalizer.apply(src.toString());
            if (normalizeSrc != null) {
                Object alt = attr.getAttribute(HTML.Attribute.ALT);
                if (alt != null) {
                    String altkey = alt.toString() + String.valueOf(attr.getAttribute(HTML.Attribute.WIDTH)) + String.valueOf(attr.getAttribute(HTML.Attribute.HEIGHT));
                    String altSrc = this.altImageIds.putIfAbsent(altkey, normalizeSrc);
                    if (altSrc != null && !altSrc.equals(normalizeSrc)) {
                        this.altImageIds.put(normalizeSrc, altSrc);
                        normalizeSrc = altSrc;
                    }
                } else {
                    String altSrc = this.altImageIds.get(normalizeSrc);
                    if (altSrc != null) {
                        normalizeSrc = altSrc;
                    }
                }
                this.flushBuffer();
                this.currentLine.addText(normalizeSrc.toCharArray());
            }
        }
    }

    @Override
    public void handleEndTag(HTML.Tag tag, int pos) {
        if (this.currentTag != null) {
            int to = this.parser.getCurrentPos();
            while (this.currentTag != null && this.currentTag.isBreak()) {
                this.currentTag.setTo(to >= this.length ? this.length : pos);
                this.currentTag = this.currentTag.getParent();
            }
            to = to >= this.length ? this.length : (this.parser.omitted ? pos : to - 1);
            this.currentTag.setTo(to);
            this.currentTag = this.currentTag.getParent();
        }
        if (tag.breaksFlow()) {
            this.closeCurrentLine(pos);
        }
        if (tag == HTML.Tag.PRE) {
            --this.preCount;
        } else if (tag == HTML.Tag.HEAD || tag == HTML.Tag.STYLE) {
            --this.ignoreTagCount;
        } else if (tag == HTML.Tag.TABLE) {
            --this.tableCount;
            this.closeCurrentLine(pos);
        }
    }

    @Override
    public void handleText(char[] data, int pos) {
        if (this.ignoreTagCount > 0) {
            return;
        }
        this.createCurrentLine(pos);
        int length = data.length;
        if (this.preCount == 0) {
            if (this.charBuffer.length() == 0) {
                block3: for (offset = 0; offset < length; ++offset) {
                    switch (data[offset]) {
                        case ' ': 
                        case '>': {
                            continue block3;
                        }
                    }
                }
            }
            this.charBuffer.append(data, offset, length - offset);
        } else {
            int start;
            int idx;
            this.flushBuffer();
            for (idx = start = pos + length; idx < this.length && this.html.charAt(idx) != '<'; ++idx) {
            }
            if (idx > start) {
                length = idx - pos;
                data = new char[length];
                this.html.getChars(pos, idx, data, 0);
            }
            for (int i = 0; i < length; ++i) {
                if (data[i] != '\n') continue;
                this.currentLine.addText(data, offset, i);
                this.closeCurrentLine(pos + i);
                this.createCurrentLine(pos + i);
                offset = i + 1;
            }
            this.currentLine.addText(data, offset, data.length);
        }
    }

    private void flushBuffer() {
        int len = this.charBuffer.length();
        if (len > 0) {
            char[] chars = new char[len];
            this.charBuffer.getChars(0, this.charBuffer.length(), chars, 0);
            this.currentLine.addText(chars);
            this.charBuffer.setLength(0);
        }
    }

    private void createCurrentLine(int pos) {
        if (this.currentLine == null) {
            this.currentLine = new LineContent(this.currentTag, pos);
            this.lines.add(this.currentLine);
        }
    }

    private void closeCurrentLine(int pos) {
        if (this.tableCount > 0) {
            return;
        }
        if (this.currentLine != null) {
            this.flushBuffer();
            this.currentLine.setTo(pos);
        }
        this.currentLine = null;
    }

    static class ProxyDocumentParser
    extends DocumentParser {
        boolean omitted;

        ProxyDocumentParser() {
            super(ParserDelegator.DEFAULT_DTD);
        }

        protected int getCurrentPos() {
            return super.getCurrentPos();
        }

        protected void endTag(boolean omitted) {
            this.omitted = omitted;
            super.endTag(omitted);
        }
    }
}

