/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.argcontainers;

import com.inet.id.GUID;
import javax.annotation.Nullable;

public class EmailUserVO {
    private final GUID accountID;
    private final String displayName;
    private final String emailAddress;

    public EmailUserVO(@Nullable GUID accountID, String displayName, String emailAddress) {
        if (displayName == null) {
            throw new IllegalArgumentException("display name must not be null");
        }
        if (displayName.trim().isEmpty()) {
            throw new IllegalArgumentException("display name must not be empty after trim");
        }
        if (emailAddress == null) {
            throw new IllegalArgumentException("email address must not be null");
        }
        if (emailAddress.trim().isEmpty()) {
            throw new IllegalArgumentException("email address must not be empty after trim");
        }
        this.accountID = accountID;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
    }

    @Nullable
    public GUID getAccountID() {
        return this.accountID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String toString() {
        return "EmailUserVO [accountID=" + String.valueOf(this.accountID) + ", displayName=" + this.displayName + ", emailAddress=" + this.emailAddress + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountID == null ? 0 : this.accountID.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmailUserVO other = (EmailUserVO)obj;
        if (this.accountID == null ? other.accountID != null : !this.accountID.equals((Object)other.accountID)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        return !(this.emailAddress == null ? other.emailAddress != null : !this.emailAddress.equals(other.emailAddress));
    }
}

