/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.general;

import com.inet.annotations.JsonData;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class RelativeOrAbsoluteDate {
    private boolean absolute;
    private long dateValue;

    protected RelativeOrAbsoluteDate() {
    }

    protected RelativeOrAbsoluteDate(boolean absolute, long dateValue) {
        this.absolute = absolute;
        this.dateValue = dateValue;
    }

    public static RelativeOrAbsoluteDate createAbsolute(long date) {
        return new RelativeOrAbsoluteDate(true, date);
    }

    public static RelativeOrAbsoluteDate createRelative(long durationMS) {
        return new RelativeOrAbsoluteDate(false, durationMS);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isRelative() {
        return !this.absolute;
    }

    public long getValue() {
        return this.dateValue;
    }

    public long toAbsoluteDate() {
        return this.toAbsoluteDate(System.currentTimeMillis());
    }

    public long toAbsoluteDate(long anchorDate) {
        if (this.absolute) {
            return this.dateValue;
        }
        return anchorDate + this.dateValue;
    }

    public String toString() {
        return "RelativeOrAbsoluteDate [absolute=" + this.absolute + ", dateValue=" + this.dateValue + "]";
    }
}

