/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user;

import com.inet.config.ConfigValue;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.UserSearchFilter;
import java.util.List;
import java.util.Objects;

public class UserSearchFilterHD
implements UserSearchFilter {
    private static final ConfigValue<Integer> USER_ACCESS_FILTER = new ConfigValue(HDConfigKeys.USER_ACCESS_FILTER);

    public void customizeUserSearch(SearchCommand command) {
        UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
        if (currentUser == null) {
            throw new AccessDeniedException((ErrorCode)BaseErrorCode.UserNotLoggedIn, new Object[0]);
        }
        boolean isPrivilegedUser = SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{HdPermissions.DISPATCHER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN});
        if (!isPrivilegedUser) {
            if ((Integer)USER_ACCESS_FILTER.get() == 1) {
                command.getSearchExpression().add((SearchExpression)new SearchCondition("location", SearchCondition.SearchTermOperator.Equals, currentUser.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)));
            } else if ((Integer)USER_ACCESS_FILTER.get() == 2) {
                OrSearchExpression supervisorGroupsOrExpression = new OrSearchExpression();
                supervisorGroupsOrExpression.add((Object)new SearchCondition("groupid", SearchCondition.SearchTermOperator.Equals, currentUser.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID)));
                List<UserClassVO> supervisorGroups = UserClassManager.getInstance().getTeamsWhereUserIsSupervisor(currentUser.getID());
                if (!supervisorGroups.isEmpty()) {
                    for (UserClassVO group : supervisorGroups) {
                        supervisorGroupsOrExpression.add((Object)new SearchCondition("groupid", SearchCondition.SearchTermOperator.Equals, (Object)group.getId()));
                    }
                }
                command.getSearchExpression().add((SearchExpression)supervisorGroupsOrExpression);
            }
        }
    }

    public void checkCanSeeUserDetails(UserAccount user) {
        UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
        if (currentUser == null) {
            throw new AccessDeniedException((ErrorCode)BaseErrorCode.UserNotLoggedIn, new Object[0]);
        }
        boolean isPrivilegedUser = SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{HdPermissions.DISPATCHER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN});
        if (!isPrivilegedUser) {
            if ((Integer)USER_ACCESS_FILTER.get() == 1) {
                if (!Objects.equals(user.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID), currentUser.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID))) {
                    throw new AccessDeniedException(HelpDeskUserManager.MSG.getMsg("cannotAccessUserFromOtherClient", new Object[0]), (ErrorCode)BaseErrorCode.forbidden);
                }
            } else if ((Integer)USER_ACCESS_FILTER.get() == 2) {
                if (Objects.equals(user.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID), currentUser.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID))) {
                    return;
                }
                List<UserClassVO> supervisorGroups = UserClassManager.getInstance().getTeamsWhereUserIsSupervisor(currentUser.getID());
                if (!supervisorGroups.isEmpty()) {
                    for (UserClassVO group : supervisorGroups) {
                        if (!Objects.equals(user.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID), group.getId())) continue;
                        return;
                    }
                }
                throw new AccessDeniedException(HelpDeskUserManager.MSG.getMsg("cannotAccessUserFromOtherClient", new Object[0]), (ErrorCode)BaseErrorCode.forbidden);
            }
        }
    }
}

