/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDUserFieldDefinition;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.Map;

public class LanguageUserFieldDefinition
extends SelectUserFieldDefinition<String>
implements HDUserFieldDefinition {
    public LanguageUserFieldDefinition(int prio) {
        super("user.masterdata", (UserField)HDUsersAndGroups.FIELD_LANGUAGE, prio);
    }

    public SelectOption getValue(UserAccount userAccount) {
        String value = null;
        if (userAccount != null) {
            value = (String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
        }
        if (value == null) {
            value = (String)HDUsersAndGroups.FIELD_LANGUAGE.getDefaultValue();
        }
        Map languages = HDUsersAndGroups.FIELD_LANGUAGE.getSearchTag().getMapData();
        return new SelectOption(value, (String)languages.get(value));
    }

    public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
        Map languages = HDUsersAndGroups.FIELD_LANGUAGE.getSearchTag().getMapData();
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, (Map)languages);
    }

    public String convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            try {
                return option.getValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "xx";
    }
}

