/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.login;

import com.inet.authentication.LoginListener;
import com.inet.authentication.LoginProcessor;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.NetworkFunctions;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public class ComputerNameSetter
implements LoginListener {
    public void userLoggedIn(@Nonnull UserAccount userAccount, @Nonnull LoginProcessor loginProcessor) {
        String remoteAddress = SessionStore.getRemoteAddr();
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        String clientDetails = httpServletRequest != null ? httpServletRequest.getHeader("User-Agent") : null;
        ForkJoinPool.commonPool().execute(() -> {
            MutableUserData userData = new MutableUserData();
            ServerOptions serverOptions = new ServerOptions();
            if (!ServerOptions.isOptionSet(16384)) {
                String computerName = remoteAddress;
                InetAddress remoteInetAddress = null;
                try {
                    remoteInetAddress = InetAddress.getByName(remoteAddress);
                    boolean isSameSubnetMask = this.isSameSubnet(remoteInetAddress);
                    computerName = isSameSubnetMask ? remoteInetAddress.getHostName() : "";
                }
                catch (UnknownHostException e) {
                    HDLogger.error(e);
                }
                if (remoteAddress != null && computerName != null && !computerName.isEmpty()) {
                    userData.put((UserField)HDUsersAndGroups.FIELD_COMPUTER_NAME, (Object)computerName);
                }
            }
            userData.put((UserField)HDUsersAndGroups.FIELD_CLIENT_DETAILS, (Object)(clientDetails == null ? "" : clientDetails));
            UserManager.getInstance().updateUserData(userAccount.getID(), userData);
        });
    }

    private boolean isSameSubnet(InetAddress remoteInetAddress) {
        if (remoteInetAddress.isLoopbackAddress()) {
            return true;
        }
        boolean isSameSubnetMask = false;
        byte[] remoteAddressBytes = remoteInetAddress.getAddress();
        InetAddress localHost = NetworkFunctions.getLocalHost();
        NetworkInterface networkInterface = null;
        try {
            networkInterface = NetworkInterface.getByInetAddress(localHost);
            if (networkInterface == null) {
                HDLogger.debug("no network interface found");
                return false;
            }
            List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
            if (interfaceAddresses == null) {
                HDLogger.debug("no network interface addresses found");
                return false;
            }
            for (InterfaceAddress ip : interfaceAddresses) {
                byte[] networkAddress = ip.getAddress().getAddress();
                short prefix = ip.getNetworkPrefixLength();
                boolean isSame = true;
                for (int i = 0; i < prefix / 8; ++i) {
                    if (networkAddress[i] == remoteAddressBytes[i]) continue;
                    isSame = false;
                    break;
                }
                if (!isSame) continue;
                isSameSubnetMask = true;
                break;
            }
        }
        catch (SocketException e) {
            HDLogger.error(e);
        }
        return isSameSubnetMask;
    }
}

