/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;

public class ZipAttachmentDisplayProvider
implements AttachmentDisplayProvider {
    @Override
    public String getType() {
        return "zip";
    }

    @Override
    public String getSourceOrContent(String mimeType, AttachmentRow attachment) {
        try {
            AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
            AttachmentFileRow attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength());
            if (attachmentFile != null) {
                PersistenceEntry file = AppDataLocation.getAttachmentFile(attachmentFile.getFilePath());
                return this.readZipContent(file.getInputStream());
            }
        }
        catch (Throwable t) {
            LogManager.getApplicationLogger().debug((Object)t);
        }
        return null;
    }

    String readZipContent(InputStream fileStream) throws IOException {
        try (ZipInputStream inputStream = new ZipInputStream(fileStream, Charset.forName("CP437"));){
            ZipEntry entry = null;
            ArrayList<ZipAttachmentEntry> entries = new ArrayList<ZipAttachmentEntry>();
            HashMap<String, ZipAttachmentEntry> parents = new HashMap<String, ZipAttachmentEntry>();
            while ((entry = inputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                ZipAttachmentEntry parent = null;
                String name = entry.getName();
                if (name.contains("/")) {
                    String[] parts = name.split("/");
                    Object parentFolder = "";
                    for (int i = 0; i < parts.length - 1; ++i) {
                        String folder = parts[i];
                        if (!((String)parentFolder).isEmpty()) {
                            parentFolder = (String)parentFolder + "/";
                        }
                        parentFolder = (String)parentFolder + folder;
                        ZipAttachmentEntry currentParent = parent;
                        parent = parents.computeIfAbsent((String)parentFolder, k -> {
                            ZipAttachmentEntry e = new ZipAttachmentEntry(folder);
                            if (currentParent != null) {
                                currentParent.addChild(e);
                            } else {
                                entries.add(e);
                            }
                            return e;
                        });
                    }
                    name = parts[parts.length - 1];
                }
                ZipAttachmentEntry zipEntryFile = new ZipAttachmentEntry(name, entry.getName(), entry.getSize(), entry.getTime());
                if (parent != null) {
                    parent.addChild(zipEntryFile);
                    continue;
                }
                entries.add(zipEntryFile);
            }
            entries.sort((a, b) -> {
                if (a.isFolder()) {
                    if (!b.isFolder()) {
                        return -1;
                    }
                } else if (b.isFolder()) {
                    return 1;
                }
                return a.getName().compareToIgnoreCase(b.getName());
            });
            String string = new Json().toJson(entries);
            return string;
        }
    }

    @Override
    public boolean isJsonSerializedSource() {
        return true;
    }

    @Override
    public boolean isResponsible(String mimeType, AttachmentRow attachment) {
        return mimeType != null && mimeType.equals("application/zip");
    }

    @JsonData
    public static class ZipAttachmentEntry {
        private boolean folder;
        private String name;
        private String path;
        private long size;
        private long lastModified;
        private List<ZipAttachmentEntry> children = new ArrayList<ZipAttachmentEntry>();

        private ZipAttachmentEntry() {
        }

        public ZipAttachmentEntry(String name) {
            this.name = name;
            this.folder = true;
        }

        public ZipAttachmentEntry(String name, String path, long size, long lastModified) {
            this.name = name;
            this.path = path;
            this.size = size;
            this.lastModified = lastModified;
        }

        public String getName() {
            return this.name;
        }

        public void addChild(ZipAttachmentEntry child) {
            this.children.add(child);
            this.children.sort((a, b) -> {
                if (a.isFolder()) {
                    if (!b.isFolder()) {
                        return -1;
                    }
                } else if (b.isFolder()) {
                    return 1;
                }
                return a.getName().compareToIgnoreCase(b.getName());
            });
        }

        public List<ZipAttachmentEntry> getChildren() {
            return this.children;
        }

        public boolean isFolder() {
            return this.folder;
        }

        @Nonnull
        public String toString() {
            return this.name + (this.folder ? "/" : "");
        }
    }
}

