/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class TestMinRowsCommand
implements IComposedCommand {
    private final Node table;
    private final int minRowsInt;
    private final DatabaseInfos dbinfo;

    public TestMinRowsCommand(DatabaseInfos dbinfo, Node table, int minRowsInt) {
        this.dbinfo = dbinfo;
        this.table = table;
        this.minRowsInt = minRowsInt;
    }

    @Override
    public int execute() throws SQLException {
        ResultSet rs = this.dbinfo.getDBConnection().executeQuery(this.getSqlStatement());
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        return count >= this.minRowsInt ? 1 : -1;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.cleanup;
    }

    @Override
    public String getSqlStatement() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT count(*) FROM ");
        sb.append(((ISchemaNode)((Object)this.table)).getSourceName(this.dbinfo));
        return sb.toString();
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        return null;
    }
}

