/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCreateIndexCommand;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.OracleAlterTableSetUniqueCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.Node;
import java.sql.SQLException;
import java.util.List;

public class OracleCreateIndexCommand
extends DefaultCreateIndexCommand {
    private DatabaseInfos dbInfo;
    private OracleAlterTableSetUniqueCommand subCommand;
    private Node tableName;
    private Boolean isUnique;

    public OracleCreateIndexCommand(DatabaseInfos dbInfo, Node tableName) {
        super(dbInfo, tableName);
        this.dbInfo = dbInfo;
        this.tableName = tableName;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        super.addDataset(element, action);
        if (this.isUnique == null) {
            AttributeMap<String> attributes = element.getAttributeMap();
            this.isUnique = !attributes.containsKey((Object)IDatabaseInfos.INDEX_PARAM.non_unique) || !"true".equals(attributes.get((Object)IDatabaseInfos.INDEX_PARAM.non_unique)) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (!this.isUnique.booleanValue()) {
            return null;
        }
        if (this.subCommand == null) {
            this.subCommand = new OracleAlterTableSetUniqueCommand(this.dbInfo, this.tableName);
            return IComposedCommand.createCommandList(this.subCommand, element, action);
        }
        this.subCommand.addDataset(element, action);
        return null;
    }
}

