/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket.step;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.step.TicketStepEntryResponseData;
import com.inet.helpdesk.webapi.ticket.step.HelpDeskTicketStepIdHandler;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Tickets", description="Operations for managing HelpDesk tickets")
@InternalApi
public class HelpDeskTicketStepsHandler
extends RequestHandler.WithParentPathToken<Void, List<ReaStepVO>, Integer> {
    public static final String STEPS_REQUEST_HANDLER_NAME = "steps";

    public HelpDeskTicketStepsHandler() {
        super(new String[]{STEPS_REQUEST_HANDLER_NAME});
        this.setGenericRequestHandler((RequestHandler)new HelpDeskTicketStepIdHandler());
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.steps";
    }

    @Operation(summary="Get ticket steps", description="Retrieves all reaction steps associated with a ticket, optionally filtered by a timestamp", responses={@ApiResponse(responseCode="200", description="Steps retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TicketStepEntryResponseData.class)), examples={@ExampleObject(name="Welcome Ticket Steps", value="[{\"id\":3,\"actionID\":5,\"userGUID\":\"dibcgfn3yhzioc4na1y2jzoey\",\"lastModified\":1738671109000},{\"id\":1,\"actionID\":4,\"userGUID\":null,\"lastModified\":1737991110000}]")})}), @ApiResponse(responseCode="400", description="Invalid ticket ID or since parameter"), @ApiResponse(responseCode="401", description="User not authorized to view ticket steps"), @ApiResponse(responseCode="404", description="Ticket not found")})
    public List<ReaStepVO> handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Nullable Integer ticketId, boolean previewModeEnabled) throws IOException {
        ticketId = HelpDeskWebAPIHelper.checkTicketReadAccessOrThrow(ticketId, response);
        List<ReaStepVO> reaStepsForTicket = TicketManager.getReader().getReaStepsForTicket(ticketId, null);
        String sinceParameter = request.getParameter("since");
        if (sinceParameter != null) {
            try {
                long since = Long.parseLong(sinceParameter);
                reaStepsForTicket.removeIf(r -> r.getEndDate() < since);
            }
            catch (NumberFormatException e) {
                HelpDeskTicketWebAPIExtension.LOGGER.error((Object)("The given 'since' parameter can not be parsed: " + sinceParameter));
            }
        }
        ResponseWriter.json((HttpServletResponse)response, TicketStepEntryResponseData.from(reaStepsForTicket));
        return reaStepsForTicket;
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }
}

