/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.utils.ClientFileFilter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientScriptsWriter {
    private static final String CHARSET = "ISO8859_1";
    private static File clientScripts = new File("../Client/scripts");

    public static void setClientPorts(String htmlPort) {
        if (htmlPort != null) {
            ClientScriptsWriter.writePort2InScripts(htmlPort, clientScripts);
        }
    }

    private static void writePort2InScripts(String newPort2, File dir) {
        Pattern[] patterns;
        if (!dir.exists()) {
            HDLogger.debug("Port change: No Client files available");
            return;
        }
        HDLogger.debug("write Port2 " + newPort2 + " to files in " + dir.getAbsolutePath());
        File[] allFiles = dir.listFiles(new ClientFileFilter(false));
        if (allFiles == null || allFiles.length == 0) {
            HDLogger.debug("Port change: No Client files available");
        } else {
            patterns = new Pattern[]{Pattern.compile("(?<=localhost:)[0-9]+", 2), Pattern.compile("\\$\\{Port2\\}", 2)};
            ClientScriptsWriter.replaceContent(patterns, allFiles, newPort2, CHARSET);
        }
        allFiles = dir.listFiles(new ClientFileFilter(true));
        if (allFiles != null && allFiles.length > 0) {
            patterns = new Pattern[]{Pattern.compile("(?<=name=\"hds.port2\"\\svalue=\")[0-9]+", 2), Pattern.compile("(?<=\\$port2\\s=\\s)[0-9]+", 2), Pattern.compile("(?<=port2\\s)[0-9]+", 2), Pattern.compile("(?<=\\String port2\\s=\\s\")[0-9]+", 2), Pattern.compile("\\$\\{Port2\\}", 2)};
            ClientScriptsWriter.replaceContent(patterns, allFiles, newPort2, CHARSET);
        }
    }

    private static void replaceContent(Pattern[] patterns, File[] files, String newValue, String charset) {
        for (File file : files) {
            try {
                boolean contentChanged = false;
                FileInputStream fileIn = new FileInputStream(file);
                byte[] buffer = new byte[fileIn.available()];
                new DataInputStream(fileIn).readFully(buffer);
                fileIn.close();
                String fileContent = new String(buffer, charset);
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(fileContent);
                    if (!matcher.find()) continue;
                    fileContent = matcher.replaceAll(newValue);
                    contentChanged = true;
                    break;
                }
                if (!contentChanged) continue;
                FileOutputStream fileOut = new FileOutputStream(file);
                fileOut.write(fileContent.getBytes(charset));
                fileOut.close();
            }
            catch (IOException e) {
                HDLogger.error(e);
            }
        }
    }
}

