/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.BaseComposedCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DefaultCreateTableCommand
extends BaseComposedCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private List<String> columns = new ArrayList<String>();
    private List<String> references = new ArrayList<String>();
    private IComposedCommand primary;
    private final Node name;
    private DefaultCommandSyntax syntax;

    public DefaultCreateTableCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableNode) {
        this.name = tableNode;
        this.dbInfo = dbInfo;
        this.syntax = syntax;
    }

    public void addColumn(Node element) throws SQLException {
        String nullableValue;
        boolean identity;
        AttributeMap<String> attributes = element.getAttributeMap();
        if (!attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.column_name)) {
            throw new SQLException("Cannot create an empty column in table '" + String.valueOf(this.name) + "'");
        }
        if (!attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.data_type)) {
            throw new SQLException("Cannot create a table colum in table '" + String.valueOf(this.name) + "' without a data type");
        }
        StringBuilder b = new StringBuilder();
        String colName = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_name).toString();
        b.append(this.dbInfo.getQuoteIdentiferIfNeeded(colName)).append(" ");
        b.append(this.syntax.getTypeString(element)).append(" ");
        String defaultValue = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_def);
        boolean bl = identity = attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement) && "true".equals(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement));
        if (!identity && defaultValue != null) {
            int type = Integer.parseInt(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.data_type));
            if (this.dbInfo.isQuoteableDataType(type)) {
                if (!"null".equalsIgnoreCase(defaultValue)) {
                    defaultValue = this.dbInfo.getQuotedValue(defaultValue, type);
                }
                b.append("DEFAULT ").append(defaultValue).append(" ");
            } else if (defaultValue.length() > 0) {
                b.append("DEFAULT ").append(defaultValue).append(" ");
            }
        }
        if (attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.isnotnullable) && "true".equals(nullableValue = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.isnotnullable).toString())) {
            b.append("NOT NULL ");
        }
        this.columns.add(b.toString());
    }

    public List<IComposedCommand> addIndex(Node element) throws SQLException {
        if (!"true".equals(element.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.isprimarykey))) {
            IComposedCommand command = this.dbInfo.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.create, NodeFactory.TAG.index, null, this.name, null);
            return IComposedCommand.createCommandList(command, element, ICommandFactory.COMMAND_TYPE.create);
        }
        if (this.primary == null) {
            this.primary = this.dbInfo.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.create, NodeFactory.TAG.index, null, this.name, "PRIMARY");
        }
        this.primary.addDataset(element, ICommandFactory.COMMAND_TYPE.create);
        return null;
    }

    public List<IComposedCommand> addReference(Node element) throws SQLException {
        IComposedCommand command = this.dbInfo.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.reference, IDatabaseCommand.TIME.addstructure, this.name, null);
        return IComposedCommand.createCommandList(command, element, ICommandFactory.COMMAND_TYPE.alter);
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE ").append(((ISchemaNode)((Object)this.name)).getName(this.dbInfo)).append("(");
        for (String column : this.columns) {
            b.append(column).append(",");
        }
        if (this.primary != null) {
            b.append(this.primary.getSqlStatement()).append(',');
        }
        for (String reference : this.references) {
            b.append(reference).append(',');
        }
        b.deleteCharAt(b.length() - 1);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        NodeFactory.TAG type = element.getName();
        if (type == NodeFactory.TAG.column) {
            return true;
        }
        if (type == NodeFactory.TAG.reference) {
            return true;
        }
        return type == NodeFactory.TAG.index && "true".equals(element.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.isprimarykey));
    }

    @Override
    public List<IComposedCommand> addProvider(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        NodeFactory.TAG type = element.getName();
        if (type == NodeFactory.TAG.column) {
            this.addColumn(element);
            return null;
        }
        if (type == NodeFactory.TAG.reference) {
            List<IComposedCommand> addReference = this.addReference(element);
            return addReference != null ? addReference : null;
        }
        if (type == NodeFactory.TAG.index) {
            List<IComposedCommand> addIndex = this.addIndex(element);
            return addIndex != null ? addIndex : null;
        }
        return null;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.addstructure;
    }
}

