/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.editor.HtmlConverter;
import com.inet.field.Field;
import com.inet.helpdesk.components.MinutenFeld;
import com.inet.helpdesk.config.AliasMapper;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.MailResourceToAbsenderAndAliasMap;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderProvider;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.mail.MailAttachment;
import com.inet.helpdesk.core.mail.MailMetaData;
import com.inet.helpdesk.core.mail.MailUtilities;
import com.inet.helpdesk.core.mail.SendAutoMailExtension;
import com.inet.helpdesk.core.mailtemplates.DefaultMailTemplates;
import com.inet.helpdesk.core.mailtemplates.MailTemplate;
import com.inet.helpdesk.core.mailtemplates.MailTemplateData;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldClassificationId;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.search.user.tokenmatchers.SupporterUserConditionTokenMatcher;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.logging.Logger;
import com.inet.mail.api.MailDataSource;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import srv.automatic.trigger.Trigger;
import srv.automatic.trigger.TriggerHandler;
import srv.controller.ticket.timeline.ResourceTimelineManager;
import srv.mail.BlackListHandler;
import srv.mail.HelpDeskBaseEmail;
import srv.mail.Mail;
import srv.mail.TemplatePlaceholderReplacementFinder;

public class AutoMail
implements Runnable {
    public static final ConfigValue<String> MAIL_FROM = new ConfigValue(ConfigKey.MAIL_SENDER);
    static final ConfigValue<String> MAIL_USERS_DEF_ABSENDER = new ConfigValue(HDConfigKeys.MAIL_USERS_DEF_ABSENDER);
    static final ConfigValue<String> MAIL_USERS_DEF_ABSENDER_NAME = new ConfigValue(HDConfigKeys.MAIL_USERS_DEF_ABSENDER_NAME);
    static final ConfigValue<String> MAIL_RESOURCES_DEF_ABSENDER = new ConfigValue(HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER);
    static final ConfigValue<String> MAIL_RESOURCES_DEF_ABSENDER_NAME = new ConfigValue(HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER_NAME);
    static final ConfigValue<MailResourceToAbsenderAndAliasMap> MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP = new ConfigValue(HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP);
    private static final ConfigValue<String> MAILTO_DISPATCHER = new ConfigValue(HDConfigKeys.MAILTO_DISPATCHER);
    private static final ConfigValue<String> MAIL_FORMAT = new ConfigValue(HDConfigKeys.MAIL_FORMAT);
    private static final ConfigValue<String> MAIL_LOGO_FILE = new ConfigValue(ConfigKey.IMPRINT_LOGO_URL);
    private static final ConfigValue<String> SUBTEMPLATE_ORDER = new ConfigValue(HDConfigKeys.SUBTEMPLATE_ORDER);
    private static final ConfigValue<String> FOREIGN_KEY_COLUMN = new ConfigValue(HDConfigKeys.FOREIGN_KEY_COLUMN);
    private static final ConfigValue<String> COMPANY_ADDRESS = new ConfigValue(HDConfigKeys.DEFAULT_COMPANY_ADDRESS);
    private static final ConfigValue<Boolean> SEND_TO_ORIGINATOR = new ConfigValue(HDConfigKeys.AUTOMAIL_SEND_TO_ORIGINATOR);
    private static final String DATA_QUERY = "SELECT tblAuf.EmailEingang, tblAuf.BetID, tblAuf.Auftrag, tblAuf.ishtml, tblAuf.DerBetreff, tblAuf.DeadlineZeit, tblAuf.PriID, tblAuf.AutorisierenReaID, tblAuf.spezFeld, tblAuf.WFID, tblAuf.AnfReaID, tblRealisierung.UserID as DisID, tblPrioritaeten.PriBezeichnung, tblRessourcen.ResID, tblRessourcen.ResBezeichnung, tblRessourcen.Email, tblRessourcen.MsgText, tblRessourcen.MsgVon, tblRessourcen.MsgBis, tblRessourcen.Rechte, tblRessourcen.Stundensatz, tblBenutzerGruppe.GroupName, tblKlasse.KlassenName, tblKlasse.KlasseInfo, tblUser.UsrID, tblUser.Nachname, tblUser.Vorname, tblUser.Telefon, tblUser.Email AS UserEmail, tblUser.Zimmer, tblUser.Computername, tblUser.Abteilung, tblUser.Kostenstelle, tblUser.SprID, tblUser.Frei1, tblUser.Frei2, tblUser.Frei3, tblUser.Frei4, tblUser.Frei5, tblUser.Frei6, tblGebaeude.GebBezeichnung, tblGebaeude.Adresse, tblBuendel.*, tblStatus.StatusBezeichnung, tblItil.ItilBezeichnung, tblItil.MsgTyp, tblItil.MsgEmail FROM tblBuendel INNER JOIN tblAuftraege tblAuf ON tblBuendel.BunID = tblAuf.BunID INNER JOIN tblAuftraege tblAuf_master ON tblAuf.BunID = tblAuf_master.AufID INNER JOIN tblItil ON tblAuf.ItiID = tblItil.ItiID INNER JOIN tblKlasse ON tblAuf.KlaID = tblKlasse.KlaID INNER JOIN tblPrioritaeten ON tblAuf.PriID = tblPrioritaeten.PriID INNER JOIN tblStatus ON tblBuendel.Status = tblStatus.Status INNER JOIN tblRessourcen ON tblAuf_master.ResID = tblRessourcen.ResID LEFT OUTER JOIN tblRealisierung ON tblAuf.AutorisierenReaID = tblRealisierung.ReaID LEFT OUTER JOIN tblUser INNER JOIN tblBenutzerGruppe ON tblUser.BgrID = tblBenutzerGruppe.BgrID INNER JOIN tblGebaeude ON tblUser.GebID = tblGebaeude.GebID ON tblAuf.UsrID = tblUser.UsrID WHERE tblAuf.AufID = ?";
    public static final String KEY_ABTEILUNG = "abteilung";
    public static final String KEY_ADRESSE = "adresse";
    public static final String KEY_ANFRAGEDATUM = "anfragedatum";
    public static final String KEY_ANFRAGEDATUMGMT = "anfragedatumgmt";
    public static final String KEY_AUFID = "aufid";
    public static final String KEY_TICKET_GUID = "ticket.guid";
    public static final String KEY_AUFIDXXX = "aufidxxx";
    public static final String KEY_AUFTRAG = "auftrag";
    public static final String KEY_AUFTRAGFREI1 = "auftragfrei1";
    public static final String KEY_AUFTRAGFREI2 = "auftragfrei2";
    public static final String KEY_AUFTRAGFREI3 = "auftragfrei3";
    public static final String KEY_AUFTRAGFREI4 = "auftragfrei4";
    public static final String KEY_AUFTRAGFREI5 = "auftragfrei5";
    public static final String KEY_AUFTRAGFREI6 = "auftragfrei6";
    public static final String KEY_AUFTRAGFREI7 = "auftragfrei7";
    public static final String KEY_AUTOCC = "autocc";
    public static final String KEY_BEARBEITUNGSDATUM = "bearbeitungsdatum";
    public static final String KEY_BENUTZERFREI6 = "benutzerfrei6";
    public static final String KEY_BENUTZERFREI5 = "benutzerfrei5";
    public static final String KEY_BENUTZERFREI4 = "benutzerfrei4";
    public static final String KEY_BENUTZERFREI3 = "benutzerfrei3";
    public static final String KEY_BENUTZERFREI2 = "benutzerfrei2";
    public static final String KEY_BENUTZERFREI1 = "benutzerfrei1";
    public static final String KEY_USERCLASS = "benutzerklasse";
    public static final String KEY_BETREFF = "derbetreff";
    public static final String KEY_BETREFF_MANUAL = "derbetreff_manual";
    public static final String KEY_COMPUTERNAME = "computername";
    public static final String KEY_DATE = "date";
    public static final String KEY_DEADLINEZEIT = "deadlinezeit";
    public static final String KEY_DISPATCHER = "dispatcher";
    public static final String KEY_DISPATCHERUSR = "dispatcherusr";
    public static final String KEY_DISID = "disid";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_EMAILEINGANG = "emaileingang";
    public static final String KEY_EMAIL_DISP = "e-mail disp";
    public static final String KEY_EMAIL_EMPF = "e-mail empfaenger";
    public static final String KEY_EMAIL_EMPF_CC = "e-mail cc";
    public static final String KEY_EMAIL_EMPF_BCC = "e-mail bcc";
    public static final String KEY_EMAIL_SEND = "e-mail absender";
    public static final String KEY_EMAIL_SEND_DISP_NAME = "name absender";
    public static final String KEY_FIRMA = "firma";
    public static final String KEY_LOCATIONBEZEICHNUNG = "gebbezeichnung";
    public static final String KEY_INFO = "info";
    public static final String KEY_ISHTML = "ishtml";
    public static final String KEY_ITILBEZEICHNUNG = "itilbezeichnung";
    public static final String KEY_ITIL_MESSAGE_TYPE = "MsgTyp";
    public static final String KEY_ITIL_MESSAGE_ADDRESS = "MsgEmail";
    public static final String KEY_KATEGORIE = "betreff";
    public static final String KEY_KENNUNG = "kennung";
    public static final String KEY_KLASSIFIZIERUNG = "klassifizierung";
    public static final String KEY_KLASSIFIZIERUNGINFO = "klassifizierunginfo";
    public static final String KEY_KOSTENSTELLE = "kostenstelle";
    public static final String KEY_LETZTERBEARBEITER = "letzterbearbeiter";
    public static final String KEY_LETZTERBEARBEITERGUID = "LetzterBearbeiterGUID";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_LOGO_FILE_KEY = "logo";
    public static final String KEY_MAILTODISPATCHER = "mailtodispatcher";
    public static final String KEY_NACHNAME = "nachname";
    public static final String KEY_PRIBEZEICHNUNG = "pribezeichnung";
    public static final String KEY_PRIID = "priid";
    public static final String KEY_PRODUCER = "producer";
    public static final String KEY_RESANWESEND = "resanwesend";
    public static final String KEY_RESBEZEICHNUNG = "resbezeichnung";
    public static final String KEY_RESMSGTEXT = "resmsgtext";
    public static final String KEY_RESSOURCESTUNDENSATZ = "ressourcestundensatz";
    public static final String KEY_SENDATTACHMENTS = "sendattachments";
    public static final String KEY_SERVERURL = "serverurl";
    public static final String KEY_SOLLZEITVALUE = "sollzeitvalue";
    public static final String KEY_SOLLZEIT = "sollzeit";
    public static final String KEY_STATUS = "status";
    public static final String KEY_STATUSBEZEICHNUNG = "statusbezeichnung";
    public static final String KEY_STEPPRODUCER = "stepproducer";
    public static final String KEY_SUBTEMPLATE = "subtemplate";
    public static final String KEY_SUBTEMPLATEFILE = "subtemplatefile";
    public static final String KEY_SUBTEMPLATELASTSTEP = "subtemplatelaststep";
    public static final String KEY_SUBTEMPLATESORTORDER = "subtemplatesortorder";
    public static final String KEY_SUMMEZEITVALUE = "summezeitvalue";
    public static final String KEY_SUMMEZEIT = "summezeit";
    public static final String KEY_TELEFON = "telefon";
    public static final String KEY_TEMPLATE_NAME = "templatename";
    public static final String KEY_TEMPLATE_SET = "templateset";
    public static final String KEY_TEMPLATE_LANGUAGE = "templatelanguage";
    public static final String KEY_THE_MESSAGE = "the message";
    public static final String KEY_TIME = "time";
    public static final String KEY_TO_TYP = "totyp";
    public static final String KEY_TYP_DESCRIPTION = "typdescription";
    public static final String KEY_USEREMAIL = "useremail";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_VORNAME = "vorname";
    public static final String KEY_WARNING_MSG_KEY = "msgkey";
    public static final String KEY_WVZEIT = "wvzeit";
    public static final String KEY_ZEIT_MAL_RESSOURCESTUNDENSATZ = "zeit_mal_ressourcestundensatz";
    public static final String KEY_ZIMMER = "zimmer";
    public static final String KEY_ISDISPATCHED = "isdispatched";
    public static final String KEY_CC = "cc";
    public static final String KEY_EMPFAENGER = "empfaenger";
    public static final String KEY_ABSENDER = "absender";
    public static final String KEY_STUNDENSATZ = "stundensatz";
    public static final String KEY_WER = "wer";
    public static final String KEY_WAS = "was";
    public static final String KEY_BIS = "bis";
    public static final String KEY_VON = "von";
    public static final String KEY_WANN = "wann";
    public static final String KEY_AKTION = "aktion";
    private static final int ITIL_INCIDENT_NO_MAIL = 0;
    private static final int ITIL_INCIDENT_OWNER_MAIL = 1;
    private static final int ITIL_INCIDENT_RESOURCE_MAIL = 2;
    private static final int ITIL_INCIDENT_ADDRESS_MAIL = 3;
    private static final String DATE_TIME_DEUTSCH = "EE, d. MMMM yyyy H:mm";
    private static final String DATE_TIME_ENGLISH = "EEE, MMMM d. yyyy H:mm";
    private static final String DATE_DEUTSCH = "EE, d. MMMM yyyy";
    private static final String DATE_ENGLISH = "EEE, MMMM d. yyyy";
    private static final ArrayList<String> SIMPLE_TEXT_FIELDS = new ArrayList<String>(){
        {
            this.add(AutoMail.KEY_ABTEILUNG);
            this.add(AutoMail.KEY_BETREFF);
            this.add(AutoMail.KEY_AUFTRAGFREI1);
            this.add(AutoMail.KEY_AUFTRAGFREI2);
            this.add(AutoMail.KEY_AUFTRAGFREI3);
            this.add(AutoMail.KEY_AUFTRAGFREI4);
            this.add(AutoMail.KEY_STATUSBEZEICHNUNG);
            this.add(AutoMail.KEY_STEPPRODUCER);
            this.add(AutoMail.KEY_TELEFON);
            this.add(AutoMail.KEY_THE_MESSAGE);
            this.add(AutoMail.KEY_USERNAME);
            this.add(AutoMail.KEY_VORNAME);
            this.add(AutoMail.KEY_KOSTENSTELLE);
            this.add(AutoMail.KEY_LETZTERBEARBEITER);
            this.add(AutoMail.KEY_LETZTERBEARBEITERGUID);
            this.add(AutoMail.KEY_NACHNAME);
            this.add(AutoMail.KEY_PRIBEZEICHNUNG);
            this.add(AutoMail.KEY_PRODUCER);
            this.add(AutoMail.KEY_RESBEZEICHNUNG);
            this.add(AutoMail.KEY_BENUTZERFREI2);
            this.add(AutoMail.KEY_BENUTZERFREI1);
            this.add(AutoMail.KEY_USERCLASS);
            this.add(AutoMail.KEY_COMPUTERNAME);
            this.add(AutoMail.KEY_DISPATCHER);
            this.add(AutoMail.KEY_ZIMMER);
            this.add(AutoMail.KEY_EMAIL_SEND_DISP_NAME);
            this.add(AutoMail.KEY_LOCATIONBEZEICHNUNG);
            this.add(AutoMail.KEY_ITILBEZEICHNUNG);
            this.add(AutoMail.KEY_KATEGORIE);
            this.add(AutoMail.KEY_KENNUNG);
            this.add(AutoMail.KEY_KLASSIFIZIERUNG);
            this.add(AutoMail.KEY_AUFTRAGFREI5);
            this.add(AutoMail.KEY_AUFTRAGFREI6);
            this.add(AutoMail.KEY_AUFTRAGFREI7);
            this.add(AutoMail.KEY_BENUTZERFREI5);
            this.add(AutoMail.KEY_BENUTZERFREI4);
            this.add(AutoMail.KEY_BENUTZERFREI3);
        }
    };
    private static final boolean RAW = true;
    private Map<String, String> data;
    private int myTyp;
    private String aufID;
    private String bunID;
    private int anfReaId = -1;
    private String datepattern = "EE, d. MMMM yyyy";
    private SimpleDateFormat dateFormatter;
    private MailMetaData mailMetaData = new MailMetaData();
    private TemplatePlaceholderReplacementFinder replacementFinder = new TemplatePlaceholderReplacementFinder();

    public AutoMail(Map<String, String> table, int typ, String producer) {
        this.data = table;
        this.myTyp = typ;
        this.putValues(this.data, typ, producer);
        this.putServerURLValue(this.data);
    }

    private void putServerURLValue(Map<String, String> table) {
        Object replacement = this.replacementFinder.getReplacementForPlaceholderServerURL();
        if (!((String)replacement).endsWith("/")) {
            replacement = (String)replacement + "/";
        }
        table.put(KEY_SERVERURL, (String)replacement);
    }

    private void putValues(Map<String, String> table, int typ, String producer) {
        MailTemplate mailTemplate = DefaultMailTemplates.getDefaultMailTemplatesMap().get(typ);
        if (mailTemplate == null) {
            if (typ == 1) {
                table.put(KEY_TO_TYP, "user");
                table.put(KEY_TYP_DESCRIPTION, "IMAP new Order");
            }
            if (typ == 666) {
                if (table.get(KEY_TO_TYP) == null) {
                    table.put(KEY_TO_TYP, "user");
                }
                table.put(KEY_TYP_DESCRIPTION, "Triggered Mail");
            }
        } else {
            if (mailTemplate.isIncludeProducer() && producer != null && producer.length() > 6) {
                table.put(KEY_PRODUCER, producer);
            }
            table.put(KEY_TO_TYP, mailTemplate.getResponseTo());
            Object filename = mailTemplate.getExtensionName();
            if (filename != null) {
                boolean htmlMail = "html".equals(MAIL_FORMAT.get());
                filename = (String)filename + (htmlMail ? ".html" : ".txt");
                table.put(KEY_TEMPLATE_NAME, (String)filename);
            }
            String warnKey = null;
            switch (typ) {
                case 17: {
                    table.put(KEY_TYP_DESCRIPTION, "Escalation threshold yellow");
                    warnKey = "Esca_Gelb";
                    break;
                }
                case 18: {
                    table.put(KEY_TYP_DESCRIPTION, "Escalation threshold red");
                    warnKey = "Esca_Rot";
                    break;
                }
                case 19: {
                    table.put(KEY_TYP_DESCRIPTION, "Deadline threshold yellow");
                    warnKey = "Dead_Gelb";
                    break;
                }
                case 20: {
                    table.put(KEY_TYP_DESCRIPTION, "Deadline threshold red");
                    warnKey = "Dead_Rot";
                }
            }
            if (warnKey != null) {
                table.put(KEY_WARNING_MSG_KEY, EmailReader_HDProcessing.EMAIL_MESSAGES.getMsg(warnKey, new Object[0]));
            } else {
                String typeDescription = mailTemplate.getTypeDescription();
                if (typeDescription != null) {
                    table.put(KEY_TYP_DESCRIPTION, typeDescription);
                }
            }
        }
    }

    private boolean loadData() throws Exception {
        Exception er = null;
        String account = null;
        boolean dropTheMail = false;
        this.data.put(KEY_SUBTEMPLATESORTORDER, (String)SUBTEMPLATE_ORDER.get());
        String dummy = (String)MAIL_LOGO_FILE.get();
        if (dummy != null && dummy.length() > 0) {
            this.data.put(KEY_LOGO_FILE_KEY, dummy);
        }
        try {
            TicketVO ticket = TicketManager.getReaderForSystem().getTicket(Integer.parseInt(this.aufID));
            if (ticket != null) {
                if (ticket.isSlaveInBundle() && ticket.getOwnerID() != null) {
                    try (UserAccountScope scope = UserAccountScope.create((GUID)ticket.getOwnerID());){
                        ticket = TicketManager.getReader().getTicket(Integer.parseInt(this.aufID));
                    }
                }
                this.bunID = "" + ticket.getBundleID();
                if (this.myTyp == 15) {
                    ItilVO itil = (ItilVO)ItilManager.getInstance().get(ticket.getItilID());
                    int itilWer = itil.getMessageType();
                    if (itilWer == 0) {
                        dropTheMail = true;
                    } else if (itilWer == 1) {
                        this.data.put(KEY_TO_TYP, "user");
                    } else if (itilWer == 2) {
                        this.data.put(KEY_TO_TYP, "resource");
                    } else if (itilWer == 3) {
                        String str = itil.getMessageEmail();
                        if (str == null || str.length() < 8) {
                            dropTheMail = true;
                        } else {
                            this.data.put(KEY_EMAIL_EMPF, str);
                        }
                    }
                }
                if (!dropTheMail) {
                    UserAccount editor;
                    String dateTimePattern;
                    UserAccount ua;
                    Double stundenSatz = null;
                    boolean resAvailable = false;
                    GUID resId = ticket.getResourceID();
                    this.data.put(KEY_SENDATTACHMENTS, "false");
                    if (resId != null) {
                        resAvailable = ResourceTimelineManager.getInstance().isResourceAccessibleNow(HDUsersAndGroups.getResourceId(resId));
                        UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resId);
                        if (resource != null) {
                            boolean sendAttachments;
                            boolean bl = sendAttachments = ((Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS) & 4) != 0;
                            if (sendAttachments && "resource".equals(this.data.get(KEY_TO_TYP))) {
                                this.data.put(KEY_SENDATTACHMENTS, "true");
                            }
                            this.data.put(KEY_EMAIL, (String)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL));
                            this.data.put(KEY_RESBEZEICHNUNG, UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)resource));
                            stundenSatz = (Double)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_HOURLY_RATE);
                        }
                    }
                    this.data.put(KEY_RESANWESEND, String.valueOf(resAvailable));
                    this.data.put(KEY_FIRMA, (String)COMPANY_ADDRESS.get());
                    Integer kategoryID = ticket.getCategoryID();
                    if (kategoryID != null && kategoryID > 0) {
                        try {
                            String categoryPathOrThrow = CategoryManager.getInstance().findCategoryPathOrThrow(kategoryID);
                            this.data.put(KEY_KATEGORIE, categoryPathOrThrow);
                        }
                        catch (Exception e) {
                            HDLogger.error(e);
                        }
                    } else {
                        this.data.put(KEY_KATEGORIE, "");
                    }
                    ReaStepTextVO text = TicketManager.getReaderForSystem().getReaStepText(ticket.getInitialReaStepID());
                    this.data.put(KEY_AUFTRAG, text.getText());
                    this.data.put(KEY_ISHTML, String.valueOf(text.hasHtmlContent()));
                    this.setParam(ticket, Tickets.FIELD_SUBJECT, KEY_BETREFF);
                    this.setParam(ticket, Tickets.FIELD_IDENTIFIER, KEY_KENNUNG);
                    this.setParam(ticket, Tickets.FIELD_PRIORITY_ID, KEY_PRIID, true);
                    this.setParam(ticket, Tickets.FIELD_PRIORITY_ID, KEY_PRIBEZEICHNUNG);
                    this.data.put(KEY_INFO, "");
                    this.data.put(KEY_USERNAME, "");
                    GUID ownerID = ticket.getOwnerID();
                    this.data.put(KEY_LOCALE, EmailReader_HDProcessing.EMAIL_MESSAGES.getMsg("LOKALE", new Object[0]));
                    if (ownerID != null && (ua = UserManager.getInstance().getUserAccount(ownerID)) != null) {
                        this.data.put(KEY_USERNAME, ua.getDisplayName());
                        List logins = ua.getLoginSettings();
                        for (LoginSettings login : logins) {
                            if (!"system".equals(login.getLoginSource())) continue;
                            this.data.put(KEY_USERNAME, login.getLoginID());
                            break;
                        }
                        this.setOwnerParam(ua, HDUsersAndGroups.FIELD_LOCATION_ID, KEY_LOCATIONBEZEICHNUNG);
                        this.setOwnerLocationAddress(ua, KEY_ADRESSE);
                        this.setOwnerParam(ua, HDUsersAndGroups.FIELD_CLASS_ID, KEY_USERCLASS);
                        this.setOwnerParam(ua, HDUsersAndGroups.FIELD_CLASS_ID, "benutzergruppe");
                        this.setOwnerParam(ua, (UserField)UsersAndGroups.FIELD_LASTNAME, KEY_NACHNAME);
                        this.setOwnerParam(ua, (UserField)UsersAndGroups.FIELD_FIRSTNAME, KEY_VORNAME);
                        this.setOwnerParam(ua, (UserField)UsersAndGroups.FIELD_TELEPHONE, KEY_TELEFON);
                        this.setOwnerParam(ua, (UserField)UsersAndGroups.FIELD_EMAIL, KEY_USEREMAIL);
                        this.setOwnerParam(ua, HDUsersAndGroups.FIELD_ROOM, KEY_ZIMMER);
                        this.setOwnerParam(ua, HDUsersAndGroups.FIELD_COMPUTER_NAME, KEY_COMPUTERNAME);
                        this.setOwnerParam(ua, UsersAndGroups.getFieldByKey((String)"department"), KEY_ABTEILUNG);
                        this.setOwnerParam(ua, HDUsersAndGroups.FIELD_COST_CENTRE, KEY_KOSTENSTELLE);
                        this.setOwnerParam(ua, UsersAndGroups.getFieldByKey((String)"custom1"), KEY_BENUTZERFREI1);
                        this.setOwnerParam(ua, UsersAndGroups.getFieldByKey((String)"custom2"), KEY_BENUTZERFREI2);
                        this.setOwnerParam(ua, UsersAndGroups.getFieldByKey((String)"custom3"), KEY_BENUTZERFREI3);
                        this.setOwnerParam(ua, UsersAndGroups.getFieldByKey((String)"custom4"), KEY_BENUTZERFREI4);
                        this.setOwnerParam(ua, UsersAndGroups.getFieldByKey((String)"custom5"), KEY_BENUTZERFREI5);
                        this.setOwnerParam(ua, UsersAndGroups.getFieldByKey((String)"custom6"), KEY_BENUTZERFREI6);
                        String lokaleWert = (String)ua.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
                        if (lokaleWert != null && !"xx".equals(lokaleWert)) {
                            this.data.put(KEY_LOCALE, lokaleWert);
                        }
                    }
                    if ("en".equals(this.data.get(KEY_LOCALE))) {
                        dateTimePattern = DATE_TIME_ENGLISH;
                        this.datepattern = DATE_ENGLISH;
                    } else {
                        dateTimePattern = DATE_TIME_DEUTSCH;
                        this.datepattern = DATE_DEUTSCH;
                    }
                    this.setParam(ticket, Tickets.FIELD_CLASSIFICATION_ID, KEY_KLASSIFIZIERUNG);
                    this.setClassificationInfoParam(ticket, KEY_KLASSIFIZIERUNGINFO);
                    this.setParam(ticket, Tickets.ATTRIBUTE_STATUS_ID, KEY_STATUS, true);
                    this.setParam(ticket, Tickets.ATTRIBUTE_STATUS_ID, KEY_STATUSBEZEICHNUNG);
                    GUID lastEditorID = ticket.getLastEditorID();
                    if (lastEditorID != null && (editor = UserManager.getInstance().getUserAccount(lastEditorID)) != null) {
                        this.data.put(KEY_LETZTERBEARBEITERGUID, editor.getID().toString());
                        this.data.put(KEY_LETZTERBEARBEITER, editor.getDisplayName());
                    }
                    this.setParam(ticket, Tickets.getFieldByKey("custom1"), KEY_AUFTRAGFREI1);
                    this.setParam(ticket, Tickets.getFieldByKey("custom2"), KEY_AUFTRAGFREI2);
                    this.setParam(ticket, Tickets.getFieldByKey("custom3"), KEY_AUFTRAGFREI3);
                    this.setParam(ticket, Tickets.getFieldByKey("custom4"), KEY_AUFTRAGFREI4);
                    this.setParam(ticket, Tickets.getFieldByKey("custom5"), KEY_AUFTRAGFREI5);
                    this.setParam(ticket, Tickets.getFieldByKey("custom6"), KEY_AUFTRAGFREI6);
                    this.setParam(ticket, Tickets.getFieldByKey("custom7"), KEY_AUFTRAGFREI7);
                    this.setParam(ticket, Tickets.FIELD_ITIL_ID, KEY_ITILBEZEICHNUNG);
                    this.dateFormatter = new SimpleDateFormat(dateTimePattern);
                    this.setParam(ticket, Tickets.FIELD_DEADLINE, KEY_DEADLINEZEIT, this.dateFormatter);
                    this.setParam(ticket, Tickets.ATTRIBUTE_INQUIRY_DATE, KEY_ANFRAGEDATUM, this.dateFormatter);
                    MinutenFeld minutenUmrechnung = new MinutenFeld();
                    this.setParam(ticket, Tickets.ATTRIBUTE_SUM_TIME, KEY_SUMMEZEIT, minutenUmrechnung);
                    this.setParam(ticket, Tickets.ATTRIBUTE_SUM_TIME, KEY_SUMMEZEITVALUE, "0");
                    this.setParam(ticket, Tickets.FIELD_TARGET_TIME, KEY_SOLLZEIT, minutenUmrechnung);
                    this.setParam(ticket, Tickets.FIELD_TARGET_TIME, KEY_SOLLZEITVALUE, "0");
                    try {
                        long date = ticket.getInquiryDate();
                        this.data.put(KEY_ANFRAGEDATUMGMT, new Date(date).toGMTString());
                    }
                    catch (Throwable date) {
                        // empty catch block
                    }
                    this.setParam(ticket, Tickets.ATTRIBUTE_LAST_CHANGED, KEY_BEARBEITUNGSDATUM, this.dateFormatter);
                    this.setParam(ticket, Tickets.ATTRIBUTE_WIEDERVORLAGEDATE, KEY_WVZEIT, this.dateFormatter);
                    Locale loc = this.getFormatingLocale(this.data.get(KEY_LOCALE));
                    DateFormat dF = DateFormat.getDateTimeInstance(1, 3, loc);
                    NumberFormat numFormatter = NumberFormat.getCurrencyInstance(loc);
                    int minuten = ticket.getSumTime();
                    if (stundenSatz != null && stundenSatz > 0.0 && minuten > 0) {
                        this.data.put(KEY_RESSOURCESTUNDENSATZ, numFormatter.format(stundenSatz));
                        this.data.put(KEY_ZEIT_MAL_RESSOURCESTUNDENSATZ, numFormatter.format(stundenSatz * (double)minuten / 60.0));
                    } else {
                        this.data.put(KEY_RESSOURCESTUNDENSATZ, "");
                        this.data.put(KEY_ZEIT_MAL_RESSOURCESTUNDENSATZ, "");
                    }
                    String zeit = dF.format(new Timestamp(System.currentTimeMillis()));
                    int posTrennen = zeit.indexOf(58) - 5;
                    posTrennen = zeit.indexOf(32, posTrennen) + 1;
                    this.data.put(KEY_DATE, zeit.substring(0, posTrennen));
                    this.data.put(KEY_TIME, zeit.substring(posTrennen));
                    GUID dispatcherId = null;
                    if (ticket.getDispatchingReaStepID() != null) {
                        dispatcherId = TicketManager.getReaderForSystem().getReaStep(ticket.getDispatchingReaStepID()).getUserID();
                        this.readDispatcherData(dispatcherId);
                    }
                    account = ticket.getEmailEingang();
                    boolean dispatched = ticket.getDispatchingReaStepID() != null;
                    this.data.put(KEY_ISDISPATCHED, Boolean.toString(dispatched));
                    String value = ticket.getValue(Tickets.FIELD_AUTO_CC);
                    if (value == null) {
                        value = "";
                    }
                    this.data.put(KEY_AUTOCC, value);
                    GUID guid = ticket.getAttribute(Tickets.ATTRIBUTE_TICKET_GUID);
                    this.data.put(KEY_TICKET_GUID, guid == null ? "" : guid.toString());
                    this.anfReaId = ticket.getInitialReaStepID();
                }
            } else {
                throw new Exception("Keine Daten " + this.data.get(KEY_TYP_DESCRIPTION) + " " + this.aufID);
            }
            if (!dropTheMail) {
                EmailAccount emailAccount;
                boolean foundEmf;
                this.data.put(KEY_MAILTODISPATCHER, this.getDispatcherEmails());
                account = account != null && account.startsWith("er_") ? account.substring(3) : "";
                this.data.put(KEY_EMAILEINGANG, account);
                dummy = this.data.get(KEY_EMAIL_SEND);
                boolean foundSender = dummy != null && dummy.length() > 0;
                dummy = this.data.get(KEY_EMAIL_EMPF);
                boolean bl = foundEmf = dummy != null && dummy.length() > 0;
                if (!foundSender && account.length() > 0 && (emailAccount = ((EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get()).get(account)) != null) {
                    foundSender = AutoMail.putAbsenderFrom(this.data, emailAccount.getFrom(), emailAccount.getFromName());
                }
                if ("user".equals(this.data.get(KEY_TO_TYP))) {
                    if (!foundEmf && this.data.get(KEY_USEREMAIL) != null) {
                        this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_USEREMAIL));
                    }
                    if (!foundSender) {
                        foundSender = AutoMail.putAbsenderFrom(this.data, (String)MAIL_USERS_DEF_ABSENDER.get(), (String)MAIL_USERS_DEF_ABSENDER_NAME.get());
                    }
                } else if ("resource".equals(this.data.get(KEY_TO_TYP))) {
                    if (!foundEmf) {
                        this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_EMAIL));
                    }
                    MailResourceToAbsenderAndAliasMap mailAbsenderResourceMap = (MailResourceToAbsenderAndAliasMap)MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP.get();
                    String resourceBezeichnung = this.data.get(KEY_RESBEZEICHNUNG);
                    String alias = mailAbsenderResourceMap.getAlias(resourceBezeichnung);
                    String absender = mailAbsenderResourceMap.getAbsender(resourceBezeichnung);
                    if (AutoMail.putAbsenderFrom(this.data, absender, alias)) {
                        foundSender = true;
                    }
                    if (!foundSender) {
                        foundSender = AutoMail.putAbsenderFrom(this.data, (String)MAIL_RESOURCES_DEF_ABSENDER.get(), (String)MAIL_RESOURCES_DEF_ABSENDER_NAME.get());
                    }
                } else if ("alldispatchers".equals(this.data.get(KEY_TO_TYP)) || KEY_DISPATCHER.equals(this.data.get(KEY_TO_TYP))) {
                    String resourceAddress;
                    if (!foundEmf && "alldispatchers".equals(this.data.get(KEY_TO_TYP))) {
                        this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_MAILTODISPATCHER));
                    } else if (!foundEmf && KEY_DISPATCHER.equals(this.data.get(KEY_TO_TYP))) {
                        String addr = this.data.get(KEY_EMAIL_DISP);
                        if (Mail.getEmailAddress(addr) == null) {
                            this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_MAILTODISPATCHER));
                        } else {
                            this.data.put(KEY_EMAIL_EMPF, addr);
                        }
                    }
                    MailTemplate mailTemplate = (MailTemplate)ServerPluginManager.getInstance().getSingleInstanceByName(MailTemplate.class, "loop-error", false);
                    String description = mailTemplate.getDescription();
                    if (description.equals(this.data.get(KEY_TYP_DESCRIPTION)) && (resourceAddress = this.data.get(KEY_EMAIL)) != null && resourceAddress.length() > 0) {
                        String dispatcherAdresses = this.data.get(KEY_EMAIL_EMPF);
                        if (dispatcherAdresses != null && dispatcherAdresses.length() > 0) {
                            this.data.put(KEY_EMAIL_EMPF, dispatcherAdresses + ";" + resourceAddress);
                        } else {
                            this.data.put(KEY_EMAIL_EMPF, resourceAddress);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            HDLogger.debug("Fehler in NewMail.loadData");
            er = e;
        }
        if (er != null) {
            throw er;
        }
        return !dropTheMail;
    }

    private void setSender() {
        String sender = this.data.get(KEY_EMAIL_SEND);
        if (sender != null && sender.length() > 0) {
            return;
        }
        EmailAccountList accounts = (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
        String kategorie = this.data.get(KEY_KATEGORIE);
        kategorie = kategorie != null ? kategorie : "";
        EmailAccount defaultAccount = null;
        for (EmailAccount emailAccount : accounts) {
            String accEm;
            String accKat = "";
            try {
                Integer categoryId = emailAccount.getCategoryId();
                accKat = CategoryManager.getInstance().findCategoryPathOrThrow(categoryId);
            }
            catch (ServerDataException e) {
                HDLogger.error(e);
            }
            if ((accEm = emailAccount.getFrom()) == null || accEm.length() <= 0) continue;
            if (kategorie.length() > 0 && kategorie.equals(accKat)) {
                if (!AutoMail.putAbsenderFrom(this.data, accEm, emailAccount.getFromName())) continue;
                return;
            }
            if (!accEm.equalsIgnoreCase((String)MAIL_FROM.get()) && (kategorie.length() <= 0 || !kategorie.startsWith(accKat + "\\"))) continue;
            defaultAccount = emailAccount;
        }
        if (defaultAccount != null && AutoMail.putAbsenderFrom(this.data, defaultAccount.getFrom(), defaultAccount.getFromName())) {
            return;
        }
        for (EmailAccount emailAccount : accounts) {
            if (!AutoMail.putAbsenderFrom(this.data, emailAccount.getFrom(), emailAccount.getFromName())) continue;
            return;
        }
        String email = (String)MAIL_FROM.get();
        if (email.length() > 0) {
            AutoMail.putAbsenderFrom(this.data, email, "HelpDesk");
        }
    }

    public static boolean putAbsenderFrom(Map<String, String> dat, String email, String displayName) {
        if (email != null && email.length() > 0) {
            dat.put(KEY_EMAIL_SEND, email);
            if (displayName == null || displayName.length() == 0) {
                dat.put(KEY_EMAIL_SEND_DISP_NAME, email);
            } else {
                dat.put(KEY_EMAIL_SEND_DISP_NAME, displayName);
            }
            return true;
        }
        return false;
    }

    private <T> void setParam(TicketVO ticket, Field<T> field, String paramName, Format formatter) throws SQLException {
        T value = ticket.getFieldOrAttributeValue(field);
        if (value == null) {
            this.data.put(paramName, "");
        } else {
            this.data.put(paramName, formatter.format(value));
        }
    }

    private <T> void setParam(TicketVO ticket, Field<T> field, String paramName, String defaultValue) {
        T val = ticket.getFieldOrAttributeValue(field);
        if (val == null) {
            this.data.put(paramName, defaultValue);
        } else {
            this.data.put(paramName, field.getFieldType().getDisplayValue(val));
        }
    }

    private <T> void setParam(TicketVO ticket, Field<T> field, String paramName) {
        this.setParam(ticket, field, paramName, false);
    }

    private <T> void setParam(TicketVO ticket, Field<T> field, String paramName, boolean rawElseDisplayValue) {
        T value = ticket.getFieldOrAttributeValue(field);
        String val = rawElseDisplayValue ? field.getFieldType().asString(value) : field.getFieldType().getDisplayValue(value);
        this.data.put(paramName, val == null ? "" : val);
    }

    private <T> void setOwnerParam(UserAccount owner, UserField<T> field, String paramName) {
        String val = field.getFieldType().getDisplayValue(owner.getValue(field));
        this.data.put(paramName, val == null ? "" : val);
    }

    private void setOwnerLocationAddress(UserAccount owner, String paramName) {
        String val = null;
        Integer location = (Integer)owner.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        if (location != null) {
            val = ((LocationVO)LocationManager.getInstance().get(location)).getAddress();
        }
        this.data.put(paramName, val == null ? "" : val);
    }

    private void setClassificationInfoParam(TicketVO ticket, String paramName) {
        ClassificationVO vo;
        int classificationID = ticket.getClassificationID();
        if (classificationID != TicketFieldClassificationId.DEFAULT_ID && (vo = (ClassificationVO)ClassificationManager.getInstance().get(classificationID)) != null) {
            this.data.put(paramName, vo.getInfo() == null ? "" : vo.getInfo());
        }
    }

    private void readDispatcherData(@Nullable GUID disID) {
        if (disID == null) {
            return;
        }
        UserAccount ua = UserManager.getInstance().getUserAccount(disID);
        if (ua != null) {
            String em;
            this.data.put(KEY_DISID, "" + HDUsersAndGroups.getUserID(ua));
            this.data.put(KEY_DISPATCHER, ua.getDisplayName());
            List logins = ua.getLoginSettings();
            for (LoginSettings login : logins) {
                if (!"system".equals(login.getLoginSource())) continue;
                this.data.put(KEY_DISPATCHERUSR, login.getLoginID());
                break;
            }
            if ((em = (String)ua.getValue((UserField)UsersAndGroups.FIELD_EMAIL)) == null) {
                this.data.put(KEY_EMAIL_DISP, "");
            } else {
                this.data.put(KEY_EMAIL_DISP, em);
            }
        }
    }

    private String getDispatcherEmails() {
        String dummy = (String)MAILTO_DISPATCHER.get();
        if (dummy != null && dummy.length() > 0) {
            return dummy;
        }
        Set<GUID> dispatcherIDs = SupporterUserConditionTokenMatcher.getDispatcherIDs();
        if (dispatcherIDs == null) {
            return "";
        }
        UserManager manager = UserManager.getInstance();
        HashSet<String> addresses = new HashSet<String>();
        StringBuilder buf = null;
        for (GUID guid : dispatcherIDs) {
            String firstEmailAddress;
            UserAccount account = manager.getUserAccount(guid);
            if (account == null || !account.isActive() || (firstEmailAddress = EmailAddressHelper.get().getFirstEmailAddress((String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL))) == null) continue;
            firstEmailAddress = firstEmailAddress.trim();
            buf = this.addAddress(firstEmailAddress, buf, addresses);
        }
        return buf == null ? "" : buf.toString();
    }

    private StringBuilder addAddress(String address, StringBuilder buf, HashSet<String> addresses) {
        if (!addresses.contains(address)) {
            addresses.add(address);
            if (buf == null) {
                buf = new StringBuilder(address);
            } else {
                buf.append(';').append(address);
            }
        }
        return buf;
    }

    private Locale getFormatingLocale(String lang) {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String country = configuration.get("vm.user.country");
        if (country == null || country.length() != 2) {
            country = Locale.getDefault().getCountry();
        }
        if ("de".equals(this.data.get(KEY_LOCALE))) {
            return new Locale("de", country);
        }
        return new Locale("en", country);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="this is definitely safe because we're only optionally adding DESC to the end")
    private String loadSubtemplateData(boolean html, Template subTemplate, Set<Integer> listOfReasWhoseTextIsUsedInMail) {
        if (subTemplate == null) {
            return "";
        }
        boolean desc = false;
        boolean lastOnly = "LastOnly".equals(this.data.get(KEY_SUBTEMPLATESORTORDER));
        if ("LastTop".equals(this.data.get(KEY_SUBTEMPLATESORTORDER)) || lastOnly) {
            desc = true;
        }
        ArrayList<String[]> templData = new ArrayList<String[]>();
        try {
            List<ReaStepVO> reaStepsForTicket;
            int ticketId = Integer.parseInt(this.aufID);
            TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
            if (ticket.getOwnerID() != null) {
                try (UserAccountScope ownerScope = UserAccountScope.create((GUID)ticket.getOwnerID());){
                    reaStepsForTicket = TicketManager.getReader().getReaStepsForTicket(ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
                }
            } else {
                reaStepsForTicket = TicketManager.getReaderForSystem().getReaStepsForTicket(ticketId);
            }
            if (!desc) {
                Collections.reverse(reaStepsForTicket);
            }
            Locale loc = this.getFormatingLocale(this.data.get(KEY_LOCALE));
            SimpleDateFormat dateFormatter = new SimpleDateFormat(this.datepattern);
            DateFormat timeFormatter = DateFormat.getTimeInstance(3, loc);
            NumberFormat numFormatter = NumberFormat.getCurrencyInstance(loc);
            for (ReaStepVO step : reaStepsForTicket) {
                String[] singleData = new String[11];
                boolean stepTextIsHtml = false;
                boolean foundText = step.hasText();
                if (foundText) {
                    ReaStepTextVO reaStepText = TicketManager.getReaderForSystem().getReaStepText(step.getID());
                    stepTextIsHtml = reaStepText.hasHtmlContent();
                    singleData[3] = reaStepText.getText();
                }
                singleData[0] = dateFormatter.format(step.getStartDate());
                singleData[1] = timeFormatter.format(step.getStartDate());
                singleData[2] = timeFormatter.format(step.getEndDate());
                int aktID = step.getActionID();
                if (singleData[3] == null) {
                    singleData[3] = "";
                } else if (stepTextIsHtml && html) {
                    singleData[3] = this.removeHtmlTags(singleData[3]);
                }
                if (stepTextIsHtml) {
                    foundText = HtmlConverter.html2text((String)singleData[3]).trim().length() > 0 || singleData[3].contains("src=\"Attachments/ticket/");
                } else {
                    boolean bl = foundText = singleData[3].trim().length() > 0;
                }
                if (html != stepTextIsHtml && singleData[3].length() > 5) {
                    singleData[3] = html ? HtmlConverter.text2html((String)singleData[3], null) : HtmlConverter.html2text((String)singleData[3]);
                }
                singleData[4] = numFormatter.format(step.getHourlyRate());
                singleData[5] = step.getDisplayName();
                singleData[6] = ((ActionVO)ActionManager.getInstance().get(aktID)).getDisplayValue();
                GUID userId = step.getUserID();
                UserAccount ua = UserManager.getInstance().getUserAccount(userId);
                if (ua != null) {
                    List logins = ua.getLoginSettings();
                    for (LoginSettings login : logins) {
                        if (!"system".equals(login.getLoginSource())) continue;
                        singleData[7] = login.getLoginID();
                        break;
                    }
                }
                if (singleData[7] == null) {
                    singleData[7] = singleData[5];
                }
                singleData[8] = step.getEmailSenderAddress();
                singleData[9] = step.getEmailReceiverAddresses();
                singleData[10] = step.getEmailCCAdresses();
                if (subTemplate.containsReaStepTextPlaceholder()) {
                    listOfReasWhoseTextIsUsedInMail.add(step.getID());
                }
                templData.add(singleData);
                if (!lastOnly) continue;
                if (!foundText && aktID != -2) {
                    templData.clear();
                    continue;
                }
                break;
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < templData.size(); ++n) {
            String[] singleData = (String[])templData.get(n);
            buf.append(subTemplate.texte[0]);
            for (int m = 0; m < subTemplate.texte.length - 1; ++m) {
                buf.append(this.getString(singleData, subTemplate.vars[m], html));
                buf.append(subTemplate.texte[m + 1]);
            }
        }
        return buf.toString();
    }

    private String getString(String[] data, String name, boolean asHtml) {
        String str;
        boolean addressParam = false;
        if (name.startsWith("mailto:")) {
            name = name.substring(7);
            addressParam = true;
        }
        if ((str = name.equals(KEY_AKTION) ? data[6] : (name.equals(KEY_WANN) ? data[0] : (name.equals(KEY_VON) ? data[1] : (name.equals(KEY_BIS) ? data[2] : (name.equals(KEY_WAS) ? data[3] : (name.equals(KEY_WER) ? data[5] : (name.equals(KEY_STUNDENSATZ) ? data[4] : (name.equals(KEY_USERNAME) ? data[7] : (name.equals(KEY_ABSENDER) ? data[8] : (name.equals(KEY_EMPFAENGER) ? data[9] : (name.equals(KEY_CC) ? data[10] : EmailReader_HDProcessing.EMAIL_MESSAGES.getMsg("automail.unknownplaceholder", new Object[0])))))))))))) == null) {
            return " ";
        }
        if (addressParam && str.length() > 9) {
            if (asHtml) {
                return "<a href=\"mailto:" + str + "\">" + str + "</a>";
            }
            return "[mailto:" + str + "]";
        }
        return str;
    }

    private String[] zusammensetzen(Template template) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < template.texte.length - 1; ++i) {
            buf.append(template.texte[i]).append(this.getPlatzhalter(template.vars[i], template.isHtml));
        }
        buf.append(template.texte[template.texte.length - 1]);
        String[] result = new String[2];
        if (template.isHtml) {
            block1: for (i = 0; i < buf.length(); ++i) {
                if (buf.charAt(i) != '<' || (buf.charAt(i + 1) | 0x20) != 116 || (buf.charAt(i + 2) | 0x20) != 105 || (buf.charAt(i + 3) | 0x20) != 116 || (buf.charAt(i + 4) | 0x20) != 108 || (buf.charAt(i + 5) | 0x20) != 101 || buf.charAt(i + 6) != '>') continue;
                for (int n = i; n < buf.length(); ++n) {
                    if (buf.charAt(n) != '<' || buf.charAt(n + 1) != '/' || (buf.charAt(n + 2) | 0x20) != 116 || (buf.charAt(n + 3) | 0x20) != 105 || (buf.charAt(n + 4) | 0x20) != 116 || (buf.charAt(n + 5) | 0x20) != 108 || (buf.charAt(n + 6) | 0x20) != 101 || buf.charAt(n + 7) != '>') continue;
                    char[] emailBetreff = new char[n - i - 7];
                    buf.getChars(i + 7, n, emailBetreff, 0);
                    result[0] = new String(emailBetreff);
                    break block1;
                }
                break;
            }
            result[1] = buf.toString();
        } else {
            for (i = 0; i < buf.length(); ++i) {
                if (buf.charAt(i) != '\n') continue;
                char[] emalibetreff = new char[i];
                buf.getChars(0, i, emalibetreff, 0);
                result[0] = new String(emalibetreff);
                if (result[0].indexOf(13) > -1) {
                    result[0] = result[0].replace('\r', ' ').trim();
                }
                char[] content = new char[buf.length() - (i + 1)];
                buf.getChars(i + 1, buf.length(), content, 0);
                result[1] = new String(content);
                break;
            }
        }
        String betreff = this.data.get(KEY_BETREFF_MANUAL);
        if (betreff != null) {
            result[0] = betreff;
        }
        return result;
    }

    private boolean compareChars(boolean caseInSensitiv, char tag, char start, char end) {
        if (tag == start && tag == end) {
            return true;
        }
        if (caseInSensitiv) {
            if (start < '[') {
                start = (char)(start + 32);
            }
            if (end < '[') {
                end = (char)(end + 32);
            }
            if (tag == start && tag == end) {
                return true;
            }
        }
        return false;
    }

    private String removeTag(String in, String tag) {
        int startOffset;
        int endOffset = 0;
        int length = in.length();
        int tagLen = tag.length();
        for (startOffset = 0; startOffset < length && in.charAt(startOffset) < '!'; ++startOffset) {
        }
        while (endOffset < length && in.charAt(length - 1 - endOffset) < '!') {
            ++endOffset;
        }
        if (length - startOffset - startOffset > tagLen * 2 + 5 && this.compareChars(false, '<', in.charAt(0 + startOffset), in.charAt(length - endOffset - tagLen - 3)) && this.compareChars(false, '>', in.charAt(tagLen + startOffset + 1), in.charAt(length - endOffset - 1))) {
            for (int i = 0; i < tag.length(); ++i) {
                if (this.compareChars(true, tag.charAt(i), in.charAt(i + startOffset + 1), in.charAt(length - endOffset - tagLen - 1 + i))) continue;
                return in;
            }
            int cutStart = tagLen + startOffset + 2;
            int cutEnd = length - tagLen - endOffset - 3;
            return in.substring(cutStart, cutEnd);
        }
        return in;
    }

    private String removeStartPart(String in, String startTag, String partEndTag) {
        int index;
        if (in.startsWith(startTag) && (index = in.indexOf(partEndTag)) > -1) {
            return in.substring(index + partEndTag.length());
        }
        startTag = startTag.toUpperCase();
        partEndTag = partEndTag.toUpperCase();
        if (in.startsWith(startTag) && (index = in.indexOf(partEndTag)) > -1) {
            int cut;
            for (cut = index + partEndTag.length(); cut < in.length() && in.charAt(cut) < '!'; ++cut) {
            }
            return in.substring(cut);
        }
        return in;
    }

    private String removeHtmlTags(String in) {
        in = HtmlConverter.html2inlinedHtml((String)in, (boolean)false, (boolean)true, null);
        in = this.removeTag(in, "html");
        in = this.removeStartPart(in, "<head>", "</head>");
        in = this.removeTag(in, "body");
        return in;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private String getPlatzhalter(String name, boolean html) {
        String str = this.data.get(name);
        if (str == null) {
            if (name.startsWith("mailto:")) {
                str = this.data.get(name = name.substring(7));
                if (str == null || str.length() < 9) {
                    return "";
                }
                if (html) {
                    return "<a href=\"mailto:" + str + "\">" + str + "</a>";
                }
                return "[mailto:" + str + "]";
            }
            try (UserAccountScope s = UserAccountScope.createPrivileged();){
                @Nonnull List providers = DynamicExtensionManager.getInstance().get(AutoTextPlaceholderProvider.class);
                for (AutoTextPlaceholderProvider p : providers) {
                    String replacementThroughPlugin;
                    TicketVO ticket;
                    if (this.aufID.length() <= 0 || (ticket = TicketManager.getReaderForSystem().getTicket(Integer.parseInt(this.aufID))) == null || (replacementThroughPlugin = p.getCustomPlaceholderValue(name, ticket, null, UserManager.getInstance().getCurrentUserAccount())) == null) continue;
                    String string = replacementThroughPlugin;
                    return string;
                }
            }
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            String value = configuration.get(name);
            return value != null ? value : "";
        }
        if (name.equals(KEY_AUFTRAG)) {
            boolean htmlAuftrag = "true".equals(this.data.get(KEY_ISHTML));
            if (htmlAuftrag != html) {
                str = html ? HtmlConverter.text2html((String)str, null) : HtmlConverter.html2text((String)str);
            } else if (html) {
                str = HtmlConverter.html2inlinedHtml((String)str, (boolean)false, (boolean)true, null);
            }
        } else if (html && !name.startsWith(KEY_SUBTEMPLATE)) {
            if (SIMPLE_TEXT_FIELDS.contains(name)) {
                str = HtmlConverter.text2html((String)str, null);
            } else {
                int index = str.indexOf(10);
                if (index > -1) {
                    str = str.replace("\n", "<BR>");
                }
            }
        }
        return str;
    }

    @Override
    public void run() {
        InternetAddress[] to = null;
        InternetAddress[] cc = null;
        InternetAddress[] bcc = null;
        InternetAddress from = null;
        String templateName = null;
        try {
            this.aufID = this.data.get(KEY_AUFID);
            if (this.aufID == null) {
                this.aufID = "";
            }
            int idInt = -1;
            int bunIdInt = -1;
            if (this.aufID.length() > 0) {
                this.data.put(KEY_AUFIDXXX, Tickets.getTicketIDForEmailSubject(Integer.parseInt(this.aufID)));
                if (this.data.get("ready") == null && !this.loadData()) {
                    return;
                }
                idInt = Integer.parseInt(this.aufID);
                bunIdInt = this.bunID != null && this.bunID.length() > 0 ? Integer.parseInt(this.bunID) : idInt;
                String dispatched = this.data.get(KEY_ISDISPATCHED);
                if (dispatched != null) {
                    boolean sendToDispatcher = 21 == this.myTyp;
                    boolean sendToResource = 5 == this.myTyp;
                    boolean isDispatched = Boolean.valueOf(dispatched);
                    if (sendToDispatcher && isDispatched) {
                        return;
                    }
                    if (sendToResource && !isDispatched) {
                        return;
                    }
                }
            }
            this.setSender();
            Trigger tr = TriggerHandler.getTrigger(2);
            if (tr != null) {
                tr.checkData(this.data, false);
            }
            templateName = this.data.get(KEY_TEMPLATE_NAME);
            String templateSet = this.data.get(KEY_TEMPLATE_SET);
            String templateLanguage = this.data.get(KEY_TEMPLATE_LANGUAGE);
            String empf = this.data.get(KEY_EMAIL_EMPF);
            String abs = this.data.get(KEY_EMAIL_SEND);
            if (templateName != null && templateName.length() > 0 && empf != null && empf.length() > 0 && abs != null && abs.length() > 0) {
                String[] result;
                Template thisTemplate = this.getTemplate(templateName, templateSet, templateLanguage);
                if (thisTemplate == null) {
                    return;
                }
                from = this.getfrom(abs, this.data.get(KEY_EMAIL_SEND_DISP_NAME));
                if (from == null) {
                    return;
                }
                to = this.getrecipients(empf, this.data.get(KEY_PRODUCER), bunIdInt, this.data.get(KEY_TYP_DESCRIPTION));
                if (to == null) {
                    return;
                }
                cc = this.getrecipients(this.data.get(KEY_EMAIL_EMPF_CC), this.data.get(KEY_PRODUCER), bunIdInt, this.data.get(KEY_TYP_DESCRIPTION));
                bcc = this.getrecipients(this.data.get(KEY_EMAIL_EMPF_BCC), this.data.get(KEY_PRODUCER), bunIdInt, this.data.get(KEY_TYP_DESCRIPTION));
                ArrayList<MailAttachment> toAttach = new ArrayList<MailAttachment>();
                if (thisTemplate.isHtml && thisTemplate.logo && this.data.get(KEY_LOGO_FILE_KEY) != null) {
                    this.addLogoFile(this.data, toAttach);
                }
                HashSet<Integer> listOfReasWhoseTextIsUsedInMail = new HashSet<Integer>();
                if (thisTemplate.containsAnfrageTextPlaceholder()) {
                    listOfReasWhoseTextIsUsedInMail.add(this.anfReaId);
                    listOfReasWhoseTextIsUsedInMail.add(-1);
                }
                if (thisTemplate.containsSubtemplates()) {
                    String subTempName;
                    Object paramName = KEY_SUBTEMPLATE;
                    if (this.data.get(KEY_SUBTEMPLATEFILE) != null) {
                        subTempName = this.data.get(KEY_SUBTEMPLATEFILE).toString();
                    } else if (thisTemplate.subtemplateLast) {
                        subTempName = thisTemplate.isHtml ? "subtemplatelaststep.html" : "subtemplatelaststep.txt";
                        paramName = KEY_SUBTEMPLATELASTSTEP;
                        this.data.put(KEY_SUBTEMPLATESORTORDER, "LastOnly");
                    } else {
                        subTempName = thisTemplate.isHtml ? "subtemplate.html" : "subtemplate.txt";
                    }
                    this.data.put((String)paramName, this.loadSubtemplateData(thisTemplate.isHtml, this.getTemplate(subTempName, this.data.get(KEY_TEMPLATE_SET), this.data.get(KEY_TEMPLATE_LANGUAGE)), listOfReasWhoseTextIsUsedInMail));
                }
                if ((result = this.zusammensetzen(thisTemplate))[0] == null && result[1] == null) {
                    return;
                }
                if (result[0] == null) {
                    result[0] = "";
                }
                if (result[1] == null) {
                    result[1] = "";
                }
                this.mailMetaData.setTicketId(idInt);
                this.mailMetaData.setSendAttachments("true".equals(this.data.get(KEY_SENDATTACHMENTS)));
                this.mailMetaData.setSendMailAsHtml("html".equals(MAIL_FORMAT.get()));
                this.mailMetaData.setListOfReaIDsWhoseTextIsUsedInMail(listOfReasWhoseTextIsUsedInMail);
                for (SendAutoMailExtension extension : ServerPluginManager.getInstance().get(SendAutoMailExtension.class)) {
                    result[1] = extension.extendEmail(result[1], toAttach, this.mailMetaData);
                }
                final boolean html = thisTemplate.isHtml;
                final MailDataSource[] allAttachments = toAttach.toArray(new MailDataSource[0]);
                final InternetAddress[] toAddresses = to;
                final InternetAddress[] ccAddresses = cc;
                final InternetAddress[] bccAddresses = bcc;
                final InternetAddress fromAddress = from;
                HelpDeskBaseEmail email = new HelpDeskBaseEmail(){

                    @Override
                    public String getSubject() throws MessagingException {
                        if (html) {
                            return HtmlConverter.html2text((String)result[0]);
                        }
                        return result[0];
                    }

                    @Override
                    public InternetAddress[] getTo() throws MessagingException {
                        return toAddresses;
                    }

                    protected InternetAddress @Nullable [] getCc() throws MessagingException {
                        return ccAddresses;
                    }

                    protected InternetAddress @Nullable [] getBcc() throws MessagingException {
                        return bccAddresses;
                    }

                    @Override
                    public String getMessage() throws MessagingException {
                        return result[1];
                    }

                    @Nonnull
                    protected Logger getLogger() {
                        return HDLogger.LOG;
                    }

                    protected String getMessageMime() throws MessagingException {
                        return html ? "HTML" : "plain";
                    }

                    protected MailDataSource @Nullable [] getFiles() throws MessagingException {
                        return allAttachments;
                    }

                    public void send() throws MessagingException {
                        super.send(fromAddress);
                    }

                    @Override
                    public Properties getHeaders() {
                        String foreignKeyColumn = (String)FOREIGN_KEY_COLUMN.get();
                        String forkKey = foreignKeyColumn != null && foreignKeyColumn.length() > 0 ? AutoMail.this.data.get(AliasMapper.getReverseMappingForCustomFields(foreignKeyColumn)) : AutoMail.this.data.get("foreignkey");
                        String ticketIDForEmailSubject = AutoMail.this.aufID != null && AutoMail.this.aufID.length() > 0 ? Tickets.getTicketIDForEmailSubject(Integer.parseInt(AutoMail.this.aufID)) : "";
                        Properties headers = Mail.getHeaders(ticketIDForEmailSubject, forkKey, AutoMail.this.data.get("In-Reply-To"), AutoMail.this.data.get("References"));
                        headers.setProperty("Auto-Submitted", switch (AutoMail.this.myTyp) {
                            case 1, 14, 16, 22 -> "auto-replied";
                            default -> "auto-generated";
                        });
                        return headers;
                    }
                };
                email.send();
                if (this.aufID != null && this.aufID.length() > 0) {
                    Mail.addRealisierung(Integer.parseInt(this.aufID), null, -14, from.getAddress(), Mail.getAddressString((Address[])to), Mail.getAddressString((Address[])cc), Mail.getAddressString((Address[])bcc), "Template: " + templateName);
                }
            }
        }
        catch (Exception trErr) {
            HDLogger.error(new HelpDeskServerException("Automail " + templateName + " failed for ticket " + this.aufID + "!", (Throwable)trErr, HelpDeskErrorCodes.MAIL_CREATION_ERROR));
            try {
                if (this.aufID != null && this.aufID.length() > 0 && from != null) {
                    String errorMsg = "Error: " + trErr.getMessage();
                    if (errorMsg.length() > 255) {
                        HDLogger.error("shortening email description from -> " + errorMsg);
                        errorMsg = errorMsg.substring(0, 252) + "...";
                    }
                    Mail.addRealisierung(Integer.parseInt(this.aufID), null, -14, from.getAddress(), Mail.getAddressString(to), Mail.getAddressString(cc), Mail.getAddressString(bcc), errorMsg);
                }
            }
            catch (Exception other) {
                HDLogger.error(new HelpDeskServerException("Could not write mail failure to database!", (Throwable)other, HelpDeskErrorCodes.SQL_EXECUTION_ERROR));
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This add the logo to the internal data")
    private void addLogoFile(Map<String, String> data, ArrayList<MailAttachment> toAttach) {
        Path filePath;
        String logoPath = data.get(KEY_LOGO_FILE_KEY);
        if (logoPath == null || logoPath.trim().isEmpty()) {
            return;
        }
        if (logoPath.trim().startsWith("http:") || logoPath.trim().startsWith("https:")) {
            try {
                URL url = new URL(logoPath);
                data.put(KEY_LOGO_FILE_KEY, "<img src=\"" + url.toExternalForm() + "\">");
                return;
            }
            catch (MalformedURLException e) {
                return;
            }
        }
        try {
            filePath = Paths.get(logoPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            return;
        }
        if (filePath.isAbsolute()) {
            File file = filePath.toFile();
            if (file.exists() && !file.isDirectory()) {
                String result = MailUtilities.addToList(file.getAbsolutePath(), file.getName(), true, toAttach);
                data.put(KEY_LOGO_FILE_KEY, "<img src=\"cid:" + result + "\">");
            }
        } else {
            PersistenceEntry file = this.getLogoFileFromPersistence(logoPath);
            if (file != null) {
                String result = MailUtilities.addToList(file, file.getName(), true, toAttach);
                data.put(KEY_LOGO_FILE_KEY, "<img src=\"cid:" + result + "\">");
            }
        }
    }

    private PersistenceEntry getLogoFileFromPersistence(@Nonnull String filePath) {
        PersistenceEntry file = AppDataLocation.getClientImageDirectory().resolve(filePath);
        if (file.exists()) {
            return file;
        }
        file = Persistence.getInstance().resolve(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private InternetAddress isAddressValid(String addr, String producer, HashSet<String> filter, int ticketId, String mailType) {
        InternetAddress address = Mail.getEmailAddress(addr);
        if (address != null) {
            BlackListHandler.BlackListEntry entry = BlackListHandler.checkForBlackListEntry(addr, ticketId);
            if (entry != null) {
                if (entry.isSizeProblem()) {
                    this.mailMetaData.setBlackListedBecauseofSize(true);
                } else {
                    if (entry.isSuppressAutomailing()) {
                        HDLogger.info("Black list: #" + ticketId + " " + entry.getBlackListInformation() + " " + mailType);
                        return null;
                    }
                    HDLogger.info("Black list: " + addr + " " + entry.getBlackListInformation() + " " + mailType);
                    return null;
                }
            }
            int addpos = addr.indexOf(64);
            String vorn = addr.substring(0, addpos).toLowerCase();
            String hinten = addr.substring(addpos + 1).toLowerCase();
            if (filter.contains(vorn) && filter.contains(hinten)) {
                HDLogger.info("No automail to internal account: " + addr);
                return null;
            }
            if (producer != null && producer.equalsIgnoreCase(addr) && !((Boolean)SEND_TO_ORIGINATOR.get()).booleanValue()) {
                HDLogger.info("No Auto-Mail (" + mailType + ") to originator: " + producer);
                return null;
            }
        }
        return address;
    }

    private InternetAddress[] getrecipients(String addresses, String producer, int ticketId, String mailType) {
        if (addresses == null || addresses.length() < 7) {
            return null;
        }
        HashSet<String> hm = Mail.generateMailFilter();
        InternetAddress[] allMails = null;
        if (addresses.indexOf(44) > -1) {
            addresses = addresses.replace(',', ';');
        }
        if (addresses.indexOf(10) > -1) {
            addresses = addresses.replace('\n', ';');
        }
        if (addresses.indexOf(13) > -1) {
            addresses = addresses.replace('\r', ';');
        }
        if (addresses.indexOf(59) > -1) {
            Vector<InternetAddress> vec = null;
            StringTokenizer eimailTokens = new StringTokenizer(addresses, ";");
            while (eimailTokens.hasMoreTokens()) {
                String test = eimailTokens.nextToken().trim();
                InternetAddress address = this.isAddressValid(test, producer, hm, ticketId, mailType);
                if (address == null) continue;
                if (vec == null) {
                    vec = new Vector<InternetAddress>();
                }
                vec.addElement(address);
            }
            if (vec != null) {
                allMails = new InternetAddress[vec.size()];
                for (int i = 0; i < vec.size(); ++i) {
                    allMails[i] = (InternetAddress)vec.elementAt(i);
                }
            }
        } else {
            InternetAddress address = this.isAddressValid(addresses, producer, hm, ticketId, mailType);
            if (address != null) {
                allMails = new InternetAddress[]{address};
            } else {
                return null;
            }
        }
        return allMails;
    }

    private InternetAddress getfrom(String em, String dispName) {
        InternetAddress address = Mail.getEmailAddress(em);
        if (address != null && dispName != null && dispName.trim().length() > 0) {
            try {
                address.setPersonal(dispName, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                HDLogger.error(ex);
            }
        }
        return address;
    }

    public static String[] availableTemplateNames() {
        String templateName = (String)MailTemplatesManager.AUTOMAIL_TEMPLATE_SET.get();
        HashSet<String> currentTemplates = new HashSet<String>(MailTemplatesManager.listTemplatesNames(templateName, null));
        if (!"default".equals(templateName)) {
            currentTemplates.addAll(MailTemplatesManager.listTemplatesNames("default", null));
        }
        return currentTemplates.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList()).toArray(new String[0]);
    }

    private Template getTemplate(String templateFileName, String set, String language) {
        byte[] stueck;
        int i;
        byte[] inputtext = new byte[1];
        int length = 0;
        int anfang = 0;
        Vector<byte[]> emailText = new Vector<byte[]>();
        Vector<String> platzhalter = new Vector<String>();
        if (set == null) {
            set = (String)MailTemplatesManager.AUTOMAIL_TEMPLATE_SET.get();
        }
        if (language == null) {
            language = "default";
        }
        String mailTemplateName = templateFileName;
        String mailTemplateExtension = "";
        int extensionIndex = mailTemplateName.lastIndexOf(46);
        if (extensionIndex > 0) {
            mailTemplateExtension = mailTemplateName.substring(extensionIndex + 1);
            mailTemplateName = mailTemplateName.substring(0, extensionIndex);
        }
        HDLogger.debug("Loading mail template " + mailTemplateName + " (Format: " + mailTemplateExtension + " Set: " + set + ", Language: " + language + ")");
        MailTemplateData template = this.resolveTemplate(mailTemplateName, set, language);
        if (mailTemplateExtension.equalsIgnoreCase("txt")) {
            String textData = template.getTextData();
            if (textData == null) {
                HDLogger.error(new FileNotFoundException("No mail template found for key '" + mailTemplateName + "' and format '" + mailTemplateExtension + "' in set " + set + " and language " + language));
                return null;
            }
            inputtext = textData.getBytes(StandardCharsets.UTF_8);
        } else {
            String htmlData = template.getHtmlData();
            if (htmlData == null) {
                HDLogger.error(new FileNotFoundException("No mail template found for key '" + mailTemplateName + "' and format '" + mailTemplateExtension + "' in set " + set + " and language " + language));
                return null;
            }
            ServerValuesConnector svc = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
            try {
                Font defaultFont = svc.getDefaultFont();
                if (defaultFont != null) {
                    htmlData = htmlData.replace("<body>", "<body style=\"font-family:'" + defaultFont.getFamily() + "'; font-size: " + defaultFont.getSize() + "pt;\">");
                }
            }
            catch (ServerDataException serverDataException) {
                // empty catch block
            }
            inputtext = htmlData.getBytes(StandardCharsets.UTF_8);
        }
        length = inputtext.length;
        Template theTemplate = new Template();
        theTemplate.isHtml = !mailTemplateExtension.equalsIgnoreCase("txt");
        int start = 0;
        if (length > 3 && inputtext[0] == -17 && inputtext[1] == -69 && inputtext[2] == -65) {
            start = 3;
            anfang = 3;
        }
        block6: for (i = start; i < length; ++i) {
            if (inputtext[i] != 123) continue;
            stueck = new byte[i - anfang];
            System.arraycopy(inputtext, anfang, stueck, 0, i - anfang);
            emailText.addElement(stueck);
            anfang = i + 1;
            for (int n = i; n < length; ++n) {
                String pStueck;
                if (inputtext[n] != 125) continue;
                try {
                    pStueck = new String(inputtext, anfang, n - anfang, "UTF-8").toLowerCase();
                }
                catch (Exception ex) {
                    HDLogger.error(ex);
                    pStueck = "Encoding Exception";
                }
                anfang = n + 1;
                platzhalter.addElement(pStueck);
                i = n + 1;
                continue block6;
            }
        }
        stueck = new byte[length - anfang];
        System.arraycopy(inputtext, anfang, stueck, 0, length - anfang);
        emailText.addElement(stueck);
        theTemplate.subtemplate = platzhalter.indexOf(KEY_SUBTEMPLATE) > -1;
        theTemplate.subtemplateLast = platzhalter.indexOf(KEY_SUBTEMPLATELASTSTEP) > -1;
        theTemplate.logo = platzhalter.indexOf(KEY_LOGO_FILE_KEY) > -1;
        theTemplate.texte = new String[emailText.size()];
        try {
            for (i = 0; i < emailText.size(); ++i) {
                theTemplate.texte[i] = new String((byte[])emailText.elementAt(i), "UTF-8");
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        theTemplate.vars = new String[platzhalter.size()];
        for (int i2 = 0; i2 < platzhalter.size(); ++i2) {
            theTemplate.vars[i2] = ((String)platzhalter.elementAt(i2)).toString();
        }
        return theTemplate;
    }

    protected MailTemplateData resolveTemplate(String mailTemplateName, String set, String language) {
        return MailTemplatesManager.resolveTemplate(mailTemplateName, set, language);
    }

    private class Template {
        private boolean isHtml;
        private boolean logo;
        private boolean subtemplate;
        private boolean subtemplateLast;
        private String[] texte;
        private String[] vars;

        private Template() {
        }

        private boolean containsSubtemplates() {
            return this.subtemplate || this.subtemplateLast;
        }

        private boolean containsAnfrageTextPlaceholder() {
            for (String v : this.vars) {
                if (!v.equals(AutoMail.KEY_AUFTRAG)) continue;
                return true;
            }
            return false;
        }

        private boolean containsReaStepTextPlaceholder() {
            for (String v : this.vars) {
                if (!v.equals(AutoMail.KEY_WAS)) continue;
                return true;
            }
            return false;
        }
    }
}

