/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.field.SelectOption;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithUser;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.JoinFieldSortedIteratorDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionOwnerId
extends AbstractTicketFieldDefinitionWithUser
implements ConfigurableMandatoryField<GUID> {
    public TicketFieldDefinitionOwnerId(int prio) {
        super(Tickets.FIELD_OWNER_GUID, prio);
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(this){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                boolean available = super.isAvailable(tickets);
                return available && tickets != null && !tickets.isEmpty() && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, @Nonnull Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                    String valueString = selectOption.getValue();
                    if (!StringFunctions.isEmpty((String)valueString)) {
                        GUID ticketOwnerID = GUID.valueOf((String)valueString);
                        if (ticketOwnerID != null) {
                            ticketData.put(Tickets.FIELD_OWNER_GUID, ticketOwnerID);
                        }
                    } else {
                        ticketData.put(Tickets.FIELD_OWNER_GUID, null);
                    }
                }
            }

            @Override
            public void updateCurrentValue(@Nullable TicketVO ticket, @Nullable GUID ownerId, @Nonnull Map<String, String> values) {
                UserAccount userAccount;
                GUID ticketOwnerID = null;
                if (ticket != null) {
                    ticketOwnerID = ticket.getOwnerID();
                }
                SelectOption option = new SelectOption(null, "");
                if (ticketOwnerID != null && (userAccount = UserManager.getInstance().getUserAccount(ticketOwnerID)) != null) {
                    option = new SelectOption(ticketOwnerID.toString(), userAccount.getDisplayName(), ticketOwnerID.toString());
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionOwnerId.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return "ticketowner";
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionOwnerId.this.getDisplayName();
            }

            @Override
            public String convertStringValueToRequiredValueFormat(String value) {
                return new Json().toJson((Object)new SelectOption(value, value));
            }
        };
    }

    @Override
    public FieldSortedIteratorDefinition getSortedDefinition() {
        return new JoinFieldSortedIteratorDefinition("ownerid", (IndexSearchEngine<GUID>)UserManager.getInstance().getSearchEngine(), "useraccountdisplayname");
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return TicketFieldSettings.TYPE_OTHER;
    }

    @Override
    public TicketField<GUID> getField() {
        return Tickets.FIELD_OWNER_GUID;
    }
}

