/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings.fields;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.search.tokenizers.MixedTextTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomTicketField<T>
extends TicketField<T> {
    public CustomTicketField(@Nonnull String key, @Nonnull GenericFieldSetting setting, @Nullable Integer searchPrio) {
        super(key, null, CustomTicketField.fieldTypeFactory(setting, searchPrio), setting.getType().getValueType());
    }

    private static FieldTypeFactory fieldTypeFactory(GenericFieldSetting setting, @Nullable Integer searchPrio) {
        FieldTypeFactory custom = FieldTypeFactory.custom((Object)setting);
        if (searchPrio != null) {
            custom.withSearchPrio(searchPrio.intValue());
        }
        if (setting.getType() == FieldSettingsType.TYPE_TEXT) {
            custom.withTokenizer((SearchTokenizer)new MixedTextTokenizer());
        }
        return custom;
    }

    @Nonnull
    public FieldType<T> createFieldType(Object setting) {
        final GenericFieldSetting settingX = (GenericFieldSetting)setting;
        if (settingX.getType() == FieldSettingsType.TYPE_SELECT) {
            return new FieldTypeSelect_String(this.getKey(), () -> this.getLabel(), includeDeleted -> settingX.getSelectOptions(null));
        }
        if (settingX.getType() == FieldSettingsType.TYPE_DATE) {
            return new FieldTypeDate(this.getKey(), () -> this.getLabel(), false){

                public boolean withTimezone() {
                    return !"true".equalsIgnoreCase(settingX.getSpecificProperty("fieldSettingsIgnoreTimezone"));
                }
            };
        }
        if (settingX.getType() == FieldSettingsType.TYPE_DATE_TIME) {
            return new FieldTypeDate(this.getKey(), () -> this.getLabel(), true){

                public boolean withTimezone() {
                    return !"true".equalsIgnoreCase(settingX.getSpecificProperty("fieldSettingsIgnoreTimezone"));
                }
            };
        }
        FieldType fieldType = settingX.getType().toFieldType(settingX, () -> this.getLabel());
        return fieldType;
    }

    @Override
    @Nonnull
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(@Nonnull TicketVOSingle master, @Nonnull TicketVOSingle slave) {
        return slave;
    }

    @Override
    public void validateIsValidValue(T t) {
        Integer value;
        super.validateIsValidValue(t);
        if (this.getFieldType() instanceof FieldTypeRating && (value = (Integer)t) != null) {
            BasicFieldValidation.throwIfNegative((int)value);
            BasicFieldValidation.throwIfExceedsLimit((double)value.intValue(), (double)10.0);
        }
    }
}

