/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ai.rewrite;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ai.CancelableExecutor;
import com.inet.http.ClientMessageException;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ai.api.AIProviderManager;
import com.inet.plugin.ai.api.AIRequest;
import com.inet.plugin.ai.api.AIResponse;
import com.inet.plugin.ai.api.Communicator;
import com.inet.plugin.ai.api.ResponseHandler;
import java.util.Map;
import javax.annotation.Nonnull;

public class RewriteExecuter
implements CancelableExecutor {
    private final String text;
    private final AIProviderManager manager;
    private String tone;
    private final String clientId;
    private static final String AI_CHUNK_EVENT = "helpdesk.ai.chunk";
    private AIResponse response;
    private boolean canceled;
    private static final ConfigValue<String> EXTRA_REWRITE_INSTRUCTIONS = new ConfigValue(HDConfigKeys.AI_REWRITE_EXTRA_INSTRUCTIONS);
    Map<String, String> toneDescriptions = Map.ofEntries(Map.entry("improve", "Enhance the clarity, flow, and quality of the text without changing its meaning or tone."), Map.entry("formal", "Rewrite in a professional, polished tone suitable for business contexts. May use longer, more complete sentences."), Map.entry("neutral", "Rewrite the text in a plain, objective tone without emotional or stylistic expression."), Map.entry("casual", "Rewrite the text in a relaxed, friendly, and conversational tone using everyday language."), Map.entry("technical", "Rewrite the text in a precise and factual tone using technical or domain-specific terminology."), Map.entry("shorten", "Reduce length significantly while preserving core message. Prioritize brevity over the general length guidance."), Map.entry("stepbystep", "Convert to numbered steps. Only applicable to procedural or instructional content."), Map.entry("spelling", "Correct spelling mistakes in the text without altering its tone or structure."), Map.entry("grammar", "Correct grammar and punctuation in the text while preserving the original tone and wording."));

    public RewriteExecuter(String text, String tone, String clientId, AIProviderManager manager) {
        this.text = text;
        this.tone = tone;
        this.clientId = clientId;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstantRewrite() throws ClientMessageException {
        try {
            if (this.clientId != null) {
                CancelableExecutor.addExecuter(this.clientId, this);
            }
            RewriteExecuter rewriteExecuter = this;
            synchronized (rewriteExecuter) {
                block15: {
                    this.runRequest();
                    this.wait(60000L);
                    if (this.response == null) break block15;
                    if (this.response.getErrorText() != null) {
                        throw new ClientMessageException(this.response.getErrorText());
                    }
                    String string = this.response.getResponseText();
                    return string;
                }
            }
        }
        catch (ClientMessageException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)th), th);
        }
        finally {
            if (this.clientId != null) {
                CancelableExecutor.removeExecuter(this.clientId);
            }
        }
        if (this.canceled) {
            // empty if block
        }
        throw new ClientMessageException("timeout");
    }

    public void runRequest() {
        Communicator communicator;
        Boolean useDefault = (Boolean)HDConfigKeys.AI_REWRITE_USEDEFAULTPROVIDER.getCurrent();
        if (useDefault == null || useDefault.booleanValue()) {
            communicator = this.manager.getDefaultCommunicator();
        } else {
            String providerName = (String)HDConfigKeys.AI_REWRITE_MANUALPROVIDER.getCurrent();
            if (providerName == null || providerName.isBlank()) {
                return;
            }
            communicator = this.manager.getCommunicator(providerName);
        }
        if (communicator == null) {
            throw new ClientMessageException("no communicator");
        }
        ResponseHandler handler = new ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(@Nonnull AIResponse response) {
                RewriteExecuter executer;
                HDLogger.info("Rewrite: " + response.getResponseText());
                RewriteExecuter rewriteExecuter = executer = RewriteExecuter.this;
                synchronized (rewriteExecuter) {
                    executer.response = response;
                    executer.notifyAll();
                }
            }
        };
        Object systemPrompt = "**Role:** You are an AI rewrite assistant specialized in adjusting the tone of written text to match a specific communication style.\n**Objective:** When given a piece of input text and a desired tone, your goal is to rewrite the text to match the target tone while preserving the original meaning and intent.\n**Instructions:**\n* **Language:** *ALWAYS* respond entirely in the *SAME* language, as the source text.\n    * **Content Fidelity:** Do *NOT* invent new content. Retain all important factual and contextual information from the original.\n    * **Formatting:**\n        * Preserve any structural formatting (paragraphs, emphasis) where possible.\n        * Structure your answer using paragraphs (`<p>`) and lists (`<ul>`, `<ol>`) if appropriate. Use simple HTML tags and avoid overly complex HTML or CSS in the generated content.\n    * **Conciseness:** Keep the rewritten text as short and direct as the original, unless the tone requires minor elaboration.\n    * **Style Fidelity:** If the target tone requires specific traits (e.g., persuasive tone should include stronger calls to action), reflect that clearly.\n    * **HTML Structure:** If the input contains HTML tags or inline styles, you MUST preserve them exactly. Do NOT add new styles or attributes. The output *MUST* be valid, well-formed HTML with the original structure and styling intact.\n    * **Placeholders:** *NEVER* output or repeat placeholders like {userDisplayName}. If placeholders are present, remove them and adapt the sentence so it still makes sense.\n    * **NO META:** Do not mention the fact that you rewrote the text or reference these instructions.\n    * **Output Only:** Provide only the rewritten text. Do NOT explain the changes, and do NOT include notes or commentary.\n";
        systemPrompt = (String)systemPrompt + "* **Target Tone Transformations:** **" + this.toneDescriptions.get(this.tone) + "**!";
        String extra = (String)EXTRA_REWRITE_INSTRUCTIONS.get();
        if (extra != null && !extra.isBlank()) {
            systemPrompt = (String)systemPrompt + "\n\n" + extra.trim();
        }
        AIRequest request = new AIRequest("Text Rewrite", this.text, handler, null, null);
        request.setSystemPrompt((String)systemPrompt);
        request.setForceTool(true);
        if (this.clientId != null) {
            request.setStreaming(true);
            request.setStreamHandler(chunk -> {
                AIChunk aiChunk = new AIChunk();
                aiChunk.id = chunk.getChunkingGroupGUID().toString();
                aiChunk.text = chunk.getText();
                WebSocketEventHandler.getInstance().sendEvent(this.clientId, () -> new WebSocketEventData(AI_CHUNK_EVENT, (Object)aiChunk));
            });
        }
        communicator.runRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelExecution() {
        RewriteExecuter executer;
        RewriteExecuter rewriteExecuter = executer = this;
        synchronized (rewriteExecuter) {
            executer.response = null;
            executer.canceled = true;
            executer.notifyAll();
        }
    }

    @JsonData
    public static class AIChunk {
        private String id;
        private String text;
    }
}

