/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.model.ConfigSearchSuggestion;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplateDescription;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplatesHelper;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MailTemplatesConfigPage
implements ConfigPage {
    public String getPageKey() {
        return "configuration.mailtemplates";
    }

    public String getParentKey() {
        return "configuration.templates";
    }

    public String getShortDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]);
    }

    public String getFullDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates.fulldisplayname", new Object[0]);
    }

    public String getDescription() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/config/mailtemplates/images/mailtemplates_48.png");
    }

    public String getRelativeTemplateUrl() {
        return "weblib/configuration.mailtemplates.html";
    }

    public boolean isAccessAllowed() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        return SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION});
    }

    public String getHelpKey() {
        return "configuration.mailtemplates";
    }

    public List<ConfigSearchSuggestion> getSearchSuggestions(String searchTerm, Map<String, String> properties) {
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        searchTerm = searchTerm.toLowerCase();
        if (HelpdeskServerPlugin.CONFIG_PAGE_MAILTEMPLATE.getFullDisplayName().toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.CONFIG_PAGE_MAILTEMPLATE.getFullDisplayName(), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.templates", new Object[0]), 20, true));
        }
        if (HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.sendoptions", new Object[0]).toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.sendoptions", new Object[0]), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0, true));
        }
        if (HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.templatedefinition", new Object[0]).toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.templatedefinition", new Object[0]), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0, true));
        }
        if (HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.set", new Object[0]).toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.set", new Object[0]), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0, true));
        }
        if (HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.format", new Object[0]).toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.format", new Object[0]), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0, true));
        }
        if (HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.order", new Object[0]).toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.mailtemplates.order", new Object[0]), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0, true));
        }
        if (HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.set", new Object[0]).toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.set", new Object[0]), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0, true));
        }
        if (HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.lang", new Object[0]).toLowerCase().contains(searchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.lang", new Object[0]), "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0, true));
        }
        ArrayList<String> sets = MailTemplatesManager.listSets();
        for (String set : sets) {
            String setName = "default".equals(set) ? HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.default", new Object[0]) : set;
            if (!setName.toLowerCase().contains(searchTerm)) continue;
            suggestions.add(new ConfigSearchSuggestion(setName, "page/configuration.mailtemplates", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.set", new Object[0]) + " (" + HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]) + ")", 0, true));
        }
        String set = properties.get("set");
        String lang = properties.get("lang");
        String mailformat = properties.get("mailformat");
        if (StringFunctions.isEmpty((String)set) || StringFunctions.isEmpty((String)mailformat)) {
            ConfigurationManager man = ConfigurationManager.getInstance();
            Configuration config = man.getCurrent();
            if (ConfigurationManager.getRecoveryConfiguration() != null) {
                config = man.get(ConfigurationManager.getRecoveryConfiguration());
            }
            if (StringFunctions.isEmpty((String)set)) {
                set = config.get(HDConfigKeys.AUTOMAIL_TEMPLATE_SET);
            }
            if (StringFunctions.isEmpty((String)mailformat)) {
                mailformat = config.get(HDConfigKeys.MAIL_FORMAT);
            }
        }
        if (StringFunctions.isEmpty((String)lang)) {
            lang = "default";
        }
        ArrayList<String> listTemplates = MailTemplatesManager.listTemplates(set, lang);
        ArrayList<MailTemplateDescription> templates = MailTemplatesHelper.templateStringToDescription(listTemplates, set, lang);
        MailTemplatesHelper.filterTemplateDescriptions(searchTerm, templates);
        for (MailTemplateDescription template : templates) {
            String label = template.getDescription() != null ? template.getDescription() : template.getName();
            String path = "page/configuration.mailtemplates/editmailtemplate/" + EncodingFunctions.encodeUrlPath((String)set) + "/" + EncodingFunctions.encodeUrlPath((String)lang) + "/" + EncodingFunctions.encodeUrlPath((String)template.getName()) + "/" + EncodingFunctions.encodeUrlPath((String)mailformat);
            suggestions.add(new ConfigSearchSuggestion(label, path, HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates", new Object[0]), 0));
        }
        return suggestions;
    }
}

