/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.AbstractIconConfigProperty;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.utils.TicketValuesImageResolver;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.ImageScaler;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

@JsonData
public class TicketValueIconConfigProperty
extends AbstractIconConfigProperty {
    public static final int[] ICON_SIZES = new int[]{16, 24, 32, 48, 64};
    private static final String ICON_LOADER_METHOD_NAME = "getScaledTicketValueIcon";
    private static final String VALUE_MAP_KEY = "TicketValueIcons";
    private List<String> additionalRequestedProperties = Arrays.asList("id", "typeId");
    private int typeId;

    public TicketValueIconConfigProperty(int sortid, String label, int typeId) {
        super(sortid, VALUE_MAP_KEY, label, ICON_LOADER_METHOD_NAME, ICON_SIZES);
        this.typeId = typeId;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The path is relative and we've already made sure it can contain no traversals")
    public static String storeIcons(List<String> serializedImageData, int typeId, int id, String oldRelativePath) {
        Object imagesConnector;
        URL imageURL;
        if (serializedImageData == null) {
            return null;
        }
        String imageData = serializedImageData.remove(0);
        if (imageData == null) {
            return null;
        }
        String relativePath = "data/" + typeId + "/" + id;
        boolean pathHasChanged = !relativePath.equals(oldRelativePath);
        HashMap iconMap = (HashMap)new Json().fromJson(imageData, HashMap.class, new Type[]{Integer.class, AbstractIconConfigProperty.UploadedIconDescription.class});
        if (pathHasChanged && oldRelativePath != null && oldRelativePath.startsWith("data/" + typeId + "/")) {
            TicketValuesImageResolver.getInstance().copyIcons(oldRelativePath, relativePath);
            if (iconMap == null || iconMap.isEmpty()) {
                return relativePath;
            }
        }
        if (iconMap == null || iconMap.isEmpty()) {
            return null;
        }
        if (!pathHasChanged && !StringFunctions.isEmpty((String)oldRelativePath) && iconMap.get(16) == null && (imageURL = (imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class)).resolveImageURL(oldRelativePath, 16)) != null) {
            try (InputStream in = imageURL.openStream();){
                ImageScaler.ImageScalerResult result = ImageScaler.scale((InputStream)in, (int)16);
                String imgData = "data:image/png;base64," + Base64.getEncoder().encodeToString(result.getImageData());
                TicketValuesImageResolver.getInstance().storeIcon(relativePath, imgData, 16);
            }
            catch (Throwable t) {
                HDLogger.error(t);
            }
        }
        for (Map.Entry iconEntry : iconMap.entrySet()) {
            if (!StringFunctions.isEmpty((String)((AbstractIconConfigProperty.UploadedIconDescription)iconEntry.getValue()).getData())) {
                TicketValuesImageResolver.getInstance().storeIcon(relativePath, ((AbstractIconConfigProperty.UploadedIconDescription)iconEntry.getValue()).getData(), (Integer)iconEntry.getKey());
                continue;
            }
            TicketValuesImageResolver.getInstance().removeIcon(relativePath, (Integer)iconEntry.getKey());
        }
        List<Integer> availableSizes = TicketValuesImageResolver.getInstance().getAvailableSizes(relativePath);
        if (availableSizes.isEmpty()) {
            if (!StringFunctions.isEmpty((String)oldRelativePath)) {
                return "";
            }
            return null;
        }
        if (pathHasChanged) {
            return relativePath;
        }
        return null;
    }

    private static String getSerializedImageProperty(Map<String, String> element) {
        if (element == null) {
            return null;
        }
        return element.remove(VALUE_MAP_KEY);
    }

    public static void prepareConfigValueMapForIcons(Map<String, String> valueMap) {
        valueMap.put(VALUE_MAP_KEY, TicketValueIconConfigProperty.getEntryValue((int[])new int[0]));
    }

    public static List<String> getSerializedImageData(List<Map<String, String>> valueMapsFromClient) {
        LinkedList<String> serializedImageData = new LinkedList<String>();
        valueMapsFromClient.forEach(element -> serializedImageData.add(TicketValueIconConfigProperty.getSerializedImageProperty(element)));
        return serializedImageData;
    }
}

