/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.lib.core.OS;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.SuppressFBWarnings;

public class HelpDeskInstanceName {
    private static String INSTANCE_NAME;

    protected HelpDeskInstanceName() {
    }

    public static String get() {
        if (INSTANCE_NAME == null) {
            INSTANCE_NAME = new HelpDeskInstanceName().getInstanceName();
        }
        return INSTANCE_NAME;
    }

    String getInstanceName() {
        Path installDir = this.getInstallDir();
        if (this.isMac() && installDir.toString().endsWith("Java")) {
            installDir = installDir.getParent().getParent();
        }
        return this.getConfigurationName(installDir);
    }

    protected Path getInstallDir() {
        return Paths.get(System.getProperty("user.dir"), new String[0]).getParent().toAbsolutePath();
    }

    protected String getEnvironmentVar(String envVar) {
        return System.getenv(envVar);
    }

    protected boolean isWindows() {
        return OS.isWindows();
    }

    protected boolean isMac() {
        return OS.isMac();
    }

    protected Path getMacApplicationsDir() {
        return Paths.get("/Applications", new String[0]);
    }

    protected Path getUsrShareDir() {
        return Paths.get("/usr/share", new String[0]);
    }

    String getConfigurationName(Path installDir) {
        try {
            installDir = installDir.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path parentPath = installDir.getParent();
        if (this.isWindows()) {
            return this.getInstanceNameWindows(installDir, parentPath);
        }
        return this.getInstanceNameNonWindows(installDir, parentPath);
    }

    private String getInstanceNameNonWindows(Path installDir, Path parentPath) {
        String name = installDir.toFile().getName();
        Path appDir = this.isMac() ? this.getMacApplicationsDir() : this.getUsrShareDir();
        try {
            if (Files.isSameFile(parentPath, appDir)) {
                if (this.isMac() && name.endsWith(".app")) {
                    name = name.substring(0, name.length() - ".app".length());
                }
                return name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return name + "_" + Integer.toHexString(installDir.toString().hashCode());
    }

    private String getInstanceNameWindows(Path installDir, Path parentPath) {
        String name = installDir.toFile().getName();
        ArrayList<String> programFileLocations = new ArrayList<String>(){
            {
                this.add("ProgramFiles");
                this.add("ProgramFiles(x86)");
                this.add("ProgramW6432");
            }
        };
        Function<String, Path> envVarToPath = new Function<String, Path>(){

            @Override
            @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="no user input")
            public Path apply(String envVarName) {
                String envVar = HelpDeskInstanceName.this.getEnvironmentVar(envVarName);
                return envVar == null ? null : new File(envVar).toPath();
            }
        };
        Predicate<Path> isSameFileAsParentPath = path -> {
            try {
                return Files.isSameFile(parentPath, path);
            }
            catch (IOException e) {
                return false;
            }
        };
        boolean isParentPathAStandardProgramFilesDir = programFileLocations.stream().map(envVarToPath).filter(Objects::nonNull).anyMatch(isSameFileAsParentPath);
        return isParentPathAStandardProgramFilesDir ? name : name + "_" + Integer.toHexString(installDir.toString().toLowerCase().hashCode());
    }
}

