/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import java.io.InputStream;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClearReportsAttachmentDisplayProvider
implements AttachmentDisplayProvider {
    @Override
    public String getType() {
        return "thumbnail";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSourceOrContent(String mimeType, AttachmentRow attachment) {
        try {
            AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
            AttachmentFileRow attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength());
            if (attachmentFile == null) return null;
            PersistenceEntry file = AppDataLocation.getAttachmentFile(attachmentFile.getFilePath());
            if (!file.exists()) return null;
            try (ZipInputStream input = new ZipInputStream(file.getInputStream());){
                ZipEntry entry = null;
                while ((entry = input.getNextEntry()) != null) {
                    try {
                        if (!"Thumbnails/thumbnail.png".equals(entry.getName())) continue;
                        byte[] bytes = IOFunctions.readBytes((InputStream)input);
                        String string = "data:image/png;base64," + Base64.getEncoder().encodeToString(bytes);
                        return string;
                    }
                    finally {
                        input.closeEntry();
                    }
                }
                return null;
            }
        }
        catch (Throwable t) {
            LogManager.getApplicationLogger().error(t);
        }
        return null;
    }

    @Override
    public boolean isResponsible(String mimeType, AttachmentRow attachment) {
        String fileNameLowerCase;
        String fileName = attachment.getFileName();
        return fileName != null && (fileNameLowerCase = fileName.toLowerCase()).endsWith(".rpt");
    }
}

