/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultAddColumnCommand;
import com.inet.dbupdater.databases.commands.DefaultAddPrimaryCommand;
import com.inet.dbupdater.databases.commands.DefaultAddReferenceCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterColumnCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterDropCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterFunctionCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterIndexCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterPrimaryCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterProcedureCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterReferenceCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterSequenceCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterTriggerCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterViewCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.DefaultCreateDataCommand;
import com.inet.dbupdater.databases.commands.DefaultCreateFunctionCommand;
import com.inet.dbupdater.databases.commands.DefaultCreateIndexCommand;
import com.inet.dbupdater.databases.commands.DefaultCreatePrimaryIndexCommand;
import com.inet.dbupdater.databases.commands.DefaultCreateProcedureCommand;
import com.inet.dbupdater.databases.commands.DefaultCreateSequenceCommand;
import com.inet.dbupdater.databases.commands.DefaultCreateTableCommand;
import com.inet.dbupdater.databases.commands.DefaultCreateTriggerCommand;
import com.inet.dbupdater.databases.commands.DefaultCreateViewCommand;
import com.inet.dbupdater.databases.commands.DefaultSimpleCommand;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;

public class DefaultCommandFactory
implements ICommandFactory {
    private DatabaseInfos dbInfo;
    private DefaultCommandSyntax syntax;

    public DefaultCommandFactory(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
        this.syntax = new DefaultCommandSyntax(dbInfo);
    }

    protected void setSyntax(DefaultCommandSyntax syntax) {
        this.syntax = syntax;
    }

    public DefaultCommandSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public IComposedCommand getCommand(ICommandFactory.COMMAND_TYPE action, NodeFactory.TAG type, IDatabaseCommand.TIME purpose, Node containerNode, String name) {
        if (action == ICommandFactory.COMMAND_TYPE.create) {
            if (type == NodeFactory.TAG.table) {
                return new DefaultCreateTableCommand(this.dbInfo, this.syntax, containerNode);
            }
            if (type == NodeFactory.TAG.trigger) {
                return new DefaultCreateTriggerCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.view) {
                return new DefaultCreateViewCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.procedure) {
                return new DefaultCreateProcedureCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.function) {
                return new DefaultCreateFunctionCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.sequence) {
                return new DefaultCreateSequenceCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.data) {
                return new DefaultCreateDataCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.index) {
                if (name != null && name.equals("PRIMARY")) {
                    return new DefaultCreatePrimaryIndexCommand(this.dbInfo);
                }
                return new DefaultCreateIndexCommand(this.dbInfo, containerNode);
            }
        }
        if (action == ICommandFactory.COMMAND_TYPE.alter) {
            if (type == NodeFactory.TAG.database) {
                return null;
            }
            if (type == NodeFactory.TAG.table) {
                return null;
            }
            if (type == NodeFactory.TAG.column) {
                if (purpose == IDatabaseCommand.TIME.addstructure) {
                    return new DefaultAddColumnCommand(this.dbInfo, this.syntax, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.alterstructure) {
                    return new DefaultAlterColumnCommand(this.dbInfo, this.syntax, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.dropstructure) {
                    return new DefaultAlterDropCommand(this.dbInfo, this.syntax, containerNode);
                }
            }
            if (type == NodeFactory.TAG.trigger) {
                return new DefaultAlterTriggerCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.view) {
                return new DefaultAlterViewCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.procedure) {
                return new DefaultAlterProcedureCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.function) {
                return new DefaultAlterFunctionCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.sequence) {
                return new DefaultAlterSequenceCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.reference) {
                if (purpose == IDatabaseCommand.TIME.addstructure || purpose == IDatabaseCommand.TIME.addreferences) {
                    return new DefaultAddReferenceCommand(this.dbInfo, this.syntax, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.alterstructure || purpose == IDatabaseCommand.TIME.alterreferences) {
                    return new DefaultAlterReferenceCommand(this.dbInfo, this.syntax, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.dropstructure || purpose == IDatabaseCommand.TIME.dropreferences) {
                    return new DefaultAlterDropCommand(this.dbInfo, this.syntax, containerNode);
                }
            }
            if (type == NodeFactory.TAG.index) {
                if (purpose == IDatabaseCommand.TIME.addstructure || purpose == IDatabaseCommand.TIME.addreferences) {
                    if (name != null && name.equals("PRIMARY")) {
                        return new DefaultAddPrimaryCommand(this.dbInfo, containerNode);
                    }
                    return new DefaultCreateIndexCommand(this.dbInfo, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.alterstructure || purpose == IDatabaseCommand.TIME.alterreferences) {
                    if (name != null && name.equals("PRIMARY")) {
                        return new DefaultAlterPrimaryCommand(this.dbInfo, this.syntax, containerNode);
                    }
                    return new DefaultAlterIndexCommand(this.dbInfo, this.syntax, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.dropstructure || purpose == IDatabaseCommand.TIME.dropreferences) {
                    return new DefaultAlterDropCommand(this.dbInfo, this.syntax, containerNode);
                }
            }
        }
        return null;
    }

    @Override
    public IComposedCommand getPresetCommand(String command, boolean isUpdate, IDatabaseCommand.TIME execTime, boolean mayFail, boolean distinct) {
        return new DefaultSimpleCommand(command, this.dbInfo, isUpdate, execTime, mayFail, distinct ? command : null);
    }
}

