/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.BaseAlterColumnCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultAlterIndexCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private String statement;
    private final DefaultCommandSyntax syntax;

    public DefaultAlterIndexCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        this.syntax = syntax;
        this.name = tableName;
        this.dbInfo = dbInfo;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.alterstructure;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        String refName = IDatabaseInfos.INDEX_PARAM.index_name.toString();
        this.statement = "";
        if (this.syntax.useTableNameOnDropIndex()) {
            this.statement = "ALTER TABLE " + ((ISchemaNode)((Object)this.name)).getSourceName(this.dbInfo);
        }
        this.statement = this.statement + " DROP " + this.syntax.getDropNameOnDropIndex() + " " + this.dbInfo.getQuote(element.getParameter(refName));
        IComposedCommand command = this.dbInfo.getCommandFactory().getCommand(action, NodeFactory.TAG.index, IDatabaseCommand.TIME.addreferences, this.name, refName);
        return IComposedCommand.createCommandList(command, element, action);
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return action == ICommandFactory.COMMAND_TYPE.alter && element != null && element.getName() == NodeFactory.TAG.index && "true".equals(element.getParameter(IDatabaseInfos.INDEX_PARAM.isprimarykey.toString()));
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        return this.statement;
    }

    public List<IComposedCommand> wrapInReferenceUnbind(Node indexElement, List<IComposedCommand> commandsToWrap) throws SQLException {
        ICommandFactory factory = this.dbInfo.getCommandFactory();
        List<BaseAlterColumnCommand.ReferenceNodeData> allRefs = this.getAllRefs(indexElement, false);
        if (!allRefs.isEmpty()) {
            ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
            for (BaseAlterColumnCommand.ReferenceNodeData ref : allRefs) {
                IComposedCommand dropRef = factory.getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.reference, IDatabaseCommand.TIME.dropreferences, ref.getOldNode().getParent(), null);
                commands.add(dropRef);
                IComposedCommand.addToList(commands, dropRef.addDataset(ref.getOldNode(), ICommandFactory.COMMAND_TYPE.remove));
            }
            commands.addAll(commandsToWrap);
            for (BaseAlterColumnCommand.ReferenceNodeData ref : allRefs) {
                if (ref.getNewNode() == null) continue;
                IComposedCommand addRef = factory.getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.reference, IDatabaseCommand.TIME.addreferences, ref.getOldNode().getParent(), null);
                commands.add(addRef);
                IComposedCommand.addToList(commands, addRef.addDataset(ref.getNewNode(), ICommandFactory.COMMAND_TYPE.create));
            }
            return commands;
        }
        return commandsToWrap;
    }

    protected List<BaseAlterColumnCommand.ReferenceNodeData> getAllRefs(Node index, boolean onTable) {
        String refColumn = onTable ? null : index.getParameter(IDatabaseInfos.INDEX_PARAM.column_name.name());
        String refTable = index.getParent().getParameter(IDatabaseInfos.TABLE_PARAM.name.name());
        Node thisTable = index.getParent();
        Node database = thisTable.getParent();
        Map<String, Node> allTablesSource = database.getDiffSource().getChildren(NodeFactory.TAG.table).stream().collect(Collectors.toMap(node -> node.getParameter(IDatabaseInfos.TABLE_PARAM.name.name()), item -> item));
        Map<String, Node> allTablesTarget = database.getDiffTarget().getChildren(NodeFactory.TAG.table).stream().collect(Collectors.toMap(node -> node.getParameter(IDatabaseInfos.TABLE_PARAM.name.name()), item -> item));
        HashMap<String, Node> sourceRefs = new HashMap<String, Node>();
        ArrayList<BaseAlterColumnCommand.ReferenceNodeData> refs = new ArrayList<BaseAlterColumnCommand.ReferenceNodeData>();
        for (Map.Entry<String, Node> table : allTablesSource.entrySet()) {
            Node node2 = this.getReferenceBind(table.getValue(), refColumn, refTable);
            if (node2 == null) continue;
            if (allTablesTarget.containsKey(table.getKey())) {
                sourceRefs.put(node2.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name()), node2);
                continue;
            }
            refs.add(new BaseAlterColumnCommand.ReferenceNodeData(node2, null));
        }
        HashMap<String, Node> targetRefs = new HashMap<String, Node>();
        for (Node node3 : allTablesTarget.values()) {
            Node ref = this.getReferenceBind(node3, refColumn, refTable);
            if (ref == null) continue;
            targetRefs.put(ref.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name()), ref);
        }
        for (Map.Entry entry : sourceRefs.entrySet()) {
            Node newRef = (Node)targetRefs.get(entry.getKey());
            if (newRef == null) continue;
            refs.add(new BaseAlterColumnCommand.ReferenceNodeData((Node)entry.getValue(), newRef));
        }
        return refs;
    }

    private Node getReferenceBind(Node table, String refColumn, String refTable) {
        List<? extends Node> refs = table.getChildren(NodeFactory.TAG.reference);
        if (refs == null || refs.size() == 0) {
            return null;
        }
        for (Node node : refs) {
            if (refColumn != null && !refColumn.equalsIgnoreCase(node.getParameter(IDatabaseInfos.REFERENCE_PARAM.pkcolumn_name.name())) || !refTable.equalsIgnoreCase(node.getParameter(IDatabaseInfos.REFERENCE_PARAM.pktable_name.name()))) continue;
            return node;
        }
        return null;
    }
}

