/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.usersandgroups.user.fields.HDUserField;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class FieldUserClassID
extends HDUserField<Integer>
implements HasSelectOptions {
    public static final String KEY = "groupid";
    private static final int DEFAULT_GROUP_ID = 0;

    public FieldUserClassID() {
        super(KEY, 0, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldTypeSelect_Int createFieldType() {
        return new FieldTypeSelect_Int(KEY, () -> this.getLabel(), this){

            public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(FieldUserClassID.KEY, SearchDataType.IntegerMap, false, 850, labelProvider){

                    public Map<Integer, String> getMapData() {
                        return UserClassManager.getInstance().getAllDisplayNames(false);
                    }
                });
            }
        };
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfNegative((int)value);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List allUserClasses = UserClassManager.getInstance().getAll(!includeDeleted);
        return allUserClasses.stream().map(c -> new SelectOption("" + c.getId(), c.getDisplayValue())).collect(Collectors.toList());
    }
}

