/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.values;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.ui.fields.values.AllowedActionsItem;
import com.inet.helpdesk.usersandgroups.ui.fields.values.AllowedActionsItemGroup;
import com.inet.lib.json.Json;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@JsonData
public class AllowedActionsFieldValue
extends FieldValue {
    private List<AllowedActionsItemGroup> actionGroups;
    private AllowedActionsItemGroup generalGroup;

    public AllowedActionsFieldValue(Set<Integer> selectedActions, Set<Integer> inheritActions, boolean showSupporterActions) {
        super(new Json().toJson(selectedActions));
        List<AllowedActionsItemGroup> modelList = AllowedActionsFieldValue.createModelList(selectedActions, inheritActions, showSupporterActions);
        this.generalGroup = modelList.get(0);
        this.actionGroups = modelList.subList(1, modelList.size());
    }

    public static List<AllowedActionsItemGroup> createModelList(Set<Integer> selectedActions, Set<Integer> inheritActions, boolean showSupporterActions) {
        ArrayList<AllowedActionsItemGroup> result = new ArrayList<AllowedActionsItemGroup>();
        ArrayList<AllowedActionsItem> allgemein = new ArrayList<AllowedActionsItem>();
        result.add(new AllowedActionsItemGroup(allgemein, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.general", new Object[0])));
        AllowedActionsFieldValue.addItemIfPresent(allgemein, 4, selectedActions, inheritActions);
        AllowedActionsFieldValue.addItemIfPresent(allgemein, -12, selectedActions, inheritActions);
        AllowedActionsFieldValue.addItemIfPresent(allgemein, 2, selectedActions, inheritActions);
        AllowedActionsFieldValue.addItemIfPresent(allgemein, 7, selectedActions, inheritActions);
        AllowedActionsFieldValue.addItemIfPresent(allgemein, -2, selectedActions, inheritActions);
        AllowedActionsFieldValue.addItemIfPresent(allgemein, -21, selectedActions, inheritActions);
        AllowedActionsFieldValue.addItemIfPresent(allgemein, -6, selectedActions, inheritActions);
        AllowedActionsFieldValue.addItemIfPresent(allgemein, -39, selectedActions, inheritActions);
        AllowedActionsFieldValue.sort(allgemein);
        if (showSupporterActions) {
            ArrayList<AllowedActionsItem> supporter = new ArrayList<AllowedActionsItem>();
            result.add(new AllowedActionsItemGroup(supporter, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.supporter", new Object[0])));
            AllowedActionsFieldValue.addItemIfPresent(supporter, 1, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter, -7, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter, -3, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter, 10, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter, -25, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter, 5, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter, 8, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter, -22, selectedActions, inheritActions);
            List all = ActionManager.getInstance().getAll(true);
            for (ActionVO actionVO : all) {
                if ((actionVO.getSpecial() & 4) > 0 || actionVO.getId() >= -39 && actionVO.getId() <= 10 && actionVO.getId() != 9) continue;
                AllowedActionsFieldValue.addItemIfPresent(supporter, actionVO.getId(), selectedActions, inheritActions);
            }
            AllowedActionsFieldValue.sort(supporter);
            ArrayList<AllowedActionsItem> supporter_organisation = new ArrayList<AllowedActionsItem>();
            result.add(new AllowedActionsItemGroup(supporter_organisation, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.supporter_organization", new Object[0])));
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -1, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -13, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -19, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -34, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -33, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -35, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -37, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(supporter_organisation, -38, selectedActions, inheritActions);
            AllowedActionsFieldValue.sort(supporter_organisation);
            ArrayList<AllowedActionsItem> felder = new ArrayList<AllowedActionsItem>();
            result.add(new AllowedActionsItemGroup(felder, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.fields", new Object[0])));
            AllowedActionsFieldValue.addItemIfPresent(felder, -31, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -30, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -29, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -26, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -28, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -27, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, 3, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -10, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -17, selectedActions, inheritActions);
            AllowedActionsFieldValue.addItemIfPresent(felder, -15, selectedActions, inheritActions);
            AllowedActionsFieldValue.sort(felder);
        }
        return result;
    }

    private static void addItemIfPresent(List<AllowedActionsItem> list, int actionId, Set<Integer> selectedActions, Set<Integer> inheritActions) {
        ActionManager manager = ActionManager.getInstance();
        ActionVO actionVO = (ActionVO)manager.get(actionId);
        if (actionVO != null) {
            AllowedActionsItem allowedActionsItem = new AllowedActionsItem(actionVO, selectedActions.contains(actionId), inheritActions.contains(actionId));
            list.add(allowedActionsItem);
        }
    }

    private static void sort(List<AllowedActionsItem> group) {
        Collections.sort(group, (item1, item2) -> item1.getName().compareTo(item2.getName()));
    }
}

