/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.valueprovider;

import com.inet.helpdesk.plugins.reporting.server.valueprovider.HelpdeskValueProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.report.DefaultValue;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ResourceProvider
extends HelpdeskValueProvider {
    private static final String PROMPT_FIELD_NAME = "{?ResID}";

    @Override
    public String getPromptName() {
        return PROMPT_FIELD_NAME;
    }

    public void getDefaultValues(Function<DefaultValue, Boolean> func) {
        UserGroupManager um = UserGroupManager.getInstance();
        List resources = um.getGroups(HDUsersAndGroups.RESOURCE).stream().filter(g -> g.isActive()).collect(Collectors.toList());
        resources.stream().sorted((a, b) -> this.getFullName((UserGroupInfo)a).compareToIgnoreCase(this.getFullName((UserGroupInfo)b))).forEach(res -> func.apply(new DefaultValue((Object)((Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)), (this.getResourceParentID((UserGroupInfo)res) != 0 ? "\u00a0- " : "") + res.getName(), 6)));
    }

    private String getFullName(UserGroupInfo resource) {
        if (this.getResourceParentID(resource) > 0) {
            GUID parentGUID = resource.getParentID();
            UserGroupInfo parentResource = UserGroupManager.getInstance().getGroup(parentGUID);
            return parentResource.getName() + "\\" + resource.getName();
        }
        return resource.getName();
    }

    private int getResourceParentID(UserGroupInfo resource) {
        Integer value;
        UserGroupInfo parentResource;
        GUID parentGUID = resource.getParentID();
        if (parentGUID != null && (parentResource = UserGroupManager.getInstance().getGroup(parentGUID)) != null && (value = (Integer)parentResource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)) != null) {
            return value;
        }
        return 0;
    }
}

