/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.itil;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.plugin.ServerPluginManager;

public class ItilChangedTicketEventListener
implements TicketEventListener {
    @Override
    public void handleEvent(TicketEvent event) {
        event.getChangedTickets().forEach(ct -> {
            TicketVO oldTicket = ct.getOldTicket();
            TicketVO newTicket = ct.getNewTicket();
            if (oldTicket != null && newTicket != null && oldTicket.getItilID() != newTicket.getItilID()) {
                int oldItil = oldTicket.getItilID();
                int newItil = newTicket.getItilID();
                ItilManager man = ItilManager.getInstance();
                ItilVO oldOne = (ItilVO)man.get(oldItil);
                ItilVO newOne = (ItilVO)man.get(newItil);
                if (newOne.isMasterType() != oldOne.isMasterType()) {
                    if (oldOne.isMasterType()) {
                        ((ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class)).removeAllLinksToItilMaster(ct.getTicketID());
                    } else {
                        ((ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class)).removeLinkFromItilSlaveToItilMaster(ct.getTicketID());
                    }
                }
            }
        });
    }
}

